<?php
/**
 * JComments plugin for OS Property
 * @package    plg_osproperty_jcomments
 * @subpackage Plugin
 * @link       http://www.joomdonation.com
 * @license    GNU/GPL, see LICENSE.php
 */
 defined( '_JEXEC' ) or die( 'Restricted access' );

// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgOspropertyJComments extends JPlugin
{
	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
		JPlugin::loadLanguage('plg_osproperty_jcomments', JPATH_ADMINISTRATOR);
	}

	public function onOspropertyCommentsBlock(&$item, &$params, $limitstart)
	{
		$result = '';

        	$commentsAPI = JPATH_SITE . '/components/com_jcomments/jcomments.php';
	 	if (is_file($commentsAPI)) {
	 		require_once($commentsAPI);
 			$result = JComments::show($item->id, 'com_osproperty', $item->title);
		}
		return $result;
	}

	public function onOspropertyCommentsCounter(&$item, &$params, $limitstart)
	{
		$result = '';

	       	$commentsAPI = JPATH_SITE . '/components/com_jcomments/jcomments.php';
	 	if (is_file($commentsAPI)) {
	 		require_once($commentsAPI);
			$count = JComments::getCommentsCount($item->id, 'com_osproperty');

	 		if ($count == 0) {
	 			$link = $item->link.'#addcomments';
	 			$text = JText::_('PLG_OSPROPERTY_JCOMMENTS_LINK_ADD_COMMENT');
			} else {
	 			$link = $item->link.'#comments';
	 			$text = JText::sprintf('PLG_OSPROPERTY_JCOMMENTS_LINK_READ_COMMENTS', $count);
	 		}

	 		$anchor_css = $this->params->get('anchor_css');
	 		$class = empty($anchor_css) ? '' : ' class="' . $anchor_css . '"';

	 		$result = '<a href="' . $link . '"' . $class . ' title="' . $text . '">' . $text . '</a>';
		}
		return $result;
	}

	public function onAfterOspropertySave(&$item, $isNew)
	{
	        if ($this->params->get('autosubscribe')) {
			if (!empty($item->id) && !empty($item->created_by) && $isNew) {
		        	$commentsAPI = JPATH_SITE . '/components/com_jcomments/jcomments.php';
			 	if (is_file($commentsAPI)) {
			 		require_once($commentsAPI);
					require_once(JPATH_SITE . '/components/com_jcomments/jcomments.subscription.php');
					$manager = JCommentsSubscriptionManager::getInstance();
					$manager->subscribe($item->id, 'com_osproperty', $item->created_by);
				}
			}
		}
		return true;		
	}
}