<?php
/**
 * @package         Cache Cleaner
 * @version         9.7.5
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\Console\CacheCleaner\CliCommand;

defined('_JEXEC') or die;

use Joomla\Console\Command\AbstractCommand;
use RegularLabs\Plugin\System\CacheCleaner\Cache;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class RunCommand extends AbstractCommand
{
    protected static $defaultName = 'cachecleaner:clean';

    protected function doExecute(InputInterface $input, OutputInterface $output): int
    {
        $symfonyStyle = new SymfonyStyle($input, $output);

        $symfonyStyle->title('Cleaning System Cache');

        Cache::clean();

        $symfonyStyle->success('Cache cleaned');

        return Command::SUCCESS;
    }

    protected function configure(): void
    {
        $this->setDescription('This command cleans the cache via Cache Cleaner');
        $this->setHelp(
            <<<EOF
The <info>%command.name%</info> command cleans the cache via Cache Cleaner
<info>php %command.full_name%</info>
EOF
        );
    }
}
