<?php
/**
 * @package         Joomla.Plugin
 * @subpackage      Captcha.jdcaptcha
 * @author          Tuan Pham Ngoc
 *
 * @copyright       Copyright (C) 2024 JoomDonation Team
 * @license         GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use JoomDonation\Plugin\Captcha\JDCaptcha\Extension\JDCaptcha;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;

return new class () implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 */
	public function register(Container $container)
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$config = (array) PluginHelper::getPlugin('captcha', 'jdcaptcha');

				if (ComponentHelper::isEnabled('com_kunena'))
				{
					$config['public_key'] = 'fake_public_key';
					$config['private_key'] = 'fake_private_key';
				}

				return new JDCaptcha(
					$container->get(DispatcherInterface::class),
					Factory::getApplication(),
					$config,
				);
			}
		);
	}
};
