<?php
/**
 * eWAY Rapid Response
 */

namespace Omnipay\Eway\Message;

use Omnipay\Common\Message\RedirectResponseInterface;

/**
 * eWAY Rapid Response
 *
 * This is the response class for Rapid Direct & Transparent Redirect (Rapid)
 *
 */
class RapidResponse extends AbstractResponse implements RedirectResponseInterface
{
    public function isRedirect()
    {
        return isset($this->data['FormActionURL']);
    }

    public function getRedirectUrl()
    {
        return isset($this->data['FormActionURL']) ? $this->data['FormActionURL'] : null;
    }

    public function getRedirectMethod()
    {
        return 'POST';
    }

    public function getRedirectData()
    {
        if ($this->isRedirect()) {
            return array(
                'EWAY_ACCESSCODE' => $this->data['AccessCode'],
            );
        }
    }

    /**
     * Is the response a transparent redirect?
     *
     * @return boolean
     */
    public function isTransparentRedirect()
    {
        return true;
    }

    /**
     * Get a card reference (eWAY Token), for createCard requests.
     *
     * @return string|null
     */
    public function getCardReference()
    {
        if (isset($this->data['Customer']['TokenCustomerID'])) {
            return $this->data['Customer']['TokenCustomerID'];
        }
        if (isset($this->data['TokenCustomerID'])) {
            // This format appears when creating a card and making a concurrent
            // payment using Shared or Transparent redirect methods.
            return $this->data['TokenCustomerID'];
        }

        return null;
    }

    /**
     * Get the transaction ID as generated by the merchant website.
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->data['InvoiceNumber'];
    }

    /**
     * Get InvoiceNumber - merchant reference for a transaction
     *
     * @deprecated Omnipay standard interface is to return this when getTransactionId
     * is called
     *
     * @see https://github.com/thephpleague/omnipay#successful-response
     */
    public function getInvoiceNumber()
    {
        return $this->data['InvoiceNumber'];
    }
}
