<?php
/**
 * @version		1.0.0
 * @package		Joomla
 * @subpackage	OS Calendar
 * @author  	Dang Thuc Dam
 * @copyright	Copyright (C) 2013 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined( '_JEXEC' ) or die();
error_reporting(E_ERROR | E_PARSE | E_COMPILE_ERROR);
/**
 * 
 * Build the route for the com_osproperty component
 * @param	array	An array of URL arguments
 * @return	array	The URL arguments to use to assemble the subsequent URL.
 * @since	1.5
 */
class OscalendarRouter extends JComponentRouterBase
{
	function build(&$query)
	{
		include_once(JPATH_ROOT.'/components/com_oscalendar/helpers/helper.php');
		include_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
		$db = JFactory::getDbo();
		$db->setQuery("Select config_value from #__oscalendar_configuration where config_key like 'allow_room'");
		$allow_room = $db->loadResult();
		$segments = array();
		$db = JFactory::getDbo();
		$queryArr = $query;
		if (isset($queryArr['option']))
			unset($queryArr['option']);
		if (isset($queryArr['Itemid']))
			unset($queryArr['Itemid']);
		//Store the query string to use in the parseRouter method
		$queryString = http_build_query($queryArr);
		
		$app		= JFactory::getApplication();
		$menu		= $app->getMenu();
		
		//We need a menu item.  Either the one specified in the query, or the current active one if none specified
		if (empty($query['Itemid']))
			$menuItem = $menu->getActive();
		else
			$menuItem = $menu->getItem($query['Itemid']);
		
		if (empty($menuItem->query['view']))
		{
			$menuItem->query['view'] = '';
		}
		//echo $menuItem->alias;
		$view = isset($query['view']) ? $query['view'] : '';
		$id = 	isset($query['id']) ? (int) $query['id'] : 0;
		$task = isset($query['task']) ? $query['task'] : '';
		if($task == ""){
			switch ($view)
			{
				case "myorders":
					$task = "customer_default";
				break;
			}
		}
		switch ($task){
			case "room_manage":
				if(isset($query['pid'])){
					$id = $query['pid'];
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__osrs_properties where id = '$id'");
					$property   = $db->loadObject();
					include_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
					$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
					$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
					
					if($pro_alias != ""){
						$segs = $pro_alias;
					}else{
						$segs = $pro_name;
					}
					$segments[] = $segs;
					$segments[] = JText::_('OS_MANAGE_ROOMS');
					unset($query['pid']);
				}
			break;
			case "room_edit":
				if(isset($query['pid'])){
					$id = $query['pid'];
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__osrs_properties where id = '$id'");
					$property   = $db->loadObject();
					include_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
					$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
					$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
					
					if($pro_alias != ""){
						$segs = $pro_alias;
					}else{
						$segs = $pro_name;
					}
					$segments[] = $segs;
					unset($query['pid']);
				}
				if(isset($query['cid'])){
					$id = $query['cid'];
					$id = $id[0];
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__oscalendar_rooms where id = '$id'");
					$room   = $db->loadObject();
					$segments[] = JText::_('OS_ROOM')."_".$room->room_name." ".$id;
					$segments[] = JText::_('OS_EDIT_ROOM');
					unset($query['cid']);
				}
			break;
			case "price_setup":
				if(isset($query['pid'])){
					$id = $query['pid'];
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__osrs_properties where id = '$id'");
					$property   = $db->loadObject();
					include_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
					$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
					$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
					
					if($pro_alias != ""){
						$segs = $pro_alias;
					}else{
						$segs = $pro_name;
					}
					$segments[] = $segs;
					unset($query['pid']);
				}
				if(isset($query['rid'])){
					$id = $query['rid'];
					//$id = $id[0];
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__oscalendar_rooms where id = '$id'");
					$room   = $db->loadObject();
					$segments[] = JText::_('OS_ROOM')."_".$room->room_name." ".$id;
					$segments[] = JText::_('OS_SETUP_PRICE');
					unset($query['rid']);
				}
			break;
			case "form_step1":
				if(isset($query['pid'])){
					$id = $query['pid'];
					$db->setQuery("Select id, pro_alias, pro_name from #__osrs_properties where id = '$id'");
					$property   = $db->loadObject();
					$pro_alias  = $property->pro_alias;
					$pro_name   = $property->pro_name;
					
					if($pro_alias != ""){
						$segs = $pro_alias;
					}else{
						$segs = $pro_name;
					}
					$segments[] = $segs;
					unset($query['pid']);
				}
				$segments[] = JText::_('OS_CHECKOUT');
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
			break;
			case "form_step2":
				
				$cClass = OSCHelper::getConfiguration();
				if(isset($query['pid'])){
					$id = $query['pid'];
					$db->setQuery("Select id, pro_alias, pro_name from #__osrs_properties where id = '$id'");
					$property   = $db->loadObject();
					$pro_alias  = $property->pro_alias;
					$pro_name   = $property->pro_name;
					
					if($pro_alias != ""){
						$segs = $pro_alias;
					}else{
						$segs = $pro_name;
					}
					$segments[] = $segs;
					unset($query['pid']);
				}
				
				$date = "";
				if(isset($query['date_from'])){
					$date .= JText::_('OS_FROM')."_".date($cClass['date_format'],$query['date_from']);
					unset($query['date_from']);
				}
				if(isset($query['date_to'])){
					$date .= JText::_('OS_TO')."_".date($cClass['date_format'],$query['date_to']);
					unset($query['date_to']);
				}
				$segments[] = $date;
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
				$segments[] = JText::_('OS_CONFIRM');
			break;
			case "default_editPropertyConfig":
				$id = $query['pid'];
				$db->setQuery("Select id, pro_alias, pro_name from #__osrs_properties where id = '$id'");
				$property   = $db->loadObject();
				$pro_alias  = $property->pro_alias;
				$pro_name   = $property->pro_name;
				
				if($pro_alias != ""){
					$segs = $pro_alias;
				}else{
					$segs = $pro_name;
				}
				$segments[] = $segs;
				$segments[] = JText::_('OS_MANAGE_PRICE');
				unset($query['pid']);
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
			break;
			case "default_calendarmanage":
				$id = $query['pid'];
				$db->setQuery("Select * from #__osrs_properties where id = '$id'");
				$property   = $db->loadObject();
				$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
				$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
				
				if($pro_alias != ""){
					$segs = $pro_alias;
				}else{
					$segs = $pro_name;
				}
				$segments[] = $segs;
				$rid = $query['rid'];
				if($allow_room == 1) {
					$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
					$room = $db->loadObject();
					$room_name = OSPHelper::getLanguageFieldValue($room, 'room_name');
					$segments[] = $room_name;
				}
				$segments[] = JText::_('OS_MANAGE_AVAILABILITY_CALENDAR');
				$time = "";
				
				unset($query['pid']);
				unset($query['rid']);
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
			break;
			case "default_availability":
				$id = $query['pid'];
				$db->setQuery("Select * from #__osrs_properties where id = '$id'");
				$property   = $db->loadObject();
				$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
				$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
				
				if($pro_alias != ""){
					$segs = $pro_alias;
				}else{
					$segs = $pro_name;
				}
				$segments[] = $segs;
				$rid = $query['rid'];
				if($allow_room == 1) {
					$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
					$room = $db->loadObject();
					$room_name = OSPHelper::getLanguageFieldValue($room, 'room_name');
					$segments[] = $room_name;
				}
				$segments[] = JText::_('OS_AVAILABILITY_CALENDAR');
				unset($query['pid']);
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
				unset($query['pid']);
				unset($query['rid']);
			break;
			case "default_bookinglist":
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					$segments[] = JText::_('OS_LIST_ORDERS');
					unset($query['Itemid']);
				}
			break;
			case "price_edit":
				$id = $query['pid'];
				$db->setQuery("Select * from #__osrs_properties where id = '$id'");
				$property   = $db->loadObject();
				$pro_alias  = OSPHelper::getLanguageFieldValue($property,'pro_alias');
				$pro_name   = OSPHelper::getLanguageFieldValue($property,'pro_name');
				
				if($pro_alias != ""){
					$segs = $pro_alias;
				}else{
					$segs = $pro_name;
				}
				$segments[] = $segs;
				$rid = $query['rid'];
				if($allow_room == 1) {
					$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
					$room = $db->loadObject();
					$room_name = OSPHelper::getLanguageFieldValue($room, 'room_name');
					$segments[] = $room_name;
				}
				$cid = $query['cid'];
				$cid = $cid[0];
				if($cid > 0){
					$segments[] = JText::_('OS_EDIT_PRICE_PLAN');
					$db->setQuery("Select title from #__oscalendar_room_prices where id = '$cid'");
					$title = $db->loadResult();
					$segments[] = $title;
				}else{
					$segments[] = JText::_('OS_ADD_PRICE_PLAN');
				}
				unset($query['pid']);
				unset($query['rid']);
				unset($query['cid']);
			break;
			case "default_orderDetailsForm":
				$segments[] = JText::_('OS_ORDER_DETAILS');
				$id = $query['order_id'];
				$segments[] = $id;
				unset($query['order_id']);
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
			break;
			case "customer_default":
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					
					$segments[] = JText::_('OS_MY_ORDERS');
					unset($query['Itemid']);
				}
				
			break;
			case "default_completeorder":
				$segments[] = "Complete Order";
				if (!isset($query['Itemid']) or ($query['Itemid'] == 0) or ($query['Itemid'] == 99999) or ($query['Itemid'] == 9999)){
					unset($query['Itemid']);
				}
			break;
		}
		
		$app = JFactory::getApplication();
		if (isset($query['start']) || isset($query['limitstart']))
		{
			$limit = $app->input->getInt('limit',20);
			$limitStart = $app->input->getInt('limitstart',0);
			$page = ceil(($limitStart + 1) / $limit);
			$segments[] = JText::_('OS_PAGE').'-'.$page;
		}
		
		unset($query['start']);
		unset($query['limitstart']);
		unset($query['limit']);

		if (isset($query['task']))
			unset($query['task']);
		
		if (isset($query['layout']))
			unset($query['layout']);
		
		if (count($segments))
		{
			$segments = array_map('JApplicationHelper::stringURLSafe', $segments);
			$key = md5(implode('/', $segments));
			$q = $db->getQuery(true);
			$q->select('COUNT(*)')
				->from('#__oscalendar_urls')
				->where('md5_key="'.$key.'"');
			$db->setQuery($q);
			$total = $db->loadResult();
			if (!$total)
			{
				$q->clear();
				$q->insert('#__oscalendar_urls')
					->columns('md5_key, `query`')
					->values("'$key', '$queryString'");
				$db->setQuery($q);
				$db->execute();
			}
		}
			
		return $segments;
	}

	/**
	 * 
	 * Parse the segments of a URL.
	 * @param	array	The segments of the URL to parse.
	 * @return	array	The URL attributes to be used by the application.
	 * @since	1.5
	 */
	function parse(& $segments)
	{		
		$vars = array();
		if (count($segments))
		{
			$db = JFactory::getDbo();
			$key = md5(str_replace(':', '-', implode('/', $segments)));
			$query = $db->getQuery(true);
			$query->select('`query`')
				->from('#__oscalendar_urls')
				->where('md5_key="'.$key.'"');
			$db->setQuery($query);
			$queryString = $db->loadResult();
			if ($queryString)
			{
				parse_str(html_entity_decode($queryString), $vars);
			}
			else
			{
				$method = strtoupper(JFactory::getApplication()->input->getMethod());
				if ($method == 'GET')
				{
					throw new Exception('Page not found', 404);
				}
			}

			if (version_compare(JVERSION, '4.0.0-dev', 'ge'))
			{
				$segments = [];
			}
		}
		
		$app		= JFactory::getApplication();
		$menu		= $app->getMenu();
		if ($item = $menu->getActive())
		{
			foreach ($item->query as $key=>$value)
			{
				if ($key != 'option' && $key != 'Itemid' && !isset($vars[$key]))
					$vars[$key] = $value;
			}
		}
		return $vars;
	}
}

/**
 * OS Property router functions
 *
 * These functions are proxies for the new router interface
 * for old SEF extensions.
 *
 * @param   array &$query An array of URL arguments
 *
 * @return  array  The URL arguments to use to assemble the subsequent URL.
 */
function OscalendarBuildRoute(& $query)
{
	$router = new OscalendarRouter();

	return $router->build($query);
}

function OscalendarParseRoute(& $segments)
{
	$router = new OscalendarRouter();

	return $router->parse($segments);
}
