<?php
/*------------------------------------------------------------------------
# room.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsCalendarRoom{
	/**
	 * List Rooms
	 *
	 * @param unknown_type $property
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 * @param unknown_type $lists
	 */
	function listRooms($property,$rows,$pageNav,$lists){
		global $mainframe,$cClass;
		?>
		<form method="POST" action="<?php echo JRoute::_("index.php?option=com_oscalendar&task=room_manage&pid=".$property->id);?>" name="adminForm" id="adminForm" >
		<div class="row-fluid">
			<div class="span12">
				<?php
				$title = "";
				if($property->ref != ""){
					$title .= $property->ref.", ";
				}
				$title .= $property->pro_name;
                if($cClass['allow_room'] == 1) {
                    $title = $title . " > " . JText::_('OS_MANAGE_ROOMS');
                }else{
                    $title = $title . " > " . JText::_('OS_MANAGE_BOOKING_INFORMATION');
                }
				?>
				<?php
					OSPHelper::generateHeading(2,$title);
				?>
				<div class="clearfix"></div>
				<div class="btn-toolbar pull-right hidden-phone">
		            <div class="btn-group">
                        <?php if($cClass['allow_room'] == 1) { ?>
		            	<button type="button" class="btn hasTooltip btn-primary" title="<?php echo JText::_('OS_ADDNEW');?>" onclick="javascript:submitForm('room_addnew');">
		                    <i class="osicon-new"></i> <?php echo JText::_('OS_ADDNEW');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-info" title="<?php echo JText::_('OS_EDIT');?>" onclick="javascript:submitForm('room_edit');">
		                    <i class="osicon-edit"></i> <?php echo JText::_('OS_EDIT');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-success" title="<?php echo JText::_('OS_PUBLISHED');?>" onclick="javascript:submitForm('room_publish');">
		                    <i class="osicon-publish"></i> <?php echo JText::_('OS_PUBLISHED');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-warning" title="<?php echo JText::_('OS_UNPUBLISHED');?>" onclick="javascript:submitForm('room_unpublish');">
		                    <i class="osicon-unpublish"></i> <?php echo JText::_('OS_UNPUBLISHED');?>
		                </button>
		                
		                <button type="button" class="btn hasTooltip btn-danger" title="<?php echo JText::_('OS_REMOVE');?>" onclick="javascript:submitForm('room_remove');">
		                    <i class="osicon-trash"></i> <?php echo JText::_('OS_REMOVE');?>
		                </button>
                        <?php } ?>
		            </div>
		        </div>
				<table  width="100%" class="adminlist table table-striped">
					<thead>
						<tr>
                            <?php if($cClass['allow_room'] == 1) { ?>
                                <th width="2%" style="text-align:center;" class="hidden-phone">#</th>
                                <th width="3%" style="text-align:center;">
                                    <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                                </th>
                                <th width="10%" style="text-align:center;" class="hidden-phone">
                                    <?php echo JText::_('OS_ROOM_IMAGE');?>
                                </th>
                            <?php } ?>
							<th width="20%" style="text-align:center;">
                                <?php if($cClass['allow_room'] == 1) { ?>
								    <?php echo JHTML::_('grid.sort',   JText::_('OS_ROOM_NAME'), 'room_name', @$lists['order_Dir'], @$lists['order'] ,'room_manage'); ?>
                                <?php }else { ?>
                                    <?php echo JText::_('OS_PROPERTY');?>
                                <?php } ?>
							</th>
							<th width="5%" style="text-align:center;" class="hidden-phone">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_ADULT'), 'max_adult', @$lists['order_Dir'], @$lists['order'] ,'room_manage'); ?>
							</th>
							<th width="5%" style="text-align:center;" class="hidden-phone">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_CHILD'), 'max_child', @$lists['order_Dir'], @$lists['order'] ,'room_manage'); ?>
							</th>
                            <?php if($cClass['allow_room'] == 1) { ?>
                                <th width="10%" style="text-align:center;" class="hidden-phone">
                                    <?php echo JHTML::_('grid.sort',   JText::_('OS_NUMBER_ROOMS'), 'room_number', @$lists['order_Dir'], @$lists['order'] ,'room_manage'); ?>
                                </th>
                                <th width="15%" style="text-align:center;" class="hidden-phone">
                                    <?php echo JHTML::_('grid.sort',  JText::_('OS_ORDERING'), 'ordering', @$lists['order_Dir'], @$lists['order'],'room_manage' ); ?>
                                    <?php echo JHTML::_('grid.order',  $rows ,"filesave.png","room_saveorder"); ?>
                                </th>
                                <th width="5%" style="text-align:center;">
                                    <?php echo JText::_('OS_PUBLISHED');?>
                                </th>
                            <?php } ?>
							<th width="10%" style="text-align:center;" class="hidden-phone">
								<?php echo JText::_('OS_PRICE');?>
							</th>	
							<th width="5%" style="text-align:center;" class="hidden-phone">
								<?php echo JText::_('OS_AVAILABILITY');?>
							</th>								
						</tr>
					</thead>
                    <?php if($cClass['allow_room'] == 1) { ?>
					<tfoot>
						<tr>
							<td width="100%" colspan="11" style="text-align:center;">
								<?php
									echo $pageNav->getListFooter();
								?>
							</td>
						</tr>
					</tfoot>
                    <?php } ?>
					<tbody>
						<?php
						$db = JFactory::getDbo();
						$k = 0;
						for ($i=0, $n=count($rows); $i < $n; $i++) {
							$row 		= $rows[$i];
							$checked 	= JHtml::_('grid.id', $i, $row->id);
							$link 		= JRoute::_( 'index.php?option=com_oscalendar&pid='.$property->id.'&task=room_edit&cid[]='. $row->id );
							//$published 	= JHTML::_('jgrid.published', $row->published, $i , 'room_');
							?>
							<tr class="<?php echo "row$k"; ?>">
                                <?php if($cClass['allow_room'] == 1) { ?>
                                    <td align="center" style="text-align:center;" class="hidden-phone"><?php echo $pageNav->getRowOffset( $i ); ?></td>
                                    <td align="center" style="text-align:center;"><?php echo $checked; ?></td>
                                    <td style="text-align:center;width:50px;" class="hidden-phone">
                                        <?php
                                        if($row->room_image != ""){
                                            ?>
                                            <img src="<?php echo JURI::root()?>images/oscalendar/rooms/thumb/<?php echo $row->room_image?>" width="50" class="img-polaroid" style="width:50px !important;"/>
                                            <?php
                                        }else{
                                            ?>
                                            <img src="<?php echo JURI::root()?>components/com_osproperty/images/assets/nopropertyphoto.png" width="50" class="img-polaroid" style="width:50px !important;"/>
                                            <?php
                                        }
                                        ?>
                                    </td>
                                <?php } ?>
								<td style="text-align:left;">
                                    <a href="<?php echo $link?>">
                                        <?php if($cClass['allow_room'] == 1) { ?>
                                            <?php echo $row->room_name?>
                                        <?php }else{ ?>
                                            <?php echo $property->pro_name; ?>
                                        <?php } ?>
                                    </a>
                                </td>
								<td style="text-align:center;" class="hidden-phone"><?php echo $row->max_adult?></td>
								<td style="text-align:center;" class="hidden-phone"><?php echo $row->max_child?></td>
                                <?php if($cClass['allow_room'] == 1) { ?>
								    <td style="text-align:center;" class="hidden-phone"><?php echo $row->room_number?></td>
                                    <td align="center" class="order hidden-phone">
                                        <?php
                                        $ordering = "ordering";
                                        ?>
                                        <span><?php echo $pageNav->orderUpIcon($i,$row->ordering == 0 || $row->ordering == @$rows[$i-1]->ordering, 'room_orderup', 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
                                        <span><?php echo $pageNav->orderDownIcon($i, $n,  $row->ordering == 0 || $row->ordering == @$rows[$i+1]->ordering, 'room_orderdown', 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
                                        <input type="text" name="order[]"  value="<?php echo $row->ordering; ?>" class="text-area-order input-mini" style="text-align: center;width:40px;" />
                                    </td>
                                    <td style="text-align:center;">
                                        <?php //echo $published
                                        if($row->published == 1){
                                        ?>
                                        <a class="btn btn-micro active btn-success" title="<?php echo JText::_('OS_UNPUBLISH')?> <?php echo JText::_('OS_ITEM');?>" href="<?php echo JURI::root()?>index.php?option=com_oscalendar&task=room_unpublish&cid[]=<?php echo $row->id?>&pid=<?php echo $property->id;?>">
                                            <i class="osicon-publish"></i>
                                        </a>
                                        <?php
                                        }else{
                                        ?>
                                        <a class="btn btn-micro active btn-danger" title="<?php echo JText::_('OS_PUBLISH')?> <?php echo JText::_('OS_ITEM');?>" href="<?php echo JURI::root()?>index.php?option=com_oscalendar&task=room_publish&cid[]=<?php echo $row->id?>&pid=<?php echo $property->id;?>">
                                            <i class="osicon-unpublish"></i>
                                        </a>
                                        <?php
                                        }
                                        ?>
                                    </td>
                                <?php } ?>
								<td style="text-align:center;" class="hidden-phone">
									<a href="<?php echo JRoute::_('index.php?option=com_oscalendar&task=price_setup&rid='.$row->id.'&pid='.$property->id);?>" title="<?php echo JText::_('OS_SETUP_PRICE');?>">
										<img src="<?php echo JURI::root()?>components/com_oscalendar/style/images/price.png" width="30"/>
									</a>
								</td>
								<td style="text-align:center;" class="hidden-phone">
									<a href="<?php echo JUri::root().'index.php?option=com_oscalendar&task=default_calendarmanage&rid='.$row->id.'&pid='.$property->id.'&Itemid='.$mainframe->input->getInt('Itemid',0);?>" title="<?php echo JText::_('OS_MANAGE_AVAILABILITY_STATUS_FOR_THIS_ROOM');?>">
										<img src="<?php echo JURI::root()?>components/com_oscalendar/style/images/calendar.png" width="16"/>
									</a>
								</td>
							</tr>
						<?php
							$k = 1 - $k;	
						}
						?>
					</tbody>
				</table>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="room_manage" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $lists['order']; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir']; ?>" />
		</form>
		<script language="javascript">
		function submitForm(t){
			var total = 0;
			var temp;
			if(t == "room_addnew"){
				document.adminForm.task.value = t;
				document.adminForm.submit();
			}else{
				total = <?php echo count($rows)?>;
				if(total > 0){
					var check = 0;
					for(i=0;i<total;i++){
						temp = document.getElementById('cb' + i);
						if(temp != null){
							if(temp.checked == true){
								check = 1;
							}
						}
					}
					if(check == 0){
						alert("<?php echo JText::_("OS_PLEASE_ITEM")?>");
					}else{
						if(t == "room_remove"){
							var answer = confirm("<?php echo JText::_('OS_DO_YOU_WANT_TO_REMOVE_ITEMS')?>");
							if(answer == 1){
								document.adminForm.task.value = "room_remove";
								document.adminForm.submit();
							}
						}else{
							document.adminForm.task.value = t;
							document.adminForm.submit();
						}
					}
				}
			}
		}
		</script>
		<?php
	}
	
	
	/**
	 * Edit room
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	function editRoom($property,$row,$lists,$translatable){
		global $mainframe,$configClass,$cClass,$languages;
		JHTML::_('behavior.tooltip');
		JHTML::_("behavior.modal","osmodal");
		?>
		<form method="POST" action="<?php echo JRoute::_("index.php?option=com_oscalendar&task=room_edit&pid=".$property->id."&cid[]=".$row->id);?>" name="ftForm" id="ftForm" enctype="multipart/form-data">
		<div class="row-fluid">
			<div class="span12">
				<?php
				if($row->id > 0){
                    if($cClass['allow_room'] == 1) {
                        $func = JText::_('OS_EDIT');
                    }else{
                        $func = JText::_('OS_EDIT_BOOKING_INFORMATION');
                    }
				}else{
					$func = JText::_('OS_ADDNEW')." ".JText::_('OS_ROOM');
				}
				$title = "";
				if($property->ref != ""){
					$title .= $property->ref.", ";
				}
				$title .= $property->pro_name;
				$title = $title ;
				if(($row->id > 0) and ($cClass['allow_room'] == 1)){
					$title .= " > ".$row->room_name;
				}
				$title .= " > ".$func;
				?>
				<?php
					OSPHelper::generateHeading(2,$title);
				?>
				<div class="clearfix"></div>
				<div class="btn-toolbar pull-right hidden-phone">
		            <div class="btn-group">
		            	<button type="button" class="btn hasTooltip btn-success" title="<?php echo JText::_('OS_SAVE');?>" onclick="javascript:submitForm('room_save');">
		                    <i class="osicon-save"></i> <?php echo JText::_('OS_SAVE');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-info" title="<?php echo JText::_('OS_APPLY');?>" onclick="javascript:submitForm('room_apply');">
		                    <i class="osicon-apply"></i> <?php echo JText::_('OS_APPLY');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-danger" title="<?php echo JText::_('OS_CANCEL');?>" onclick="javascript:submitForm('room_cancel');">
		                    <i class="osicon-cancel"></i> <?php echo JText::_('OS_CANCEL');?>
		                </button>
		            </div>
		        </div>
				<table width="100%" class="admintable">
                    <?php if($cClass['allow_room'] == 1){ ?>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_ROOM_NAME')?>:
						</td>
						<td>
							<input type="text" name="room_name" id="room_name" class="input-large" size="40" value="<?php echo $row->room_name;?>" />
						</td>
					</tr>
					<tr>
						<td class="key" valign="top">
							<?php echo JText::_('OS_PHOTO')?>
						</td>
						<td>
							<?php
							if($row->room_image){
								?>
								<a href="<?php echo JURI::root()?>images/oscalendar/rooms/<?php echo $row->room_image?>" class="osmodal">
									<img src="<?php echo JURI::root()?>images/oscalendar/rooms/thumb/<?php echo $row->room_image?>" class="img-polaroid" />
								</a>
								<BR>
								<input type="checkbox" name="remove_photo" id="remove_photo" value="0" onclick="javascript:changeValue('remove_photo')" /> &nbsp;<b><?php echo JText::_('OS_REMOVE_PHOTO');?></b><BR />
								<?php
							}
							?>
							<input type="file" name="photo" id="photo" size="40" onchange="javascript:checkUploadPhotoFiles('photo');"> (Only allow: *.jpg, *.jpeg)
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_NUMBER_ROOM')?>:
						</td>
						<td>
							<input type="text" name="room_number" id="room_number" class="input-mini" value="<?php echo $row->room_number;?>" />
						</td>
					</tr>
                    <?php } ?>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_MAX_ADULT')?>:
						</td>
						<td>
							<input type="text" name="max_adult" id="max_adult" class="input-mini" value="<?php echo $row->max_adult;?>" />
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_MAX_CHILD')?>:
						</td>
						<td>
							<input type="text" name="max_child" id="max_child" class="input-mini" value="<?php echo $row->max_child;?>" />
						</td>
					</tr>
                    <?php if($cClass['allow_room'] == 1){ ?>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_STATE')?>:
						</td>
						<td>
							<?php echo $lists['state'];?>
						</td>
					</tr>
					<tr>
						<td class="key" valign="top">
							<?php echo JText::_('OS_DESCRIPTION')?>:
						</td>
						<td>
							<textarea name="room_desc" cols="50" rows="5"><?php echo $row->room_desc;?></textarea>
						</td>
					</tr>
                    <?php } ?>
				</table>
			</div>
		</div>
		<input type="hidden" name="MAX_FILE_SIZE" value="90000000" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" id="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="id" value="<?php echo $row->id?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		</form>
		<script language="javascript">
		function submitForm(t){
			document.ftForm.task.value = t;
			document.ftForm.submit();
		}
		</script>
		<?php
	}
}
?>