<?php
/*------------------------------------------------------------------------
# booking.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class OsCalendarForm{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));
		$pid = $mainframe->input->getInt('pid',0);
		$rid = $mainframe->input->getInt('rid',0);
		switch ($task){
			case "form_step1":
				OsCalendarForm::checkout();
			break;
			case "form_step2":
				OsCalendarForm::confirm();
			break;
			case "form_register":
				OsCalendarForm::registerUser();
			break;
		}
	}
	
	/**
	 * Checkout 
	 * Step1 
	 *
	 */
	static function checkout(){
		global $mainframe,$configClass,$cClass;
		if(file_exists(JPATH_ROOT."/components/com_content/helpers/route.php"))
		{
			require_once(JPATH_ROOT."/components/com_content/helpers/route.php");
		}
		$document  = JFactory::getDocument();
		$document->setTitle(JText::_('OS_CHECKOUT'));
		//get information from profile table
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		//get profile
		if($user->id > 0){
			$db->setQuery("Select * from #__oscalendar_profile where user_id = '$user->id'");
			$profile = $db->loadObject();
		}
		
		$uid = $mainframe->input->getString('uid','');
		if($uid == ""){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JURI::root());
		}
		$db->setQuery("Select * from #__oscalendar_order_temp where user_data = '$uid'");
		$row = $db->loadObjectList();
		if(count($row ) == 0){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JURI::root());
		}
		
		$row = $row[0];
		$order_temp_id = $row->id;
		$pid = $row->pid;
		$rid = $row->rid;
		$nroom = $row->nroom;
		$lists['nroom'] = $nroom;
		$lists['adult'] = $row->adult;
		$lists['child'] = $row->child;
		$lists['date_from'] = $row->book_from;
		$lists['date_to'] = $row->book_to;
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$db->setQuery("Select image from #__osrs_photos where pro_id = '$pid'");
		$image = $db->loadResult();
		$property->image = $image;
		
		$countryArr[] = JHTML::_('select.option','','');
		$db->setQuery("Select country_name as value, country_name as text from #__osrs_countries order by country_name");
		$countries = $db->loadObjectList();
		$countryArr = array_merge($countryArr,$countries);
		$lists['country'] = JHTML::_('select.genericlist',$countryArr,'country','style="width:180px;" class="input-large form-control form-select"','value','text',$profile->country);
		$db->setQuery("Select * from #__oscalendar_fields where published = '1'  order by ordering");
		$fields = $db->loadObjectList();
		
		$paymentMethod = $mainframe->input->getString('payment_method', os_payments::getDefautPaymentMethod());	
		if (!$paymentMethod){
		    $paymentMethod = os_payments::getDefautPaymentMethod();
		}
		
		###############Payment Methods parameters###############################
	
		//Creditcard payment parameters		
		$x_card_num = $mainframe->input->getString('x_card_num', '', 'post');
		$expMonth =  $mainframe->input->getString('exp_month', date('m'), 'post') ;				
		$expYear = $mainframe->input->getString('exp_year', date('Y'), 'post') ;		
		$x_card_code = $mainframe->input->getString('x_card_code', '', 'post');
		$cardHolderName = $mainframe->input->getString('card_holder_name', '', 'post') ;
		$lists['exp_month'] = JHTML::_('select.integerlist', 1, 12, 1, 'exp_month', ' id="exp_month" class="input-mini"  ', $expMonth, '%02d') ;
		$currentYear = date('Y') ;
		$lists['exp_year'] = JHTML::_('select.integerlist', $currentYear, $currentYear + 10 , 1, 'exp_year', ' id="exp_year" class="input-mini" ', $expYear) ;
		$options =  array() ;
		$cardTypes = explode(',', $cClass['enable_cardtypes']);
		if (in_array('Visa', $cardTypes)) {
			$options[] = JHTML::_('select.option', 'Visa', JText::_('OS_VISA_CARD')) ;			
		}
		if (in_array('MasterCard', $cardTypes)) {
			$options[] = JHTML::_('select.option', 'MasterCard', JText::_('OS_MASTER_CARD')) ;
		}
		
		if (in_array('Discover', $cardTypes)) {
			$options[] = JHTML::_('select.option', 'Discover', JText::_('OS_DISCOVER')) ;
		}		
		if (in_array('Amex', $cardTypes)) {
			$options[] = JHTML::_('select.option', 'Amex', JText::_('OS_AMEX')) ;
		}		
		$lists['card_type'] = JHTML::_('select.genericlist', $options, 'card_type', ' class="input-medium" ', 'value', 'text') ;
		
		//Echeck
				
		$x_bank_aba_code = $mainframe->input->getString('x_bank_aba_code', '', 'post') ;
		$x_bank_acct_num = $mainframe->input->getString('x_bank_acct_num', '', 'post') ;
		$x_bank_name = $mainframe->input->getString('x_bank_name', '', 'post') ;
		$x_bank_acct_name = $mainframe->input->getString('x_bank_acct_name', '', 'post') ;				
		$options = array() ;
		$options[] = JHTML::_('select.option', 'CHECKING', JText::_('OS_BANK_TYPE_CHECKING')) ;
		$options[] = JHTML::_('select.option', 'BUSINESSCHECKING', JText::_('OS_BANK_TYPE_BUSINESSCHECKING')) ;
		$options[] = JHTML::_('select.option', 'SAVINGS', JText::_('OS_BANK_TYPE_SAVING')) ;
		$lists['x_bank_acct_type'] = JHTML::_('select.genericlist', $options, 'x_bank_acct_type', ' class="inputbox" ', 'value', 'text', $mainframe->input->getString('x_bank_acct_type')) ;
		
		$methods = os_payments::getPaymentMethods(true, false) ;
		
		$lists['x_card_num'] = $x_card_num;
		$lists['x_card_code'] = $x_card_code;
		$lists['cardHolderName'] = $cardHolderName;
		$lists['x_bank_acct_num'] = $x_bank_acct_num;
		$lists['x_bank_acct_name'] = $x_bank_acct_name;
		$lists['methods'] = $methods;
		$lists['idealEnabled'] = $idealEnabled;
		$lists['paymentMethod'] = $paymentMethod;
		
		$idealEnabled = OSCHelper::idealEnabled();
		if ($idealEnabled) {			
			$bankLists = OSCHelper::getBankLists() ;			
			$options = array() ;
			foreach ($bankLists as $bankId => $bankName) {
				$options[] = JHTML::_('select.option', $bankId, $bankName) ; 
			}	
			$lists['bank_id'] = JHTML::_('select.genericlist', $options, 'bank_id', ' class="inputbox" ', 'value', 'text', $mainframe->input->getInt('bank_id'));				
		}
		
		$nChildArr   = array();
		$nChildArr[] = JHTML::_('select.option','','');
		for($i=1;$i<=5;$i++){
			$nChildArr[] = JHTML::_('select.option',$i,$i);
		}
		$lists['nchild'] = JHTML::_('select.genericlist',$nChildArr,'nchild','class="input-mini"','value','text');
		
		$nAdultArr   = array();
		$nAdultArr[] = JHTML::_('select.option','','');
		for($i=1;$i<=5;$i++){
			$nAdultArr[] = JHTML::_('select.option',$i,$i);
		}
		$lists['nadult'] = JHTML::_('select.genericlist',$nAdultArr,'nadult','class="input-mini"','value','text');
		
		HTML_OsCalendarForm::checkoutLayout($order_temp_id,$lists,$property,$room,$fields,$profile);
	}
	
	/**
	 * Checkout Step2 
	 * Confirmation user information
	 *
	 */
	static function confirm(){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
        $order_temp_id = $mainframe->input->getInt('order_temp_id',0);
        if($order_temp_id == 0){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
            $mainframe->redirect(JURI::root());
        }
        $db->setQuery("Select * from #__oscalendar_order_temp where id = '$order_temp_id'");
        $row = $db->loadObjectList();
        if(count($row ) == 0){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
            $mainframe->redirect(JURI::root());
        }
		if($cClass['use_captcha'] == 3) {
            $post = $mainframe->input->post->getArray();
            JPluginHelper::importPlugin('captcha');
            $dispatcher = JDispatcher::getInstance();
            $res = $dispatcher->trigger('onCheckAnswer', $post['recaptcha_response_field']);
            if (!$res[0]) {
				$mainframe->enqueueMessage(JText::_('OS_CAPTCHA_IS_INVALID'));
                $mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=form_step1&pid=' . $row->pid . '&date_from=' . $row->book_from . '&date_to=' . $row->book_to));
            }
        }
		$row = $row[0];
		$order_temp_id = $row->id;
		$pid = $row->pid;
		$rid = $row->rid;
		$nroom = $row->nroom;
		$lists['nroom'] = $nroom;
		$lists['adult'] = $row->adult;
		$lists['child'] = $row->child;
		$lists['date_from'] = $row->book_from;
		$lists['date_to'] = $row->book_to;
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$db->setQuery("Select image from #__osrs_photos where pro_id = '$pid'");
		$image = $db->loadResult();
		$property->image = $image;
		
		$lists['nNights']   = OSCHelper::calNights($row->book_from,$row->book_to);
		
		$document  = JFactory::getDocument();
		$document->setTitle(JText::_('OS_CONFIRM_INFORMATION'));
		$user = JFactory::getUser();
		/*
		$coupon_id = $mainframe->input->getInt('coupon_id',0);
		if($coupon_id > 0){
			$db->setQuery("Select * from #__app_sch_coupons where id = '$coupon_id'");
			$coupon = $db->loadObject();
			$max_user_use = $coupon->max_user_use;
			$max_total_use = $coupon->max_total_use;
			if($max_total_use > 0){
				$db->setQuery("Select count(id) from #__app_sch_coupon_used where coupon_id = '$coupon_id'");
				$nused = $db->loadResult();
				if($nused >= $max_total_use){
					$coupon_id = 0;
				}
			}
			if(($max_user_use > 0) and ($coupon_id > 0)){
				if($user->id > 0){
					$db->setQuery("Select count(id) from #__app_sch_coupon_used where user_id = '$user->id' and coupon_id = '$coupon_id'");
					$nused = $db->loadResult();
					if($nused >= $max_user_use){
						$coupon_id = 0;
					}
				}
			}
		}
		$coupon = array();
		if($coupon_id > 0) {
			$db->setQuery("Select * from #__app_sch_coupons where id = '$coupon_id'");
			$coupon = $db->loadObject();
		}
		*/
		
		$db->setQuery("Select * from #__oscalendar_fields where field_type in (0,1) and published = '1'");
		$fieldObj = $db->loadObjectList();
		
		$select_payment 	= $mainframe->input->getString('payment_method','');
		if($select_payment !=  "")
		{
			$method 					= os_payments::getPaymentMethod($select_payment) ;
			$x_card_num					= $mainframe->input->getString('x_card_num','');
			$x_card_code				= $mainframe->input->getString('x_card_code','');
			$card_holder_name			= $mainframe->input->getString('card_holder_name','');
			$exp_year					= $mainframe->input->getString('exp_year','');
			$exp_month					= $mainframe->input->getString('exp_month','');
			$card_type					= $mainframe->input->getString('card_type','');
			$lists['method'] 			= $method;
			$lists['x_card_num'] 		= $x_card_num;
			$lists['x_card_code'] 		= $x_card_code;
			$lists['card_holder_name'] 	= $card_holder_name;
			$lists['exp_year'] 			= $exp_year;
			$lists['exp_month'] 		= $exp_month;
			$lists['card_type'] 		= $card_type;
			$lists['select_payment']	= $select_payment;
			$lists['card_holder_name']  = $card_holder_name;
		}
		
		//Saving profile
		$profile = & JTable::getInstance('Profile','OsCalendarTable');
		if($user->id > 0){
			$db->setQuery("Select count(id) from #__oscalendar_profile where user_id = '$user->id'");
			$count = $db->loadResult();
			if($count > 0){
				$db->setQuery("Select id from #__oscalendar_profile where user_id = '$user->id'");
				$id = $db->loadResult();
				$profile->id = $id;
			}else{
				$profile->id = 0;
			}
			$profile->user_id 		= $user->id;
			$profile->name 			= $mainframe->input->getString('name','');
			$profile->email 		= $mainframe->input->getString('email','');
			$profile->phone 		= $mainframe->input->getString('phone','');
			$profile->country 		= $mainframe->input->getString('country','');
			$profile->store();
		}
		HTML_OsCalendarForm::confirmInforFormHTML($order_temp_id,$lists,$property,$room,$fieldObj,$profile);
	}
	
	/**
	 * Joomla registration user
	 *
	 */
	static function registerUser(){
		global $mainframe,$configClass,$cClass;
		global $mainframe,$configClass;
		$lang = & JFactory::getLanguage() ;
		$tag = $lang->getTag();
		if (!$tag)
			$tag = 'en-GB' ;
			
		$lang->load('com_users', JPATH_ROOT, $tag);
			
		$order_name 		= $mainframe->input->getString("name","");
		$order_email 		= $mainframe->input->getString("email","");
		$order_username 	= $mainframe->input->getString("username","");
		$order_password 	= $mainframe->input->getString("password1","");
		
		$uid				= $mainframe->input->getString('uid','');
		
		$data['name'] 		= $order_name;
		$data['password'] 	= $order_password;
		$data['email'] 		= $order_email ;
		$data['email1'] 	= $order_email ;
		$data['username']   = $order_username;
		$data['password2']  = $order_password;
		
		$user = new JUser  ;
		$params	= JComponentHelper::getParams('com_users');
		$data['groups'] = array() ;
		$data['groups'][]= $params->get('new_usertype', 2) ;
		$useractivation = $params->get('useractivation');
		$sendActivationEmail = $configClass['sendActivationEmail'];
		
		$data['block'] = 0;
		
		$itemid = $mainframe->input->getInt('Itemid',0);
		if (!$user->bind($data)) {
			//return false;
			$msg = JText::sprintf('OS_COM_USERS_REGISTRATION_BIND_FAILED', $user->getError());
			$mainframe->enqueueMessage($msg);
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=form_step1&uid='.$uid.'&Itemid='.$itemid));
		}
		// Store the data.
		if (!$user->save()) {
			$msg = JText::sprintf('OS_COM_USERS_REGISTRATION_SAVE_FAILED', $user->getError());
			//print_r($user);
			$mainframe->enqueueMessage($msg);
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=form_step1&uid='.$uid.'&Itemid='.$itemid));
		}
		//}								
		//process login
		if($configClass['use_ssl'] == 1){
			$returnUrl = JRoute::_($configClass['root_link'].'index.php?option=com_oscalendar&task=form_step1&uid='.$uid.'&Itemid='.$itemid);
		}else{
			$returnUrl = JRoute::_('index.php?option=com_oscalendar&task=form_step1&uid='.$uid.'&Itemid='.$itemid);	
		}
		
		$options = array();
		$options['remember'] = 1;
		$options['return'] = $returnUrl;

		$credentials = array();
		$credentials['username'] = $order_username;
		$credentials['password'] = $order_password;
		
		//preform the login action
		//$error = $mainframe->login($credentials, $options);
		//end login
		if (true === $mainframe->login($credentials, $options)) {
			// Success
			//$app->setUserState('users.login.form.data', array());
			//$app->redirect(JRoute::_($app->getUserState('users.login.form.return'), false));
			$mainframe->redirect($returnUrl);
		} else {
			// Login failed !
			$data['remember'] = (int) $options['remember'];
			$mainframe->setUserState('users.login.form.data', $data);
			$mainframe->redirect(JRoute::_('index.php?option=com_users&view=login', false));
		}
	}
}
?>