<?php
/**
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage views
 * @subpackage viewer
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2025 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
?>

<div id="content">
	<h1><?php echo Text::_('COM_JMAP_VIEWER_GNEWS_SITEMAP'); ?></h1>

	<!-- =====================
	     Left info
	     ===================== -->
	<div class="leftinfo">
		<div class="expl">
			<p>
				<?php
				echo Text::sprintf(
					'COM_JMAP_VIEWER_GENERATED_BY',
					'<strong><a target="_blank" rel="noopener" href="https://storejextensions.org/extensions/jsitemap_professional.html">JSitemap Pro</a></strong>'
				);
				?>
			</p>

			<p>
				<?php
				echo Text::sprintf(
					'COM_JMAP_VIEWER_SITEMAP_INFO',
					'<a href="https://www.sitemaps.org" target="_blank" rel="noopener">sitemaps.org</a>'
				);
				?>
			</p>

			<p>
				<?php
				echo Text::sprintf(
					'COM_JMAP_VIEWER_SITEMAP_CONTAINS',
					'<span id="url-count" class="expl_details"><span id="urls_count_label">0</span> URLs</span>'
				);
				?>
			</p>

			<p>
				<?php
				echo Text::sprintf(
					'COM_JMAP_VIEWER_GNEWS_PUBLICATION',
					'<span id="gnews_publication_name" class="expl_details"></span>'
				);
				?>
			</p>
		</div>
	</div>

	<!-- =====================
	     Right chart
	     ===================== -->
	<div class="rightchart">
		<canvas id="chart_canvas"></canvas>
	</div>

	<!-- =====================
	     Sitemap table
	     ===================== -->
	<table id="sitemap" class="tablesorter">
		<thead>
			<tr>
				<th style="width:45%"><?php echo Text::_('COM_JMAP_VIEWER_COL_URL'); ?></th>
				<th style="width:25%"><?php echo Text::_('COM_JMAP_VIEWER_COL_NEWS_TITLE'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_NEWS_ACCESS'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_NEWS_GENRE'); ?></th>
				<th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_NEWS_PUBLICATION_DATE'); ?></th>
			</tr>
		</thead>
		<tbody id="sitemap-body"></tbody>
	</table>

	<!-- =====================================================
	     Hidden values REQUIRED by Chart.js XSL script
	     ===================================================== -->
	<div id="sitemap_type" class="hidden">gnews</div>
	<div id="urls_count" class="hidden">0</div>
</div>

<?php
// Set the document title
$title = Text::_('COM_JMAP_VIEWER_GNEWS_SITEMAP');
$this->setDocumentTitle($title);
?>
