<?php
/**
 * Note FormField
 * @package TAGZ
 * @copyright (C) 2013 JooMarketer.com
 * @ All rights reserved
 * @ Joomla! is Free Software
 * @ Released under GNU/GPL v3.0 License : http://www.gnu.org/licenses/gpl-3.0.html
 **/

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Form\Field\TextField;
use Joomla\CMS\Language\Text;

FormHelper::loadFieldClass('text');

class JFormFieldNote4 extends TextField
{
    protected $type = 'Note4';

    /**
     * Override label — none for this field
     */
    protected function getLabel()
    {
        return '';
    }

    /**
     * Generate the field HTML
     */
    public function getInput()
    {
        $text  = (string) $this->element['text'];
        $class = (string) $this->element['class'];

        // Joomla 3–6: Text::_() is namespaced version of JText::_
        $translatedText = Text::_($text);

        $hasText = ($text !== '') ? ' hasText' : '';

        return '<div class="' . htmlspecialchars($class) . ' note' . $hasText . '">'
            . '<span>' . $translatedText . '</span>'
            . '</div>';
    }
}
