<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\MailingList;

use Alledia\OSDownloads\Factory;
use Alledia\OSDownloads\MailingLists\AbstractClient;
use Alledia\OSDownloads\Pro\MailingList\AcyMailing\AbstractVersion;
use Exception as Exception;
use Joomla\CMS\Table\Table;
use Joomla\Event\Dispatcher;
use Joomla\Event\Event;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

// phpcs:enable PSR1.Files.SideEffects

class AcyMailing extends AbstractClient
{
    /**
     * @var bool
     */
    protected static $enabled = null;

    /**
     * @var object[]
     */
    protected static $lists = null;

    /**
     * @var AbstractVersion
     */
    protected static $methods = null;

    /**
     * @return array
     * @throws Exception
     */
    public static function getLists(): array
    {
        if (static::checkDependencies() && static::$lists === null) {
            static::$lists = static::$methods->getLists();
        }

        return static::$lists ?: [];
    }

    /**
     * @inheritDoc
     */
    protected function registerObservers(): void
    {
        $dispatcher = Factory::getDispatcher();

        if ($dispatcher instanceof \JEventDispatcher) {
            $dispatcher->register('onOSDownloadsBeforeSaveEmail', [$this, 'onBeforeStore']);

        } elseif ($dispatcher instanceof Dispatcher) {
            $dispatcher->addListener('onOSDownloadsBeforeSaveEmail', [$this, 'onTableBeforeStore']);
        }
    }

    /**
     * @param Table $table
     *
     * @return void
     */
    public function onBeforeStore(Table $table)
    {
        if (static::isEnabled() == false) {
            return;
        }

        if ($email = $table->get('email')) {
            $joomlaUser = $this->getUserByEmail($email);

            $user = static::$methods->getUser(
                $table->get('email'),
                (int)$table->get('confirmed'),
                $joomlaUser->id ?? null
            );

            $lists = (array)$this->getDocumentParam($table->get('document_id'), 'mailinglist.acymailing.list_id', []);
            $lists = array_filter($lists);

            if ($user) {
                $table->set('synced', (int)static::$methods->subscribe($user, $lists));
            }
        }
    }

    /**
     * @param Event $event
     */
    public function onTableBeforeStore(Event $event)
    {
        if ($event->count() == 1) {
            $table = $event->getArgument(0);

            $this->onBeforeStore($table);
        }
    }

    /**
     * If AcyMailing is not installed, disable this plugin
     *
     * @inheritDoc
     */
    public static function checkDependencies(): bool
    {
        if (static::$methods === null) {
            static::$methods = AbstractVersion::getInstance();
        }

        return static::$methods !== null;
    }

    /**
     * @inheritDoc
     */
    public static function isEnabled(): bool
    {
        return static::checkDependencies() && static::getParams()->get('mailinglist.acymailing.enable');
    }
}
