CREATE TABLE IF NOT EXISTS `#__oscalendar_available` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `rid` int(11) NOT NULL DEFAULT '0',
  `availtype` tinyint(1) unsigned DEFAULT NULL,
  `checkdate` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_booking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `rid` int(11) NOT NULL DEFAULT '0',
  `nroom` tinyint(3) NOT NULL DEFAULT '1',
  `book_from` date DEFAULT NULL,
  `book_to` date DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `hour_from` int(2) NOT NULL DEFAULT '0',
  `hour_to` int(2) NOT NULL DEFAULT '0',
  `room_fee` decimal(10,2) NOT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL,
  `deposit` decimal(10,2) DEFAULT NULL,
  `tax` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) NOT NULL,
  `curr` varchar(10) NOT NULL,
  `language_prefix` varchar(100) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `country` varchar(255) NOT NULL,
  `nAdults` tinyint(2) NOT NULL DEFAULT '0',
  `nChilds` tinyint(2) NOT NULL DEFAULT '0',
  `notes` text,
  `card_number` varchar(50) NOT NULL,
  `card_type` varchar(50) NOT NULL,
  `expiry_month` int(2) NOT NULL,
  `expiry_year` int(4) NOT NULL,
  `card_holder` varchar(100) NOT NULL,
  `cvv_code` varchar(10) NOT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT '0',
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `order_discount` decimal(12,2) NOT NULL,
  `bank_id` int(11) NOT NULL DEFAULT '0',
  `order_status` char(1) DEFAULT NULL,
  `order_date` datetime NOT NULL,
  `transaction_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_configuration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_key` varchar(225) DEFAULT NULL,
  `config_value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__oscalendar_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL,
  `email_title` varchar(255) NOT NULL,
  `email_content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__oscalendar_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_type` tinyint(1) NOT NULL DEFAULT '0',
  `price_for_order` tinyint(1) NOT NULL DEFAULT '0',
  `field_label` varchar(255) NOT NULL,
  `field_free` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__oscalendar_field_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL DEFAULT '0',
  `field_option` varchar(255) NOT NULL,
  `option_free` tinyint(1) NOT NULL,
  `additional_price` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `option_price` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_price` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `field_price` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `field_value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_order_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_data` varchar(255) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `rid` int(11) DEFAULT NULL,
  `nroom` tinyint(3) unsigned DEFAULT NULL,
  `adult` tinyint(3) unsigned DEFAULT NULL,
  `child` tinyint(3) unsigned DEFAULT NULL,
  `book_from` date DEFAULT NULL,
  `book_to` date DEFAULT NULL,
  `sub_total` decimal(12,2) DEFAULT NULL,
  `curr` int(11) NOT NULL,
  `created_on` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_order_temp_field_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `additional_price` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `author` varchar(250) DEFAULT NULL,
  `creation_date` datetime DEFAULT NULL,
  `copyright` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `author_email` varchar(50) DEFAULT NULL,
  `author_url` varchar(50) DEFAULT NULL,
  `version` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `params` text,
  `ordering` int(11) DEFAULT NULL,
  `published` tinyint(3) unsigned DEFAULT NULL,
  `support_recurring_subscription` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_profile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `room_number` tinyint(3) unsigned DEFAULT '0',
  `room_name` varchar(255) DEFAULT NULL,
  `room_desc` varchar(255) DEFAULT NULL,
  `room_image` varchar(100) DEFAULT NULL,
  `max_adult` tinyint(3) unsigned DEFAULT '0',
  `max_child` tinyint(3) unsigned DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `published` tinyint(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_room_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `rid` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `price_from` date DEFAULT NULL,
  `price_to` date DEFAULT NULL,
  `min_booking` tinyint(3) unsigned DEFAULT NULL,
  `price` decimal(12,2) DEFAULT NULL,
  `curr` int(11) DEFAULT NULL,
  `allday` tinyint(1) unsigned zerofill DEFAULT NULL,
  `mon` tinyint(1) unsigned zerofill DEFAULT NULL,
  `tue` tinyint(1) unsigned zerofill DEFAULT NULL,
  `wed` tinyint(1) unsigned zerofill DEFAULT NULL,
  `thu` tinyint(1) unsigned zerofill DEFAULT NULL,
  `fri` tinyint(1) unsigned zerofill DEFAULT NULL,
  `sat` tinyint(1) unsigned zerofill DEFAULT NULL,
  `sun` tinyint(1) unsigned zerofill DEFAULT NULL,
  `allow_book_all` tinyint(1) NOT NULL DEFAULT '0',
  `allow_mon` tinyint(1) NOT NULL DEFAULT '0',
  `allow_tue` tinyint(1) NOT NULL DEFAULT '0',
  `allow_wed` tinyint(1) NOT NULL DEFAULT '0',
  `allow_thu` tinyint(1) NOT NULL DEFAULT '0',
  `allow_fri` tinyint(1) NOT NULL DEFAULT '0',
  `allow_sat` tinyint(1) NOT NULL DEFAULT '0',
  `allow_sun` tinyint(1) NOT NULL DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `#__oscalendar_urls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5_key` text,
  `query` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

