<?php
/*------------------------------------------------------------------------
# config.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

class HTML_OsAppscheduleConfiguration{
	/**
	 * Configuration layout
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function ConfigLayout($option,$configs,$lists){
		JToolBarHelper::title(JText::_('OSC_CONFIGURATION'),'cog');
		JToolBarHelper::save('config_save');
		JToolBarHelper::apply('config_apply');
		JToolBarHelper::cancel('config_gotoindex');
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);
		?>
		<form method="POST" action="index.php" name="adminForm" id="adminForm" enctype="multipart/form-data">
			<table width="100%" class="admintable adminform" style="border:1px solid #0EB2B8 !important;">
				<tr>
					<td width="100%" colspan="3" style="padding:5px;text-align:left;background-color:#0EB2B8;color:white;">
						<strong>
							<?php echo JText::_('OS_APPLICATION_SETTING');?>
						</strong>
					</td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OS_ENABLE_RESERVATION')?></td>
					<td width="20%"><?php echo $lists['enable_reservation']; ?></td>
					<td width="60%"><?php echo JText::_('OS_ENABLE_RESERVATION_EXPLAIN');?></td>
				</tr>
                <tr>
                    <td class="key" width="20%"><?php echo JText::_('OS_ENABLE_ROOM')?></td>
                    <td width="20%"><?php echo $lists['allow_room']; ?></td>
                    <td width="60%"><?php echo JText::_('OS_ENABLE_ROOM_EXPLAIN');?></td>
                </tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OSC_ONLY_REGISTER_CAN_BOOK')?></td>
					<td width="20%"><?php echo $lists['only_register_can_book']; ?></td>
					<td width="60%"><?php echo JText::_('OSC_ONLY_REGISTER_CAN_BOOK_EXPLAIN');?></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_ALLOW_CANCEL_THE_BOOKING_REQUEST')?></td>
					<td ><?php echo $lists['allow_cancel'] ?></td>
					<td><?php echo JText::_('OS_ALLOW_CANCEL_THE_BOOKING_REQUEST_EXPLAIN');?></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_ALLOW_CANCEL_BEFORE')?></td>
					<td ><input type="text" name="configuration[allow_cancel_before]" class="input-mini form-control" value="<?php echo $configs->allow_cancel_before;?>"/> <?php echo JText::_('OS_DAYS');?></td>
					<td><?php echo JText::_('OS_ALLOW_CANCEL_BEFORE_EXPLANATION');?></td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OS_SEND_NOTIFY')?></td>
					<td width="20%"><?php echo $lists['send_notify']; ?></td>
					<td width="60%"><?php echo JText::_('OS_SEND_NOTIFY_EXPLAIN');?></td>
				</tr>
				<tr>
					<td class="key" width="20%" valign="top"><?php echo JText::_('OS_SPECIAL_NOTES')?></td>
					<td width="20%">
						<textarea name="configuration[special_notes]" cols="60" rows="5"></textarea>
					</td>
					<td width="60%" valign="top"><?php echo JText::_('OS_SPECIAL_NOTES_EXPLAIN');?></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OSC_CONFIGURATION_DATE_TIME_FORMAT')?></td>
					<td ><?php echo $lists['date_time_format']?></td>
					<td></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OSC_CONFIGURATION_DATE_FORMAT')?></td>
					<td ><?php echo $lists['date_format'] ?></td>
					<td></td>
				</tr>
			</table>
			<BR />
			<table width="100%" class="admintable adminform" style="border:1px solid #CCC !important;">
				<tr>
					<td width="100%" colspan="3" style="padding:5px;text-align:left;background-color:#0EB2B8;color:white;">
						<strong>
							<?php echo JText::_('OS_PAYMENT_SETTING');?>
						</strong>
					</td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('0S_ENABLE_TAX')?></td>
					<td width="20%"><?php echo $lists['enable_tax']; ?></td>
					<td width="60%"></td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OS_TAX_PERCENT')?></td>
					<td width="20%"><input type="text" name="configuration[tax_payment]" class="input-mini form-control" value="<?php echo $configs->tax_payment;?>"/></td>
					<td width="60%"><?php echo JText::_('OS_TAX_PERCENT_EXPLAIN')?></td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OS_DEPOSIT_AMOUNT')?></td>
					<td width="20%"><input type="text" name="configuration[deposit_payment]" class="input-mini form-control" value="<?php echo $configs->deposit_payment;?>"/></td>
					<td width="60%"><?php echo JText::_('OS_DEPOSIT_AMOUNT_EXPLAIN')?></td>
				</tr>
				<tr>
					<td class="key" width="20%" valign="top"><?php echo JText::_('OS_ENABLE_CARD_TYPES')?></td>
					<td width="20%"><?php echo $lists['cardtypes'];?></td>
					<td width="60%"></td>
				</tr>
				<tr>
					<td class="key" width="20%"><?php echo JText::_('OS_USE_HTTPS')?></td>
					<td width="20%"><?php echo $lists['use_ssl']?></td>
					<td width="60%"></td>
				</tr>
			</table>
			<BR />
			<table width="100%" class="admintable adminform" style="border:1px solid #CCC !important;">
				<tr>
					<td width="100%" colspan="3" style="padding:5px;text-align:left;background-color:#0EB2B8;color:white;">
						<strong>
							<?php echo JText::_('OS_PRICE_SETTING');?>
						</strong>
					</td>
				</tr>
				<tr>
					<td class="key" width="30%"><?php echo JText::_('OS_CURRENCY_SYMBOL_POSITION')?></td>
					<td ><?php echo $lists['currency_symbol_position']; ?></td>
					<td width="60%"></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_MONEY_FORMAT')?></td>
					<td ><?php echo $lists['price_format']; ?></td>
					<td width="60%"></td>
				</tr>
			</table>
			<BR />
			<table width="100%" class="admintable adminform" style="border:1px solid #CCC !important;">
				<tr>
					<td width="100%" colspan="3" style="padding:5px;text-align:left;background-color:#0EB2B8;">
						<strong>
							<?php echo JText::_('OS_OTHER_SETTING');?>
						</strong>
					</td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('Use Calendar')?></td>
					<td><?php echo $lists['use_calendar'];?></td>
					<td width="60%"><?php echo JText::_('Please select Calendar type that you want to use in OS Calendar system')?></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OSC_CSV_FIELDS_SEPERATOR')?></td>
					<td><?php echo $lists['csv_seperator'];?></td>
					<td width="60%"><?php echo JText::_('OSC_CSV_FIELDS_SEPERATOR_EXPLANATION')?></td>
				</tr>
				
				<tr>
					<td class="key"><?php echo JText::_('OS_USE_CAPTCHA')?></td>
					<td ><?php echo $lists['use_captcha']; ?></td>
					<td width="60%"></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_ENABLE_TERM_AND_CONDITION')?></td>
					<td ><?php echo $lists['enable_term_and_condition']; ?></td>
					<td width="60%"></td>
				</tr>
				<tr>
					<td class="key"><?php echo JText::_('OS_SELECT_ARTICLE')?></td>
					<td ><?php echo $lists['article_id']; ?></td>
					<td width="60%"><?php echo JText::_('OS_SELECT_ARTICLE_EXPLAIN')?></td>
				</tr>
			</table>				
			<input type="hidden" name="option" value="<?php echo $option?>">
			<input type="hidden" name="task" value="">
		</form>
		<script type="text/javascript">function ProccessCheckbox(idvalue,value){document.getElementById(idvalue).value = value;}</script>
		<?php
	}
}
?>