<?php
/**
 * @package JMAP::CPANEL::administrator::components::com_jmap
 * @subpackage views
 * @subpackage cpanel
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2021 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );
use Joomla\CMS\Language\Text;
?>

<!-- === FREESTATS DASHBOARD === -->

<!-- GLOBAL RANK -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-chart-line fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{global_rank}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_GLOBAL_RANK'); ?></li>
	</ul>
</div>

<!-- PAGE RANK -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-star fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{page_rank}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_PAGE_RANK'); ?></li>
	</ul>
</div>

<!-- WEBSITE RANK -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-globe fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{website_rank}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_WEBSITE_RANK'); ?></li>
	</ul>
</div>

<!-- DAILY VISITORS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-users fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{daily_visitors}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_DAILY_VISITORS'); ?></li>
	</ul>
</div>

<!-- MONTHLY VISITORS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-user-clock fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{monthly_visitors}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_MONTHLY_VISITORS'); ?></li>
	</ul>
</div>

<!-- BOUNCE RATE -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-percentage fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{bounce_rate}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_BOUNCE_RATE'); ?></li>
	</ul>
</div>

<!-- RATING -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-thumbs-up fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{rating}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_RATING'); ?></li>
	</ul>
</div>

<!-- LOAD TIME -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-tachometer-alt fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{load_time_s}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_LOAD_TIME'); ?></li>
	</ul>
</div>

<!-- PAGE SIZE -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-file-code fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{page_size_kb}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_PAGE_SIZE'); ?></li>
	</ul>
</div>

<!-- GOOGLE INDEXED -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-search fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{google_indexed}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_GOOGLE_INDEXED'); ?></li>
	</ul>
</div>

<!-- IMAGES INDEXED -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-image fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{images_indexed}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_IMAGES_INDEXED'); ?></li>
	</ul>
</div>

<!-- INTERNAL LINKS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-code-branch fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{internal_links}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_INTERNAL_LINKS'); ?></li>
	</ul>
</div>

<!-- EXTERNAL LINKS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-external-link-alt fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{external_links}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_EXTERNAL_LINKS'); ?></li>
	</ul>
</div>

<!-- BACKLINKS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-link fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{backlinks_est}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_BACKLINKS_EST'); ?></li>
	</ul>
</div>

<!-- SERP KEYWORDS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-tags fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{serp_keywords}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_SERP_KEYWORDS'); ?></li>
	</ul>
</div>

<!-- ORGANIC KEYWORDS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-key fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{organic_keywords}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_ORGANIC_KEYWORDS'); ?></li>
	</ul>
</div>

<!-- META TAGS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-code fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{meta_tags}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_META_TAGS'); ?></li>
	</ul>
</div>

<!-- CONTENT ANALYSIS -->
<div class="single_stat_container">
	<div class="statcircle">
		<span class="fas fa-align-left fa-icon-large"></span>
	</div>
	<ul class="subdescription_stats">
		<li data-bind="{content_analysis}" class="es-stat-no"></li>
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_CONTENT_ANALYSIS'); ?></li>
	</ul>
</div>

<div class="single_stat_container seostatschart">
	<canvas id="freestatscanvas"></canvas>
	<ul class="subdescription_stats seostatschart">
		<li class="es-stat-title"><?php echo Text::_('COM_JMAP_FREESTATS_TREND_GRAPH');?></li>
	</ul>
</div>