<?php

namespace JchOptimize\Core\Admin\API;

use JchOptimize\Core\Admin\Ajax\OptimizeImage;
use JchOptimize\Core\Admin\Helper as AdminHelper;
use Joomla\DI\Container;
use Joomla\Input\Input;

class ProcessImagesByFolders extends \JchOptimize\Core\Admin\API\AbstractProcessImages
{
    private array $pendingDir;
    private array $pendingFiles;
    private $handle;
    private string $currentDir = '';

    public function __construct(Container $container, MessageEventInterface $messageEventObj)
    {
        parent::__construct($container, $messageEventObj);
        $input = $this->getContainer()->get(Input::class);
        $this->pendingDir = $input->get('subdirs', [], 'array');
        $this->pendingFiles = $input->get('files', [], 'array');
    }

    public function getFilePackages(): array
    {
        $excludes = [OptimizeImage::$backup_folder_name];
        [$files, $totalFileSize] = $this->initializeFileArray();
        do {
            try {
                $file = $this->getNextFile();
            } catch (\Exception $e) {
                return $files;
            }
            if ('.' != $file && '..' != $file && !\in_array($file, $excludes)) {
                $fullPath = $this->currentDir.'/'.\ltrim($file, '/\\');
                if (\is_dir($fullPath) && $this->params->get('recursive', '1')) {
                    $this->pendingDir[] = $fullPath;
                } elseif (\preg_match('#\\.(?:gif|jpe?g|png)$#i', $file) && (!$this->params->get('ignore_optimized', '1') || !\in_array($fullPath, AdminHelper::getOptimizedFiles()))) {
                    $fileSize = \filesize($fullPath);
                    // Skip file if it's too large
                    if ($fileSize > $this->maxUploadFilesize) {
                        $this->messageEventObj->send('Skipping '.AdminHelper::maskFileName($fullPath).': Too large!');

                        continue;
                    }
                    $totalFileSize += $fileSize;
                    if ($totalFileSize > $this->maxUploadFilesize) {
                        $this->prevFiles[] = $fullPath;
                        $this->prevFileSize = $fileSize;

                        return $files;
                    }
                    $files['images'][] = $fullPath;
                }
            }
        } while (\count($files['images']) < $this->getMaxFileUploads());

        return $files;
    }

    public function hasPendingImages(): bool
    {
        return !empty($this->pendingFiles) || !empty($this->pendingDir) || '' !== $this->currentDir;
    }

    /**
     * @throws \Exception
     */
    private function getNextFile(): string
    {
        if (!empty($this->pendingFiles)) {
            return $this->getPendingFiles();
        }
        if ('' == $this->currentDir && !empty($this->pendingDir)) {
            $this->currentDir = $this->getPendingDir();
        }
        if ('' === $this->currentDir) {
            throw new \Exception('No paths to read');
        }
        if (null === $this->handle) {
            $this->handle = \opendir($this->currentDir);
        }
        if (\false === $this->handle) {
            throw new \Exception('Failed opening dir');
        }
        $file = \readdir($this->handle);
        // No more files in directory
        if (\false === $file) {
            $this->handle = null;
            $this->currentDir = '';

            return $this->getNextFile();
        }

        return $file;
    }

    private function getPendingDir(): string
    {
        return \array_shift($this->pendingDir);
    }

    private function getPendingFiles(): string
    {
        return \array_shift($this->pendingFiles);
    }
}
