<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;

if (!Factory::getApplication()->getIdentity()->authorise('core.manage', 'com_helpdeskpro'))
{
	throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 404);
}

// Bootstrap the component
require_once __DIR__ . '/init.php';

// Get component config data
$config = require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/config.php';

// Creating component container
$container = OSL\Container\Container::getInstance('com_helpdeskpro', $config);

// If multilingual is enabled, make sure the database schema included all necessary fields to work with multilingual
if (Multilanguage::isEnabled() && !\OSSolution\HelpdeskPro\Site\Helper\Helper::isSyncronized())
{
	\OSSolution\HelpdeskPro\Site\Helper\Helper::setupMultilingual();
}

// Create controller, execute the request and redirect to the requested page if it is set
$controller = OSL\Controller\Controller::getInstance($container);
$controller->execute()
	->redirect();