<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;

ToolbarHelper::title(Text::_('HDP_DASHBOARD'));

Factory::getApplication()
	->getDocument()
	->addScriptOptions('chartData', $this->chartData)
	->addScriptOptions('baseUri', Uri::base(true))
	->getWebAssetManager()
	->useScript('core')
	->registerAndUseScript('com_helpdeskpro.chartjs.Chart', 'media/com_helpdeskpro/assets/js/chartjs/Chart.min.js')
	->registerAndUseScript('com_helpdeskpro.chartjs.chartjs-plugin-datalabels', 'media/com_helpdeskpro/assets/js/chartjs/chartjs-plugin-datalabels.min.js')
	->registerAndUseScript('com_helpdeskpro.admin-chart-default', 'media/com_helpdeskpro/js/admin-dashboard-default.js');

$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
?>
<div class="statistic-duration mt-4"><?php echo $this->lists['statistic_duration']; ?></div>
<div class="row mt-4">
	<div class="col-md-3">
		<div class="card">
			<div class="card-body d-flex justify-content-between align-items-center">
				<div>
					<div class="hdp-stat-number">
						<div id="hdp-total-number-categories"><?php echo $this->totalNumberCategories . '+'; ?></div>
					</div>
					<div class="hdp-state-label text-muted">
						<?php echo Text::_('HDP_TOTAL_CATEGORIES'); ?>
					</div>
				</div>
				<div class="hdp-dashboard-card-icon text-success">
					<i class="fa fa-3x fa-folder"></i>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-3">
		<div class="card">
			<div class="card-body d-flex justify-content-between align-items-center">
				<div>
					<div class="hdp-stat-number">
						<div id="hdp-total-number-tickets"><?php echo $this->totalNumberTickets . '+'; ?></div>
					</div>
					<div class="hdp-state-label text-muted">
						<?php echo Text::_('HDP_TOTAL_NUMBER_TICKETS'); ?>
					</div>
				</div>
				<div class="hdp-dashboard-card-icon text-success">
					<i class="fa fa-3x fa-envelope-open-text"></i>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-3">
		<div class="card">
			<div class="card-body d-flex justify-content-between align-items-center">
				<div>
					<div class="hdp-stat-number">
						<div id="hpd-total-closed-tickets"><?php echo $this->totalClosedTickets . '+'; ?></div>
					</div>
					<div class="hdp-state-label text-muted">
						<?php echo Text::_('HDP_TOTAL_CLOSED_TICKÉT'); ?>
					</div>
				</div>
				<div class="hdp-dashboard-card-icon text-success">
					<i class="fa fa-3x fa-lock"></i>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-3">
		<div class="card">
			<div class="card-body d-flex justify-content-between align-items-center">
				<div>
					<div class="hdp-stat-number">
						<div id="hdp-total-number-comments"><?php echo $this->totalNumberComments . '+'; ?></div>
					</div>
					<div class="hdp-state-label text-muted">
						<?php echo Text::_('HDP_TOTAL_NUMBER_COMMENTS'); ?>
					</div>
				</div>
				<div class="hdp-dashboard-card-icon text-success">
					<i class="fa fa-3x fa-reply"></i>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
	if (count($this->latestTickets))
	{
	?>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> mt-4">
			<div class="card">
				<div class="card-header">
					<?php echo Text::_('HDP_LATEST_UPDATED_TICKETS'); ?>
				</div>
				<div class="card-body">
					<?php echo $this->loadTemplate('tickets'); ?>
				</div>
			</div>
		</div>
	<?php
	}
?>
<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> mt-4">
	<div class="card">
		<div class="card-header">
			<?php echo Text::_('HDP_TICKETS_CHART'); ?>
		</div>
		<div class="card-body">
			<canvas id="hdp-tickets-chart"></canvas>
		</div>
	</div>
</div>