<?php

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

ToolbarHelper::title(Text::_('Activities Report'), 'generic.png');
?>
<div class="row-fluid">
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
		<form action="index.php?option=com_helpdeskpro&view=activities" method="post" name="adminForm" id="adminForm">
            <div id="filter-bar" class="btn-toolbar js-stools-container-filters-visible">
	            <div class="btn-group pull-left">
		            <?php echo $this->lists['filter_user_id']; ?>
	            </div>
	            <div class="btn-group pull-left">
		            <?php echo HTMLHelper::_('calendar', HTMLHelper::_('date', $this->state->filter_start_date, 'Y-m-d', null), 'filter_start_date', 'filter_start_date', '%Y-%m-%d', ['class' => 'input-medium', 'placeholder' => 'From Date']); ?>
	            </div>
	            <div class="btn-group pull-left">
		            <?php echo HTMLHelper::_('calendar', HTMLHelper::_('date', $this->state->filter_end_date, 'Y-m-d', null), 'filter_end_date', 'filter_end_date', '%Y-%m-%d', ['class' => 'input-medium', 'placeholder' => 'To Date']); ?>
	            </div>
	            <div class="btn-group pull-left">
		            <button type="submit" class="btn btn-primary hasTooltip"
		                    title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span
					            class="icon-search"></span></button>
	            </div>
			</div>
			<div class="clearfix"></div>
			<table class="adminlist table table-striped">
				<thead>
					<tr>
						<th>
							<?php echo Text::_('HDP_USER'); ?>
						</th>
						<th>
							<?php echo Text::_('Date / Time'); ?>
						</th>
						<th>
							<?php echo Text::_('Category'); ?>
						</th>
						<th>
							<?php echo Text::_('HDP_TICKET'); ?>
						</th>
						<th width="60%">
							<?php echo Text::_('Comment');?>
						</th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="5" style="font-weight: 18px; text-align: center;">
							<?php echo Text::sprintf('Total activities: <strong>%s</strong>', count($this->data)); ?>
						</td>
					</tr>
				</tfoot>
				<tbody>
					<?php
						$toDayDate = Factory::getDate('now', Factory::getApplication()->get('offset'))->format('Y-m-d');
						foreach($this->data as $activity)
						{
						?>
							<tr>
								<td>
									<?php echo $this->userMap[$activity->user_id]; ?>
								</td>
								<td>
									<?php
										if (HTMLHelper::_('date', $activity->date_added, 'Y-m-d') == $toDayDate)
										{
											echo HTMLHelper::_('date', $activity->date_added, 'G:i');
										}
										else
										{
											echo HTMLHelper::_('date', $activity->date_added, 'm-d-Y G:i');
										}
									?>
								</td>
								<td>
									<?php echo $activity->category_title; ?>
								</td>
								<td>
									<a href="index.php?option=com_helpdeskpro&view=ticket&id=<?php echo $activity->ticket_id ?>" target="_blank">#<?php echo $activity->ticket_id; ?></a>
								</td>
								<td>
									<?php echo HTMLHelper::_('string.truncate', $activity->message, 200); ?>
								</td>
							</tr>
						<?php
						}
					?>
				</tbody>
			</table>
		</form>
	</div>
</div>