<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

if(empty($this->data("table"))){
	ChronoSession::setFlash("error", "Table name is missing");
	ChronoApp::$instance->Redirect(ChronoApp::$instance->extension_url."&action=ma.tables");
}

$model = new ChronoModel();
$model->Table = $this->data("table");

$tcolumns = ExtensionsModel::instance()->Select(sql: "SHOW FULL COLUMNS FROM ".$this->data("table"));
// Chrono::pr($tcolumns);

$conditions = [];
$pkeys = [];
$tfields = [];
foreach($tcolumns as $tcolumn){
	$tfields[] = $tcolumn["Field"];
	if($tcolumn["Key"] == "PRI"){
		$conditions[] = [$tcolumn["Field"], "=", ChronoApp::$instance->data($tcolumn["Field"])];
		$pkeys[] = $tcolumn["Field"];
	}
}

$row = $model->Select(conditions: $conditions, single: true);

if (ChronoApp::$instance->isPost) {
	$model->Fields = $tfields;
	
	if(is_null($row)){
		$data = $_POST;
		foreach($pkeys as $pkey){
			if(strlen(ChronoApp::$instance->data($pkey)) == 0){
				unset($data[$pkey]);
			}
		}
		$result = $model->Insert($data);
		// Chrono::pr($result);

		if ($result !== false) {
			ChronoSession::setFlash("success", Chrono::l("Row saved successfully."));
			ChronoApp::$instance->redirect(ChronoApp::$instance->extension_url . "&action=ma.browse&table=".$this->data("table"));
		}else{
			ChronoSession::setFlash("error", Chrono::l("Error saving record"));
		}
	}else{
		$where = [];
		foreach($pkeys as $pkey){
			$where[] = $pkey."=".$model->quote(ChronoApp::$instance->data($pkey));
		}
		$result = $model->Update($_POST, implode(" AND ", $where));

		if ($result === true) {
			ChronoSession::setFlash("success", Chrono::l("row updated successfully."));
		}else{
			ChronoSession::setFlash("error", Chrono::l("Error updating row"));
		}
	}
}
?>

<form class="nui form" action="<?php echo ChronoApp::$instance->current_url; ?>" method="post" enctype="multipart/form-data" accept-charset="UTF-8">
<?php
require(__DIR__."/ma.menubar.php");

foreach($tcolumns as $tcolumn){
	$type = "text";
	$code = "";
	if(str_contains(strtolower($tcolumn["Type"]), "text")){
		$type = "textarea";
	}
	if(str_contains(strtolower($tcolumn["Type"]), "int")){
		$code .= ' style="width:25%;"';
	}
	if(($tcolumn["Null"] == "YES") && (is_null($row) || is_null($row[$tcolumn["Field"]]))){
		$code .= ' disabled="disabled"';
	}
	$value = "";
	if(is_null($row)){
		if($tcolumn["Default"] != "NULL" && !is_null($tcolumn["Default"])){
			$value = $tcolumn["Default"];
		}else{
			if($tcolumn["Type"] == "datetime"){
				$value = gmdate("Y-m-d H:i:s");
			}
		}
	}else{
		if(!is_null($row[$tcolumn["Field"]])){
			$value = $row[$tcolumn["Field"]];
		}
	}
	
	echo '<div class="fields first-grow">';
	new FormField(name: $tcolumn["Field"], type: $type, label: $tcolumn["Field"]." - ".$tcolumn["Type"], value: $value, code:$code);

	if($tcolumn["Null"] == "YES"){
		$checked = false;
		if(is_null($row) || is_null($row[$tcolumn["Field"]])){
			$checked = true;
		}
		new FormField(name: $tcolumn["Field"]."_null", type: "checkbox", value: 1, checked:$checked, code:" onclick=\"document.getElementById('".strtolower($tcolumn["Field"])."').toggleAttribute('disabled')\"");
	}
	echo '</div>';
}
?>
</form>