<?php

/**
 * @package Finatic
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted access');

class SppagebuilderAddonTestimonial_slider extends SppagebuilderAddons
{

	public function render()
	{
		$output = '<div class="finatic-testimonial-slider">';
		$output .= '<div id="finatic-carousel" class="owl-carousel">';
		foreach ($this->addon->settings->finatic_testimonial_slider_item as $key => $item) {
			$src = "";
			if (isset($item->img)) {
				if (is_object($item->img)) {
					$src = $item->img->src;
				} elseif (is_string($item->img)) {
					$src = $item->img;
				}
				if (strpos($src, "http://") === 0 || strpos($src, "https://") === 0) {
					$src = $src;
				} else {
					$src = JURI::base() . $src;
				}
			}
	
			$name = isset($item->name) ? $item->name : 'Item Name';
	
			$output .= '<div class="item">';
			$output .= '<h3>' . (isset($item->title) ? $item->title : 'Default Title') . '</h3>'; // Fallback for title
			$output .= '<div class="finatic-testimonial-footer">';
			$output .= '<img src="' . $src . '">';
			$output .= '<p>' . $name . '</p>'; // Use $name instead of $item->name
			$output .= '</div>';
			$output .= '</div>';
		}
		$output .= '</div>';
		$output .= '</div>';
	
		return $output;
	}

	public function scripts()
	{
		$app = JFactory::getApplication();
		$base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/js/';
		return array($base_path . 'owl.carousel.min.js', $base_path . 'addon.slider.js');
	}

	public function js()
	{
		$addon_id = '#sppb-addon-' . $this->addon->id;
		return '
            jQuery(document).ready(function($){"use strict";

            $("' . $addon_id . ' #finatic-carousel").owlCarousel({
                margin: 30,
                loop: true,
                video:true,
                autoplay: true,
								dots: false,
								nav: false,
                autoplaySpeed: 800,
                responsive: {
										0: {
											items: 1
										},
                    520: {
											items: 2
                    },
										768: {
											items: 3
                    },
                    1000: {
											items: 4
                    },
                    1310: {
											items: 5
                    }
                },
								onInitialized: function() {
										$(".owl-item.active").last().addClass("last-owl-active-item");
								},
								onTranslated: function() {
										$(event.target).find(".last-owl-active-item").removeClass("last-owl-active-item");
										$(event.target).find(".active").last().addClass("last-owl-active-item");
								}
            });
        });
        ';
	}

	public function stylesheets()
	{
		$app = JFactory::getApplication();
		$base_path = JURI::base() . '/templates/' . $app->getTemplate() . '/css/';
		return array($base_path . 'owl.carousel.min.css');
	}

	public static function getTemplate()
	{
		$output = '
					<div class="finatic-testimonial-slider">
						<div id="finatic-carousel" class="owl-carousel">
							<# _.each (data.finatic_testimonial_slider_item, function(item, key) { 
								let src = "";
								if(typeof item.img !== "undefined") {
									if(typeof item.img === "object"){
										if(item.img.src.indexOf("http://") === 0 || item.img.src.indexOf("https://") === 0){
											src = `src=${item.img.src}`;
										} else {
											src = `src=${pagebuilder_base + item.img.src}`;
										}
									} else {
										if(item.img.indexOf("http://") === 0 || item.img.indexOf("https://") === 0){
											src = `src=${item.img}`;
										} else {
											src = `src=${pagebuilder_base + item.img}`;
										}
									}
								}
								#>
								<div class="item">
									<h3>{{item.title}}</h3>
									<div class="finatic-testimonial-footer">
										<img {{src}}>
										<p>{{item.name}}</p>
									</div>
								</div>
							<# }); #>
						</div>
					</div>
					';
		return $output;
	}
}
