<?php
/**
 * 4LOGS
 *
 * @package      4LOGS
 * @copyright    Copyright Weeblr llc - 2021
 * @author       Yannick Gaultier - Weeblr llc
 * @license      GNU General Public License version 3; see LICENSE.md
 * @version      1.1.2.217
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Platform\Joomla;

use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Joomla\CMS\Factory;

use Weeblr\Wblib\V_FORLOGS_217\Platform\Platformdbconnectioninterface;

/* Security check to ensure this file is being included by a parent file.*/
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 *
 * Interface to Joomla! database driver
 *
 * @author weeblr
 *
 */
class Dbconnection implements Platformdbconnectioninterface
{
	protected $db = null;

	public function __construct($uniqueId = '', $db = null)
	{
		$this->_uniqueId = Wb\initEmpty($uniqueId, Factory::getConfig()->get('secret'));
		$this->db        = Wb\initEmpty($db, Factory::getDbo());
	}

	public function getQuery()
	{
		return $this->db->getQuery();
	}

	public function getPrefix()
	{
		return $this->db->getPrefix();
	}

	public function quote($data, $escape = true)
	{
		return $this->db->quote($data, $escape = true);
	}

	public function quoteName($data)
	{
		return $this->db->quoteName($data);
	}

	public function quoteTable($data)
	{
		return $this->db->quoteName($data);
	}

	public function escape($data, $extra = false)
	{
		return $this->db->escape($data);
	}

	public function getNullDate()
	{
		return $this->db->getNullDate();
	}

	public function setQuery($query, $offset = 0, $limit = 0)
	{
		return $this->db->setquery($query, $offset, $limit);
	}

	public function loadAssoc()
	{
		return $this->db->loadAssoc();
	}

	public function loadAssocList($key = null, $column = null)
	{
		return $this->db->loadAssocList($key, $column);
	}

	public function loadColumn($offset = 0)
	{
		return $this->db->loadColumn($offset);
	}

	public function loadObject()
	{
		return $this->db->loadObject();
	}

	public function loadObjectList($key = '')
	{
		return $this->db->loadObjectList($key);
	}

	public function loadResult()
	{
		return $this->db->loadResult();
	}

	public function loadRow()
	{
		return $this->db->loadRow();
	}

	public function loadRowList($key = null)
	{
		return $this->db->loadRowList($key);
	}

	public function getInsertId()
	{
		return $this->db->insertId();
	}

	/**
	 * Start a transation.
	 *
	 * @return mixed
	 */
	public function transactionStart()
	{
		return $this->db->transactionStart();
	}

	/**
	 * Commit queries in transaction.
	 *
	 * @return mixed
	 */
	public function transactionCommit()
	{
		return $this->db->transactionCommit();
	}

	/**
	 * Rollback queries from transaction.
	 *
	 * @return mixed
	 */
	public function transactionRollback()
	{
		return $this->db->transactionRollback();
	}

	public function execute()
	{
		return $this->db->execute();
	}
}
