<?php
/**
 * Project:                 4LOGS
 *
 * @author                  Yannick Gaultier - Weeblr llc
 * @copyright               Copyright Weeblr llc - 2021
 * @package                 4LOGS
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 @build_version_full_build@
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Mvc;

use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Weeblr\Wblib\V_FORLOGS_217\Base;

/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 * Updates to a standard HTML page, which has an AMP version
 */
abstract class ControllerController extends Base\Base
{
	protected $options = array();

	/**
	 * Constructor
	 *
	 * @param   array  $options  An array of options.
	 */
	public function __construct($options = array())
	{
		parent::__construct();
		$this->options = $options;
	}

	/**
	 * Builds a view and render it with the provided data.
	 */
	public abstract function render($data);

	/**
	 * Builds up an array of data for use in layouts output.
	 *
	 * @param   array  $incomingData
	 *
	 * @return array
	 */
	protected function getData($incomingData = array())
	{
		$data = Wb\arrayMerge(
			array(),
			$incomingData
		);

		return $data;
	}
}