<?php
/**
 * Project:                 4LOGS
 *
 * @author                  Yannick Gaultier - Weeblr llc
 * @copyright               Copyright Weeblr llc - 2021
 * @package                 4LOGS
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 @build_version_full_build@
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Base;

use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Weeblr\Wblib\V_FORLOGS_217\Factory;
use Weeblr\Wblib\V_FORLOGS_217\Platform\Platform;

/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 * Base class to access the factory.
 *
 */
class Base
{
	/**
	 * @var Factory Unique instance of the factory.
	 */
	protected $factory = null;

	/**
	 * @var Platform The platform instance.
	 */
	protected $platform = null;

	/**
	 * Stores factory instance.
	 *
	 * @param   array  $options  Can inject custom factory and platform.
	 */
	public function __construct($options = [])
	{
		$this->factory = Wb\arrayGet(
			$options,
			'factory',
			Factory::get()
		);

		$this->platform = Wb\arrayGet(
			$options,
			'platform',
			$this->factory->getThe('platform')
		);
	}
}
