<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 */

namespace Weeblr\Forlogs\Model;

use Weeblr\Forlogs\Helper;
use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Weeblr\Wblib\V_FORLOGS_217\Base;
use Weeblr\Wblib\V_FORLOGS_217\System;
use Weeblr\Wblib\V_FORLOGS_217\Fs;
use Weeblr\Wblib\V_FORLOGS_217\Joomla\StringHelper\StringHelper;

// Security check to ensure this file is being included by a parent file.
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

class File extends Base\Base
{
	/**
	 * @var string full path to the file
	 */
	public $path = '';

	/**
	 * @var string Buffer to store the content of the file
	 */
	public $content = '';

	/**
	 * Store a sitemap config for convenience.
	 */
	public function __construct($options = [])
	{
		parent::__construct();

		$this->content = Wb\arrayGet($options, 'content', '');

		$this->path = $this->factory
			->getA(Helper\File::class)
			->sanitizePath(
				Wb\arrayGet($options, 'path', ''),
				Wb\arrayGet($options, 'root', '')
			);
	}

	/**
	 * Reads content of any existing file into buffer.
	 *
	 * @return $this
	 */
	public function load()
	{

		if (!file_exists($this->path)
			||
			!is_file($this->path)
		)
		{
			$this->content = '';
			return $this;
		}

		$filesize = filesize($this->path);

		if (empty($filesize))
		{
			$this->content = '';
			return $this;
		}

		$content = Fs\File::forceRead($this->path);
		if ($filesize > 250000)
		{
			$this->content = $content;
		}
		else
		{
			// small file, split per line for enhanced display
			$sep = "\n";
			if (strpos($content, "\r\n") !== false)
			{
				$sep = "\r\n";
			}
			else if (strpos($content, "\r") !== false)
			{
				$sep = "\r";
			}
			$this->content = explode($sep, $content);
		}

		return $this;
	}

	/**
	 * Write content of current buffer into file. This may result into an empty file.
	 *
	 * @return $this
	 */
	public function write()
	{
		$updatedContent = StringHelper::trim(
			$this->content
		);
		if (empty($updatedContent))
		{
			Fs\File::forceDelete($this->path);
		}
		else
		{
			Fs\File::forceWrite(
				$this->path,
				$this->content
			);
		}

		return $this;
	}
}