<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 */

namespace Weeblr\Forlogs\Helper;

use Weeblr\Wblib\V_FORLOGS_217\Wb;
use Weeblr\Wblib\V_FORLOGS_217\Base;
use Weeblr\Wblib\V_FORLOGS_217\System;

// Security check to ensure this file is being included by a parent file.
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

class File extends Base\Base
{
	/**
	 * Sanitize provided path to a file and build its full path. Does not check existence,
	 * only well-formed file path and inside site root.
	 *
	 * @param string $path
	 * @param string root
	 * @return \Exception|string
	 * @throws \Exception
	 */
	public function sanitizePath($path, $root)
	{
		$path      = Wb\slashForward($path);
		$root      = Wb\slashForward($root);
		$saferPath = str_replace(
			['./', '..'],
			'',
			$path
		);

		if ($saferPath !== $path)
		{
			throw new \Exception('Trying to read invalid file path.', System\Http::RETURN_BAD_REQUEST);
		}

		return Wb\slashTrimJoin(
			$root,
			$path
		);
	}
}