<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/**
 * Layout variables
 *
 * @var array  $rows
 * @var string $dateFormat
 */

/* @var \Joomla\CMS\Application\CMSApplication $app */
$app    = $this->getApplication();
$isSite = $app->isClient('site');

if ($isSite)
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
?>
	<tr>
		<th colspan="2" class="hdp-tickets-history <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>"><?php echo Text::_('HDP_TICKET_HISTORY'); ?></th>
	</tr>
<?php
foreach ($rows as $row)
{
	if ($isSite)
	{
		$link = HelpdeskproRoute::getTicketRoute($row->id);
	}
	else
	{
		$link = 'index.php?option=com_helpdeskpro&view=ticket&id=' . (int) $row->id;
	}
?>
	<tr>
		<td colspan="2">
			<a href="<?php echo Route::_($link) ?>" target="_blank">
				[#<?php echo $row->id; ?>]&nbsp;-&nbsp;<?php echo $row->subject ?>
				(<?php echo HTMLHelper::_('date', $row->created_date, $dateFormat); ?>)
			</a>
		</td>
	</tr>
<?php
}
