<?php

/*------------------------------------------------------------------------
# horizontal.php - mod_ospropertysearch
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2022 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
?>
<script type="text/javascript">
    function updateMyLocation(){
        if(navigator.geolocation){
            navigator.geolocation.getCurrentPosition(modSearchShowPosition,
                function(error){
                    alert("<?php echo str_ireplace('"', "'",Text::_(''));?>");

                }, {
                    timeout: 30000, enableHighAccuracy: true, maximumAge: 90000
                });
        }
    }

    function modSearchShowPosition(position){
        var exdate=new Date();
        exdate.setDate(exdate.getDate() + 1);
        var ll = position.coords.latitude+'_'+position.coords.longitude;
        document.cookie = "djcf_latlon=" + ll + "; expires=" + exdate.toUTCString()+";path=/";
        document.getElementById('se_geoloc<?php echo $random_id?>').value = '1';
        document.getElementById('ossearchForm<?php echo $random_id?>').submit();
    }

    function submitSearchForm<?php echo $random_id?>(){
        var ossearchForm = document.getElementById('ossearchForm<?php echo $random_id?>');
        var keyword = ossearchForm.keyword;
        var category_id = ossearchForm.category_id;
        var agent_type = ossearchForm.agent_type;
        var property_type = ossearchForm.property_type;
        var agent_id = ossearchForm.agent_id;
        var state = ossearchForm.state;
        var fields = ossearchForm.fields.value;
        var canSubmit = 1;
        var emptyFiemd = 0;
        var mcountry_id = document.getElementById('mcountry_id<?php echo $random_id?>');
        var country_id = ossearchForm.country_id;
        var city = ossearchForm.city;
        var mstate_id = document.getElementById('mstate_id<?php echo $random_id?>');
        var state_id = ossearchForm.state_id;
        var mcity = document.getElementById('city<?php echo $random_id?>');
        if((mcountry_id != null) && (country_id != null)){
            country_id.value = mcountry_id.value;
        }
        if((mstate_id != null) && (state_id != null)){
            state_id.value = mstate_id.value;
        }
        if(( mcity != null) && (city != null)){
            city.value = mcity.value;
        }
        if(fields != ""){
            var fieldArr = fields.split(",");
            var length = fieldArr.length;
            if(keyword != null){
                if(keyword.value == ""){
                    emptyFiemd++;
                }
            }
            if(agent_type != null){
                if(agent_type.value == ""){
                    emptyFiemd++;
                }
            }
            if(property_type != null){
                if(property_type.value == ""){
                    emptyFiemd++;
                }
            }
            if(state != null){
                if(state.value == ""){
                    emptyFiemd++;
                }
            }

        }else{
            ossearchForm.submit();
        }
    }
</script>
<?php
if($samepage == 1){
    $itemid  = $jinput->getInt('Itemid');
}else{
    $needs = array();
    $needs[] = "ladvsearch";
    $needs[] = "property_advsearch";
    $itemid  = OSPRoute::getItemid($needs);
}
$field = "";

// Count visible fields for dynamic layout
$visible_fields = 0;
if($show_keyword == 1) $visible_fields++;
if($show_type == 1 && $type_id == 0) $visible_fields++;
if($show_category == 1) $visible_fields++;
if($show_agenttype == 1) $visible_fields++;
?>
<form method="POST" action="<?php echo Route::_('index.php?option=com_osproperty&view=ladvsearch&Itemid='.$itemid)?>" name="ossearchForm<?php echo $random_id?>" id="ossearchForm<?php echo $random_id?>">
    <div class="ospsearch horizontal_search <?php echo $moduleclass_sfx ?>">
        <!-- Main Search Row -->
        <div class="horizontal_search_grid">
            <?php if($show_keyword == 1): ?>
            <div class="horizontal_search_item">
                <input type="text" class="form-control horizontal_input" value="<?php echo OSPHelper::getStringRequest('keyword','')?>" id="keyword" name="keyword" placeholder="<?php echo Text::_('OS_SEARCH_KEYWORD')?>" />
            </div>
            <?php endif; ?>
            
            <?php if($show_type == 1 && $type_id == 0): ?>
            <div class="horizontal_search_item">
                <?php echo $lists['type'];?>
            </div>
            <?php endif; ?>
            
            <?php if($show_category == 1): ?>
            <div class="horizontal_search_item">
                <?php echo modOspropertySearchHelper::listCategoriesHorizontal($category_id,'',''); ?>
            </div>
            <?php endif; ?>
            
            <?php if($show_agenttype == 1): ?>
            <div class="horizontal_search_item">
                <?php echo $lists['agenttype'];?>
            </div>
            <?php endif; ?>
            
            <div class="horizontal_search_item horizontal_search_buttons">
                <button class="btn btn-primary horizontal_search_btn" onclick="javascript:submitSearchForm<?php echo $random_id?>()" type="button">
                    <i class="osicon-search icon-search"></i>&nbsp;<?php echo Text::_('OS_SEARCH')?>
                </button>
                <?php if($show_address_slide == 1 || $show_details_slide == 1 || $show_price == 1 || $show_amenity_slide == 1): ?>
                <a href="javascript:void(0);" id="moreoption<?php echo $random_id?>" class="horizontal_more_options">
                    <i class="osicon-chevron-down icon-chevron-down"></i> <?php echo Text::_('OS_MORE_OPTIONS');?>
                </a>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Extended Options (Hidden by default) -->
        <div class="horizontal_extended_options" id="extendedoptions<?php echo $random_id?>" style="display:none;">
            <?php if($show_address_slide == 1): ?>
            <!-- Address Section -->
            <div class="horizontal_search_section">
                <div class="horizontal_section_title"><?php echo Text::_('OS_SEARCH_ADDRESS'); ?></div>
                <div class="horizontal_search_grid">
                    <?php if(HelperOspropertyCommon::checkCountry()): ?>
                    <div class="horizontal_search_item">
                        <?php echo $lists['country'];?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if(!OSPHelper::userOneState()): ?>
                    <div class="horizontal_search_item" id="country_state_search_module<?php echo $random_id?>">
                        <?php echo $lists['state'];?>
                    </div>
                    <?php endif; ?>
                    
                    <div class="horizontal_search_item" id="city_div_search_module<?php echo $random_id?>">
                        <?php echo $lists['city'];?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if($show_price == 1): ?>
            <!-- Price Section -->
            <div class="horizontal_search_section">
                <div class="horizontal_section_title"><?php echo Text::_('OS_SEARCH_PRICE'); ?></div>
                <div class="horizontal_search_grid" id="mod_ossearch_price">
                    <?php
                    OSPHelper::showPriceFilter($price,$jinput->getInt('min_price',0),$jinput->getInt('max_price',0),$property_type,'input-medium',$module->id);
                    ?>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if($show_details_slide == 1): ?>
            <!-- Details Section -->
            <div class="horizontal_search_section">
                <div class="horizontal_section_title"><?php echo Text::_('OS_SEARCH_DETAILS'); ?></div>
                <div class="horizontal_search_grid">
                    <?php if($configClass['use_bathrooms'] == 1): ?>
                    <div class="horizontal_search_item">
                        <?php echo $lists['nbath'];?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($configClass['use_bedrooms'] == 1): ?>
                    <div class="horizontal_search_item">
                        <?php echo $lists['nbed'];?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($configClass['use_rooms'] == 1): ?>
                    <div class="horizontal_search_item">
                        <?php echo $lists['nroom'];?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($configClass['use_nfloors'] == 1): ?>
                    <div class="horizontal_search_item">
                        <?php echo $lists['nfloor'];?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($configClass['use_squarefeet'] == 1): ?>
                    <div class="horizontal_search_item horizontal_search_item_double">
                        <div class="horizontal_range_inputs">
                            <input type="text" class="form-control horizontal_input" name="sqft_min" id="sqft_min" placeholder="<?php echo Text::_('OS_MIN_SQUARE') ?> (<?php echo OSPHelper::showSquareSymbol();?>)"
                                   value="<?php echo ($lists['sqft_min'] > 0) ? $lists['sqft_min'] : ""; ?>"/>
                            <span class="horizontal_range_separator">-</span>
                            <input type="text" class="form-control horizontal_input" name="sqft_max" id="sqft_max" placeholder="<?php echo Text::_('OS_MAX_SQUARE') ?> (<?php echo OSPHelper::showSquareSymbol();?>)"
                                   value="<?php echo ($lists['sqft_max'] > 0) ? $lists['sqft_max'] : ""; ?>"/>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if($show_amenity_slide == 1): ?>
            <!-- Amenities Section -->
            <div class="horizontal_search_section">
                <div class="horizontal_section_title"><?php echo Text::_('OS_SEARCH_AMENITIES'); ?></div>
                <div class="horizontal_amenities_grid">
                    <?php
                    $optionArr = array();
                    $optionArr[] = Text::_('OS_GENERAL_AMENITIES');
                    $optionArr[] = Text::_('OS_ACCESSIBILITY_AMENITIES');
                    $optionArr[] = Text::_('OS_APPLIANCE_AMENITIES');
                    $optionArr[] = Text::_('OS_COMMUNITY_AMENITIES');
                    $optionArr[] = Text::_('OS_ENERGY_SAVINGS_AMENITIES');
                    $optionArr[] = Text::_('OS_EXTERIOR_AMENITIES');
                    $optionArr[] = Text::_('OS_INTERIOR_AMENITIES');
                    $optionArr[] = Text::_('OS_LANDSCAPE_AMENITIES');
                    $optionArr[] = Text::_('OS_SECURITY_AMENITIES');
                    for($k = 0;$k<count($optionArr);$k++) {
                        $db->setQuery("Select * from #__osrs_amenities where category_id = '" . $k . "' and published = '1'");
                        $tmpamenities = $db->loadObjectList();
                        if (count($tmpamenities) > 0) {
                            ?>
                            <div class="horizontal_amenity_group">
                                <div class="horizontal_amenity_title"><?php echo $optionArr[$k]; ?></div>
                                <div class="horizontal_amenity_items">
                                    <?php
                                    for ($i = 0; $i < count($tmpamenities); $i++) {
                                        $checked = "";
                                        if (count($amenities_post) > 0) {
                                            if (in_array($tmpamenities[$i]->id, $amenities_post)) {
                                                $checked = "checked";
                                            }
                                        }
                                        ?>
                                        <label class="horizontal_amenity_checkbox">
                                            <input type="checkbox" name="amenities[]" value="<?php echo $tmpamenities[$i]->id;?>" <?php echo $checked;?> />
                                            <span><?php echo OSPHelper::getLanguageFieldValue($tmpamenities[$i], 'amenities');?></span>
                                        </label>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php
    if(!HelperOspropertyCommon::checkCountry())
    {
        echo $lists['country'];
    }
    if(OSPHelper::userOneState())
    {
        echo $lists['state'];
    }
    ?>
    <input type="hidden" name="state_id"  value="" />
    <input type="hidden" name="country_id"  value="" />
    <input type="hidden" name="city" value="" />
    <input type="hidden" name="fields" id="fields" value="<?php echo $field?>" />
    <input type="hidden" name="option" value="com_osproperty" />
    <input type="hidden" name="task" value="property_advsearch" />
    <input type="hidden" name="Itemid" value="<?php echo $itemid;?>" />
    <input type="hidden" name="show_advancesearchform" value="<?php echo $show_advancesearchform?>" />
    <?php
    OSPHelper::showPriceTypesConfig();
    ?>
    <?php
    if(count((array)$types) > 0){
        foreach ($types as $type){
            ?>
            <input type="hidden" name="searchmoduletype_id_<?php echo $type->id?>" id="searchmoduletype_id_<?php echo $type->id?>" value="<?php echo implode(",",$type->fields);?>"/>
            <?php
        }
    }
    ?>
</form>
<script type="text/javascript">
    jQuery('#moreoption<?php echo $random_id?>').click(function(){
        var $icon = jQuery(this).find('i');
        var $extended = jQuery('#extendedoptions<?php echo $random_id?>');
        
        if($extended.is(':visible')){
            $extended.slideUp('slow');
            $icon.removeClass('osicon-chevron-up icon-chevron-up').addClass('osicon-chevron-down icon-chevron-down');
            jQuery(this).contents().last().replaceWith(' <?php echo Text::_('OS_MORE_OPTIONS');?>');
        } else {
            $extended.slideDown('slow');
            $icon.removeClass('osicon-chevron-down icon-chevron-down').addClass('osicon-chevron-up icon-chevron-up');
            jQuery(this).contents().last().replaceWith(' <?php echo Text::_('OS_LESS_OPTIONS');?>');
        }
    });
    
    function modOspropertySearchChangeDiv(div_name){
        var div  = document.getElementById(div_name);
        var atag = document.getElementById('a' + div_name);
        if(div.style.display == "block"){
            div.style.display = "none";
            atag.innerHTML = '[+]';

        }else{
            div.style.display = "block";
            atag.innerHTML = '[-]';
        }
    }

    function modOspropertyChangeValue(item){
        var temp  = document.getElementById(item);
        if(temp.value == 0){
            temp.value = 1;
        }else{
            temp.value = 0;
        }
    }
    function change_country_companyModule<?php echo $random_id?>(country_id,state_id,city_id,random_id){
        var live_site = '<?php echo Uri::root()?>';
        loadLocationInfoStateCityLocatorModule(country_id,state_id,city_id,'mcountry_id' + random_id,'mstate_id' + random_id,live_site,random_id);
    }
    function change_stateModule<?php echo $random_id?>(state_id,city_id,random_id){
        var live_site = '<?php echo Uri::root()?>';
        loadLocationInfoCityModule(state_id,city_id,'mstate_id' + random_id,live_site,random_id);
    }
    <?php if($show_customfields == 1){?>
    jQuery("#property_type<?php echo $module->id?>").change(function(){
        var fields = jQuery("#searchmodulefield_ids").val();
        var fieldArr = fields.split(",");
        if(fieldArr.length > 0){
            for(i=0;i<fieldArr.length;i++){
                jQuery("#searchmoduleextrafields_" + fieldArr[i]).hide("fast");
            }
        }
        var selected_value = jQuery("#property_type<?php echo $module->id?>").val();
        var selected_fields = jQuery("#searchmoduletype_id_" + selected_value).val();
        var fieldArr = selected_fields.split(",");
        if(fieldArr.length > 0){
            for(i=0;i<fieldArr.length;i++){
                jQuery("#searchmoduleextrafields_" + fieldArr[i]).show("slow");
            }
        }
    });
    <?php } ?>
    <?php
    if($show_price == 1){
    ?>
    jQuery("#property_type<?php echo $module->id;?>").change(function() {
        updatePrice(jQuery("#property_type<?php echo $module->id;?>").val(),"<?php echo Uri::root(); ?>");
    });
    <?php } ?>
    function updatePrice(type_id,live_site){
        xmlHttp=GetXmlHttpObject();
        url = live_site + "index.php?option=com_osproperty&no_html=1&tmpl=component&task=ajax_updatePrice&type_id=" + type_id + "&option_id=<?php echo $price;?>&min_price=<?php echo $jinput->getInt('min_price',0);?>&max_price=<?php echo $jinput->getInt('max_price',0);?>&module_id=<?php echo $module->id;?>";
        xmlHttp.onreadystatechange = ajax_updateSearch;
        xmlHttp.open("GET",url,true)
        xmlHttp.send(null)
    }

    function ajax_updateSearch(){
        if (xmlHttp.readyState==4 || xmlHttp.readyState=="complete"){
            var mod_osservice_price = document.getElementById("mod_ossearch_price");
            if(mod_osservice_price != null) {
                mod_osservice_price.innerHTML = xmlHttp.responseText;
                var ptype = jQuery("#property_type<?php echo $module->id;?>").val();
                jQuery.ui.slider.prototype.widgetEventPrefix = 'slider';
                jQuery(function () {
                    var min_value = jQuery("#min" + ptype).val();
                    min_value = parseFloat(min_value);
                    var step_value = jQuery("#step" + ptype).val();
                    step_value = parseFloat(step_value);
                    var max_value = jQuery("#max" + ptype).val();
                    max_value = parseFloat(max_value);
                    jQuery("#<?php echo $module->id;?>sliderange").slider({
                        range: true,
                        min: min_value,
                        step: step_value,
                        max: max_value,
                        values: [min_value, max_value],
                        slide: function (event, ui) {
                            var price_from = ui.values[0];
                            var price_to = ui.values[1];
                            jQuery("#<?php echo $module->id;?>price_from_input1").val(price_from);
                            jQuery("#<?php echo $module->id;?>price_to_input1").val(price_to);

                            price_from = price_from.formatMoney(0, ',', '.');
                            price_to = price_to.formatMoney(0, ',', '.');

                            jQuery("#<?php echo $module->id;?>price_from_input").text(price_from);
                            jQuery("#<?php echo $module->id;?>price_to_input").text(price_to);
                        }
                    });
                });
                Number.prototype.formatMoney = function (decPlaces, thouSeparator, decSeparator) {
                    var n = this,
                        decPlaces = isNaN(decPlaces = Math.abs(decPlaces)) ? 2 : decPlaces,
                        decSeparator = decSeparator == undefined ? "." : decSeparator,
                        thouSeparator = thouSeparator == undefined ? "," : thouSeparator,
                        sign = n < 0 ? "-" : "",
                        i = parseInt(n = Math.abs(+n || 0).toFixed(decPlaces)) + "",
                        j = (j = i.length) > 3 ? j % 3 : 0;
                    return sign + (j ? i.substr(0, j) + thouSeparator : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thouSeparator) + (decPlaces ? decSeparator + Math.abs(n - i).toFixed(decPlaces).slice(2) : "");
                };
            }
        }
    }
</script>