<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
defined('_JEXEC') or die;

if (file_exists(JPATH_ROOT . '/components/com_osmembership/osmembership.php'))
{
	$view        = $params->get('view', 'plans');
	$queryString = $params->get('query_string', '');
	require_once JPATH_ADMINISTRATOR . '/components/com_osmembership/loader.php';
	OSMembershipHelper::loadLanguage();

	$request = ['option' => 'com_osmembership', 'view' => $view, 'hmvc_call' => 1];

	if ($queryString)
	{
		parse_str($queryString, $vars);
		$request = array_merge($request, $vars);
	}

	if (!isset($request['limitstart']))
	{
		$appInput   = JFactory::getApplication()->input;
		$start      = $appInput->get->getInt('start', 0);
		$limitStart = $appInput->get->getInt('limitstart', 0);

		if ($start && !$limitStart)
		{
			$limitStart = $start;
		}

		$request['limitstart'] = $limitStart;
	}

	$input  = new MPFInput($request);
	$config = [
		'default_controller_class' => 'OSMembershipController',
		'default_view'             => 'plans',
		'class_prefix'             => 'OSMembership',
		'language_prefix'          => 'OSM',
		'remember_states'          => false,
		'ignore_request'           => false,
	];

	//Initialize the controller, execute the task (display) to display the view
	MPFController::getInstance('com_osmembership', $input, $config)
		->execute();
}
