HDP = window.HDP || {};
HDP.jQuery = jQuery.noConflict();
(function (Joomla, $) {
    HDP.showFields = function (form) {

        if (Joomla.getOptions('hasDependency'))
        {
            HDP.showFieldsWithDependencies(form);

            return;
        }

        let i, trId;
        let newCategoryId = form.category_id.value;

        if (newCategoryId === '') {
            newCategoryId = 0;
        }

        const allFields = fields[0];

        if (allFields) {
            for (i = 0; i < allFields.length; i++) {
                if (allFields[i]) {
                    trId = 'field_' + allFields[i];
                    document.getElementById(trId).style.display = '';
                }
            }
        }

        if (currentCategory > 0) {
            const oldFields = fields[currentCategory];
            //Hide the old fields
            if (oldFields) {
                for (i = 0; i < oldFields.length; i++) {
                    if (oldFields[i]) {
                        trId = 'field_' + oldFields[i];
                        document.getElementById(trId).style.display = 'none';
                    }
                }
            }
        }

        const newFields = fields[newCategoryId];

        if (newFields) {
            for (i = 0; i < newFields.length; i++) {
                if (newFields[i]) {
                    trId = 'field_' + newFields[i];
                    document.getElementById(trId).style.display = '';
                }
            }
        }

        currentCategory = newCategoryId;
    };

    HDP.showFieldsWithDependencies = function (form)
    {
        const data = new FormData(form);

        data.delete('task');

        Joomla.request({
            url: Joomla.getOptions('hdpBaseUri') + '/index.php?option=com_helpdeskpro&task=ticket.get_depend_fields_status_for_category',
            method: 'POST',
            data: data,
            onSuccess: function (resp) {
                const response = JSON.parse(resp);

                if (response.show_fields)
                {
                    let showFields = response.show_fields.split(',');

                    for (let i = 0; i < showFields.length; i++) {
                        let field = showFields[i];
                        document.getElementById(field).style.display = '';
                    }
                }

                if (response.hide_fields)
                {
                    let hideFields = response.hide_fields.split(',');

                    for (let i = 0; i < hideFields.length; i++) {
                        let field = hideFields[i];
                        document.getElementById(field).style.display = 'none';
                    }
                }
            },
            onError: function (error) {
                alert(error.statusText);
            }
        });
    }

    HDP.showMessageBox = function () {
        const messageInput = document.getElementById('tr_message_id');

        if (messageInput.style.display === 'none') {
            messageInput.style.display = '';
        } else {
            messageInput.style.display = 'none';
        }
    };

    HDP.changeTicketCategory = function (newCategoryId) {
        const form = document.adminForm;
        form.new_value.value = newCategoryId;
        form.task.value = 'ticket.update_category';
        form.submit();
    };

    HDP.applyTicketLabel = function (labelId) {
        const form = document.adminForm;
        form.new_value.value = labelId;
        form.task.value = 'ticket.apply_label';
        form.submit();
    };

    HDP.changeTicketPriority = function (newPriority) {
        const form = document.adminForm;
        form.new_value.value = newPriority;
        form.task.value = 'ticket.update_priority';
        form.submit();
    };

    HDP.changeTicketStatus = function (newStatus) {
        const form = document.adminForm;
        form.new_value.value = newStatus;
        form.task.value = 'ticket.update_status';
        form.submit();
    };

    HDP.ticketRating = function (rating) {
        const form = document.adminForm;
        form.new_value.value = rating;
        form.task.value = 'ticket.save_rating';
        form.submit();
    };

    HDP.ticketList = function () {
        location.href = Joomla.getOptions('ticketsUrl', 'index.php?option=com_helpdeskpro&view=tickets');
    };

    HDP.updateComment = function (messageId, value) {
        const data = {
            'task': 'ticket.update_comment',
            'message_id': messageId,
            'new_message': value
        };

        Joomla.request({
            url: Joomla.getOptions('hdpBaseUri') + '/index.php?option=com_helpdeskpro&task=ticket.update_comment',
            method: 'POST',
            data: JSON.stringify(data),
            headers: {
                'Content-Type': 'application/json'
            },
            perform: true,
            onError: error => {
                alert(error.statusText);
            }
        });

    };

    HDP.removeComment = function (messageId) {
        Joomla.request({
            url: Joomla.getOptions('hdpBaseUri') + '/index.php?option=com_helpdeskpro&task=ticket.remove_comment&message_id=' + messageId,
            method: 'GET',
            perform: true,
            onError: error => {
                alert(error.statusText);
            }
        });
    };

    HDP.addComment = function (form, task) {
	    const message = (Joomla.getOptions('useHtmlEditor') && Joomla.editors.instances['message'])
		    ? Joomla.editors.instances['message'].getValue()
		    : form.message.value;

        if (message === '') {
            alert(Joomla.JText._('HDP_ENTER_COMMENT_FOR_TICKET'));
            form.message.focus();
            return;
        }

        if (typeof hdpDropzone !== "undefined" && (hdpDropzone.getQueuedFiles().length !== 0 || hdpDropzone.getUploadingFiles().length !== 0)) {
            alert(Joomla.JText._('HDP_PLEASE_WAIT_UNTIL_ALL_FILES_UPLOADED'));
            return;
        }

        form.task.value = task;
        form.submit();
    };

    HDP.showHideDependFields = function (fieldId, fieldName, fieldType) {
        var masterFieldsSelector = '.master-field input[type=\'checkbox\']:checked, .master-field input[type=\'radio\']:checked, .master-field select';
        $.ajax({
            type: 'POST',
            url: Joomla.getOptions('hdpBaseUri') + '/index.php?option=com_helpdeskpro&task=ticket.get_depend_fields_status&field_id=' + fieldId,
            data: $(masterFieldsSelector),
            dataType: 'json',
            success: function (msg, textStatus, xhr) {
                var hideFields = [], showFields = [], i;

                if (msg.hide_fields)
                {
                    hideFields = msg.hide_fields.split(',');
                }

                if (msg.show_fields)
                {
                    showFields = msg.show_fields.split(',');
                }

                for (i = 0; i < hideFields.length; i++) {
                    $('#' + hideFields[i]).hide();
                }

                for (i = 0; i < showFields.length; i++) {
                    $('#' + showFields[i]).show();
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                alert(textStatus);
            }
        });
    };

    HDP.convertToArticle = function (form) {
        form.task.value = 'ticket.convert_to_kb';
        form.submit();
    };
}(Joomla, HDP.jQuery));