/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `ip_address` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20338 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages');
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields');
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int unsigned NOT NULL,
  `notify` tinyint unsigned NOT NULL,
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_users`  VALUES 
('391', '0', '[\"com_content\",\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]');
/**ABDB**/CREATE TABLE `#__acym_automation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `active` tinyint NOT NULL DEFAULT '0',
  `report` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tree` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `admin` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__acym_automation`  VALUES 
('1', 'Send notification on user creation', 'This automation allows you to send a message to the admin when a user is created', '0', NULL, NULL, '1'),
('2', 'Send notification on user modification', 'This automation allows you to send a message to the admin when a user is modified', '0', NULL, NULL, '1');
/**ABDB**/CREATE TABLE `#__acym_step` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `automation_id` int NOT NULL,
  `last_execution` int DEFAULT NULL,
  `next_execution` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_pk40m_acym__step1` (`automation_id`),
  CONSTRAINT `#__fk_acym__step1` FOREIGN KEY (`automation_id`) REFERENCES `#__acym_automation` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__acym_step`  VALUES 
('1', 'ACYM_ADMIN_USER_CREATE', '{\"user_creation\":[\"\"],\"type_trigger\":\"user\"}', '1', NULL, NULL),
('2', 'ACYM_ADMIN_USER_CREATE', '{\"user_modification\":[\"\"],\"type_trigger\":\"user\"}', '2', NULL, NULL);
/**ABDB**/CREATE TABLE `#__acym_condition` (
  `id` int NOT NULL AUTO_INCREMENT,
  `step_id` int NOT NULL,
  `conditions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `fk_pk40m_acym_condition1` (`step_id`),
  CONSTRAINT `#__fk_acym_condition1` FOREIGN KEY (`step_id`) REFERENCES `#__acym_step` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__acym_condition`  VALUES 
('1', '1', '{\"type_condition\":\"user\"}'),
('2', '2', '{\"type_condition\":\"user\"}');
/**ABDB**/CREATE TABLE `#__acym_action` (
  `id` int NOT NULL AUTO_INCREMENT,
  `condition_id` int NOT NULL,
  `actions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `filters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `order` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_pk40m_acym_action1` (`condition_id`),
  CONSTRAINT `#__fk_acym_action1` FOREIGN KEY (`condition_id`) REFERENCES `#__acym_condition` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__acym_action`  VALUES 
('1', '1', '[{\"acy_add_queue\":{\"mail_id\":\"13\",\"time\":\"[time]\"}}]', '{\"0\":{\"1\":{\"acy_field\":{\"field\":\"email\",\"operator\":\"=\",\"value\":\"mike@mikeramo.com\"}}},\"type_filter\":\"classic\"}', '1'),
('2', '2', '[{\"acy_add_queue\":{\"mail_id\":\"14\",\"time\":\"[time]\"}}]', '{\"0\":{\"1\":{\"acy_field\":{\"field\":\"email\",\"operator\":\"=\",\"value\":\"mike@mikeramo.com\"}}},\"type_filter\":\"classic\"}', '1');
/**ABDB**/CREATE TABLE `#__acym_mail` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` datetime NOT NULL,
  `thumbnail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `drag_editor` tinyint(1) DEFAULT NULL,
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_to_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reply_to_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `stylesheet` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `attachments` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `creator_id` int NOT NULL,
  `mail_settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `headers` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `autosave` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `preheader` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `links_language` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `access` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tracking` tinyint(1) NOT NULL DEFAULT '1',
  `language` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent_id` int DEFAULT NULL,
  `translation` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `bounce_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `#__index_acym_mail1` (`parent_id`),
  KEY `#__index_acym_mail2` (`type`),
  CONSTRAINT `#__fk_acym_mail1` FOREIGN KEY (`parent_id`) REFERENCES `#__acym_mail` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__acym_mail`  VALUES 
('40', 'January 2021', '2021-04-22 03:58:59', NULL, '0', 'standard', '<div style=\"text-align: center;\">January 2021 &ndash; Newsletter</div>\r\n\r\n<div>{osp:55|type:intro|link|showprice|bath|bed|square|category|showcreated|pict:1}<br />\r\n{osp:51|type:intro|link|showprice|bath|bed|square|category|showcreated|pict:1}{osp:53|type:intro|link|showprice|bath|bed|address|square|category|showcreated|pict:1}</div>', 'January 2021', '', '', '', '', '', NULL, '', '[]', '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('41', 'Notification template', '2024-11-27 17:36:35', NULL, '0', 'template', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', '', '', '', '', NULL, NULL, 'div,table,p,td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width: 320px !important;}\r\n	.w520 { width: 280px !important;}\r\n	.w480 { width: 260px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	.w600 { width: 480px !important;}\r\n	.w520 { width: 440px !important;}\r\n	.w480 { width: 420px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width: 600px !important;}\r\n	.w520 { width: 520px !important;}\r\n	.w480 { width: 480px !important;}\r\n	.w40 { width: 40px !important;}\r\n	.w20 { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\nh1{color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;}h2{color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;}h3{color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;}h4{color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;}a{color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;}.acymailing_readmore{font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;}.acymailing_online{color:#a3a3a3; text-decoration:none; font-size:11px;}.acymailing_unsub{color:#a3a3a3; text-decoration:none; font-size:11px;}.acymailing_content{text-align:justify;}', NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('42', 'Newspaper', '2024-11-27 17:36:35', NULL, '0', 'template', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>Â» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n	<tbody  class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n			<h1><img alt=\"logo\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n			<h1>Your title here</h1>\r\n\r\n			<h3>your subtitle</h3>\r\n			</td>\r\n			<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n				<div>This issue will present the 5 last articles.<br />\r\n				{tableofcontents}<br />\r\n				{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n			</td>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>Â» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', '', '', '', '', NULL, NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p,td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important; }\r\n	.w540 { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important; }\r\n	.w540 { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important; }\r\n	.w540 { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\nh1{color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;}h2{color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;}h3{color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;}h4{color:#e52323 !important; font-weight:bold; margin:0px; padding:0px}a{cursor:pointer; color:#9d0000; text-decoration:none; border:none;}.acymailing_readmore{cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;}.acymailing_online{color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;}.acymailing_content{}.acymailing_unsub{color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px}', NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('45', 'Notification template ORG', '2024-11-27 17:36:35', NULL, '0', 'template', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don&#39;t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n			<h3>Topic of your message</h3>\r\n\r\n			<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"http://osp.realestate-panama.com//media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', '', '', '', '', NULL, NULL, 'div,table,p,td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width: 320px !important;}\r\n	.w520 { width: 280px !important;}\r\n	.w480 { width: 260px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	.w600 { width: 480px !important;}\r\n	.w520 { width: 440px !important;}\r\n	.w480 { width: 420px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width: 600px !important;}\r\n	.w520 { width: 520px !important;}\r\n	.w480 { width: 480px !important;}\r\n	.w40 { width: 40px !important;}\r\n	.w20 { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\nh1{color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;}h2{color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;}h3{color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;}h4{color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;}a{color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;}.acymailing_unsub{color:#a3a3a3; text-decoration:none; font-size:11px;}.acymailing_content{text-align:justify;}.acymailing_readmore{font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;}.acymailing_online{color:#a3a3a3; text-decoration:none; font-size:11px;}', NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('46', 'acy_report', '2024-11-27 17:36:41', NULL, '1', 'notification', '<p>{report}</p><p>{detailreport}</p>', 'AcyMailing Cron Report {mainreport}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('47', 'acy_confirm', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">{trans:ACYM_HELLO} <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>{trans:ACYM_CONFIRM_MESSAGE}</p>\n                    <p>{trans:ACYM_CONFIRM_MESSAGE_ACTIVATE}</p>\n                    <p style=\"text-align: center;\"><strong>{confirm}{trans:ACYM_CONFIRM_SUBSCRIPTION}{/confirm}</strong></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', '{subscriber:name|ucfirst}, {trans:ACYM_PLEASE_CONFIRM_SUBSCRIPTION}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('48', 'acy_notification_create', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>A new user has been created in AcyMailing:</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Source: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:source}\" data-mce-selected=\"1\">registration_form<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Subscription: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:subscription}\" data-mce-selected=\"1\">Newsletters - 2020-11-02 14:38:24<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'New subscriber on your website: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('49', 'acy_notification_unsub', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>The following user unsubscribed from your list(s):</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Lists: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{lists}\" data-mce-selected=\"1\">Newsletters, Tips<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'A user unsubscribed: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('50', 'acy_notification_unsuball', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>The following user unsubscribed from all your lists:</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'A user unsubscribed from all your lists: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('51', 'acy_notification_subform', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>A user submitted the subscription form:</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Subscription: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:subscription}\" data-mce-selected=\"1\">Newsletters - 2020-11-02 14:38:24<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'New contact from your website: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL);
/**ABDB**/INSERT INTO `#__acym_mail`  VALUES 
('52', 'acy_notification_profile', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>A user changed their profile:</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Subscription: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:subscription}\" data-mce-selected=\"1\">Newsletters - 2020-11-02 14:38:24<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'A user subscribed or modified their subscription: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('53', 'acy_notification_confirm', '2024-11-27 17:36:41', NULL, '1', 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0 120px 0;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218,218,218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0,163,254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: transparent;\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|ucfirst}\" data-mce-selected=\"1\">Marc<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span>,</h1>\n                    <p>The following user confirmed their subscription:</p>\n                    <p>Name: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:name}\" data-mce-selected=\"1\">Julia<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Email: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:email}\" data-mce-selected=\"1\">julia@example.com<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>IP: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:confirmation_ip}\" data-mce-selected=\"1\">127.0.0.1<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p>\n                    <p>Subscription: <span class=\"acym_dynamic mceNonEditable\" contenteditable=\"false\" data-dynamic=\"{user:subscription}\" data-mce-selected=\"1\">Newsletters - 2020-11-02 14:38:24<em class=\"acym_remove_dynamic acymicon-close\">&zwj;</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0; left: 0;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'A user confirmed their subscription: {user:email}', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('54', 'AcyMailing first email', '2024-11-27 17:36:41', 'thumbnail_first_email.png', '1', 'template', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0px 120px;\"><center><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(238, 238, 238);\" bgcolor=\"#eeeeee\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_41\"><p style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center; line-height: inherit;\"><span style=\"font-size: 12px;\">Having trouble seeing this email?&nbsp;<span class=\"mceNonEditable acym_dynamic\" contenteditable=\"false\" data-dynamic=\"{readonline}View it online{/readonline}\"><a style=\"text-decoration: none; font-family: Helvetica; font-size: 12px; font-weight: normal; line-height: inherit; font-style: normal; color: #38c2f3;\" href=\"https://osp.realestate-panama.com/es/component/acym/archive/54-your-first-email?userid=5-qMP74UbpRUQZGP&amp;tmpl=component\" target=\"_blank\" rel=\"noopener\"><span class=\"acym_online\">View it online</span></a><em class=\"acym_remove_dynamic acymicon-close\">ââ</em></span>&nbsp;</span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 21px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_45\"><p style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; line-height: inherit;\"><img class=\"acym__wysid__media__inserted\" style=\"max-width: 100%; height: 85px; box-sizing: border-box; padding: 0px 5px; display: block; margin-left: auto; margin-right: auto; width: 306px;\" src=\"https://osp.realestate-panama.com/media/com_acym/upload/logo_acymailing_step_email.png\" alt=\"logo_acymailing_step_email.png\" height=\"85\" width=\"306\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 29px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element acym__wysid__column__element__separator cursor-pointer ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><hr style=\"border-bottom: 3px solid rgb(214, 214, 214); width: 24%; border-top: none; border-left: none; border-right: none; size: 3px;\" class=\"acym__wysid__row__separator\"></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_42\"><h1 style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: #000000; line-height: inherit; text-align: left;\">Dear&nbsp;<span class=\"mceNonEditable acym_dynamic\" contenteditable=\"false\" data-dynamic=\"{subscriber:name|part:first|ucfirst}\">Admin<em class=\"acym_remove_dynamic acymicon-close\">ââ</em></span>,</h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_43\"><p style=\"word-break: break-word; font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; line-height: inherit; text-align: left;\"><span style=\"color: #000000;\"><span style=\"font-family: Helvetica;\">Feel free to drag &amp; drop some content and&nbsp;</span><span style=\"font-family: Helvetica;\">try the AcyMailing editor.</span></span></p><p style=\"word-break: break-word; font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; line-height: inherit; text-align: left;\"><span style=\"color: #000000; font-family: Helvetica;\">Once it is done, click on the \"Apply\" button.</span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_46\"><p style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; line-height: inherit;\"><img class=\"acym__wysid__media__inserted\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: block; margin-left: auto; margin-right: auto; width: 580px;\" src=\"https://osp.realestate-panama.com/media/com_acym/upload/image_mailing_step_email.jpg\" alt=\"image_mailing_step_email.jpg\" height=\"400.68\" width=\"580\"></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#303e47\" style=\"background-color: rgb(48, 62, 71); z-index: 100;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\" id=\"mce_44\"><p style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; text-align: center; word-break: break-word; line-height: inherit;\"><span style=\"color: #ffffff;\">If you\'re not interested anymore, you can</span> <span class=\"mceNonEditable acym_dynamic\" data-dynamic=\"{unsubscribe}unsubscribe{/unsubscribe}\" contenteditable=\"false\"><a style=\"text-decoration: none; font-family: Helvetica; font-size: 12px; font-weight: normal; line-height: inherit; font-style: normal; color: #38c2f3;\" target=\"_blank\" href=\"https://osp.realestate-panama.com/es/component/acym/frontusers/unsubscribe?id=5&amp;key=qMP74UbpRUQZGP&amp;tmpl=component\" rel=\"noopener\"><span class=\"acym_unsubscribe acym_link\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; line-height: inherit; font-style: normal; color: #ffffff;\">unsubscribe</span></a><em class=\"acym_remove_dynamic acymicon-close\">â</em></span></p></div></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', 'Your first email', NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true,\"line-height\":true},\"line-height\":\"inherit\"},\"a\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true,\"line-height\":true,\"color\":true},\"line-height\":\"inherit\",\"color\":\"#38c2f3\"},\"span.acym_link\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true,\"line-height\":true,\"color\":true},\"line-height\":\"inherit\",\"color\":\"#ffffff\"},\"h1\":{\"font-family\":\"Helvetica\",\"font-size\":\"20px\",\"overridden\":{\"font-size\":true,\"line-height\":true},\"line-height\":\"inherit\"}}', NULL, NULL, '391', NULL, NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('55', 'Car', '2024-11-27 17:36:41', 'thumbnail_8.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\">\r\n	<table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0 120px 0;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; padding-right: 0px; padding-top: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element6266210\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_0\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(92, 199, 203); font-size: 16px;\" data-mce-style=\"color: #5cc7cb; font-size: 16px;\">INTRODUCING</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_10\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 36px;\" data-mce-style=\"color: #ffffff; font-size: 36px;\">VERSION <strong>2.0</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_11\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">consectetur </span></span><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit.</span></span></p><p style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\"><br></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 29px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 131px; height:58px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgb(92, 199, 203)\" strokeweight=\"0\" fillcolor=\"rgb(92, 199, 203)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">CHECK IT OUT </center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(92, 199, 203); color: white; padding: 23px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px;\" href=\"#\">CHECK IT OUT </a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_23\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_header_template.jpg\" title=\"car header template\" alt=\"car header template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_header_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"405.859\" width=\"280\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element3267464\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_26\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template1.jpg\" title=\"car template1\" alt=\"car template1\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template1.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"186.656\" width=\"280\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_12\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(92, 199, 203); font-size: 28px;\" data-mce-style=\"color: #5cc7cb; font-size: 28px;\">Automatic</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_13\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit, sed do eiusmod tempor</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\"> incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</span></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_27\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template2.jpg\" title=\"car template2\" alt=\"car template2\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template2.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"186.656\" width=\"280\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_14\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(92, 199, 203); font-size: 28px;\" data-mce-style=\"color: #5cc7cb; font-size: 28px;\">Faster</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_15\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit, sed do eiusmod tempor</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">incididunt ut labore et dolore magna aliqua.</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Ut enim ad minim veniam.</span></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element6191882\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_28\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/wheel_template.jpg\" title=\"wheel template\" alt=\"wheel template\" style=\"max-width: 100%; height: 209px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/wheel_template.jpg\" data-mce-style=\"max-width: 100%; height: 209px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"209\" width=\"280\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_16\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(92, 199, 203); font-size: 28px;\" data-mce-style=\"color: #5cc7cb; font-size: 28px;\">New design</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_17\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit, sed do eiusmod tempor</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\"> incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</span></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_29\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Engine_template.jpg\" title=\"engine template\" alt=\"engine template\" style=\"max-width: 100%; height: 209px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Engine_template.jpg\" data-mce-style=\"max-width: 100%; height: 209px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"209\" width=\"280\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_18\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-weight: normal; font-style: normal; text-align: center; font-size: 34px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span data-mce-style=\"color: #5cc7cb;\" style=\"color: #5cc7cb;\"><span style=\"caret-color: #5cc7cb; font-size: 28px;\" data-mce-style=\"caret-color: #5cc7cb; font-size: 28px;\">Powerful</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_19\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit, sed do eiusmod tempor</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">incididunt ut labore et dolore magna aliqua.</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Ut enim ad minim veniam.</span></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 132px; height:58px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgba(92, 199, 203, 0.89)\" strokeweight=\"0\" fillcolor=\"rgba(92, 199, 203, 0.89)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:700;\">CHECK IT OUT </center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgba(92, 199, 203, 0.89); color: rgb(255, 255, 255); padding: 23px; max-width: 100%; overflow: unset; border: 0px solid rgb(92, 199, 203); text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px; font-weight: 700;\" href=\"#\">CHECK IT OUT </a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element acym__wysid__column__element__separator cursor-pointer ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><hr style=\"border-bottom-width: 1px; border-style: none none solid; border-bottom-color: rgb(92, 199, 203); width: 75%;\" class=\"acym__wysid__row__separator\"></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_20\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(92, 199, 203); font-size: 28px;\" data-mce-style=\"color: #5cc7cb; font-size: 28px;\">Discover our new technology</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_21\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></span><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">adipiscing elit, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 14px;\" data-mce-style=\"color: #ffffff; font-size: 14px;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify;\">sed do eiusmod tempo<span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">r&nbsp;</span></span></span><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; text-align: justify; font-size: 14px; background-color: inherit; color: rgb(255, 255, 255);\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; text-align: justify; font-size: 14px; background-color: inherit; color: #ffffff;\">incididunt ut labore et dolore magna aliqua.&nbsp;</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; padding-right: 0px; padding-left: 0px; padding-bottom: 10px;\" cellpadding=\"0\" id=\"acym__wysid__row__element8268635\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-5\" valign=\"top\" style=\"height: auto; background-color: rgba(0, 0, 0, 0); background-position: initial initial; background-repeat: initial initial;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_30\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/wheel_template.jpg\" title=\"wheel template\" alt=\"wheel template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 238.828px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/wheel_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"177.453\" width=\"238.828\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_31\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template2.jpg\" title=\"car template2\" alt=\"car template2\" style=\"max-width: 100%; height: 162px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 238.828px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template2.jpg\" data-mce-style=\"max-width: 100%; height: 162px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"162\" width=\"238.828\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_32\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template_3.jpg\" title=\"car template 3\" alt=\"car template 3\" style=\"max-width: 100%; height: 174px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 238.828px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template_3.jpg\" data-mce-style=\"max-width: 100%; height: 174px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"174\" width=\"238.828\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-7\" valign=\"top\" style=\"height: auto; background-color: rgba(0, 0, 0, 0); background-position: initial initial; background-repeat: initial initial;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_33\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template_4.jpg\" title=\"car template 4\" alt=\"car template 4\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 341px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/car/images/Car_template_4.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"511.5\" width=\"341\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 159px; height:64px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgb(92, 199, 203)\" strokeweight=\"0\" fillcolor=\"rgb(92, 199, 203)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:14px; font-weight:400;\">CHECK IT OUT </center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style acym__wysid__column__element__button--focus\" style=\"background-color: rgb(92, 199, 203); color: white; padding: 25px 30px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px;\" href=\"#\">CHECK IT OUT </a><!-- <![endif]--></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#5cc7cb\" style=\"z-index: 100; background-color: rgb(92, 199, 203); padding-right: 10px; padding-left: 10px;\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_22\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"font-size: 14px;\" data-mce-style=\"font-size: 14px;\"><strong><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â12 Avenue Victor Hugo</span></strong></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 12px;\" data-mce-style=\"color: #ffffff; font-size: 12px;\"><span style=\"font-size: 14px;\" data-mce-style=\"font-size: 14px;\">LYON, FRANCE</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-size: 12px;\" data-mce-style=\"color: #ffffff; font-size: 12px;\">www.example.com</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th>\r\n												</tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '', NULL, '391', '{\"media_folder\":\"car\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('56', 'Company', '2024-11-27 17:36:41', 'thumbnail_9.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\">\r\n	<table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0 120px 0;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" bgcolor=\"transparent\" style=\"background-image: url(&quot;https://osp.realestate-panama.com/media/com_acym/templates/company/images/work_head.jpg&quot;); background-size: cover; padding: 10px 0px; z-index: 100; background-color: transparent; border-collapse: initial; background-position: center center; background-repeat: no-repeat no-repeat;\" cellpadding=\"0\" id=\"acym__wysid__row__element9461432\" width=\"580\"><!--[if gte mso 9]><v:rect xmlns:v=\"urn:schemas-microsoft-com:vml\" fill=\"true\" stroke=\"false\" style=\"width: 580px;height: 300px\"><v:fill type=\"frame\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/work_head.jpg\" /><v:textbox inset=\"0,0,0,0\"><![endif]--><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-3 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-2\" valign=\"top\" style=\"height: auto;\" height=\"211.8125\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 38px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th><th class=\"small-12 medium-3 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-4\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 100px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 81px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_0\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: left;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: left;\"><span style=\"font-size: 36px; color: rgb(255, 255, 255);\" data-mce-style=\"font-size: 36px; color: #ffffff;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âCompany</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_10\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\"><span style=\"color: rgb(255, 255, 255); font-size: 22px;\" data-mce-style=\"color: #ffffff; font-size: 22px;\">âLet\'s work together!</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 35px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th><th class=\"small-12 medium-3 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2 large-4\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 62px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 100px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 129px; height:42px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgba(61, 136, 134, 0.9)\" strokeweight=\"0\" fillcolor=\"rgba(61, 136, 134, 0.9)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:700;\">LEARN MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgba(61, 136, 134, 0.9); color: rgb(255, 255, 255); padding: 15px 24px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px; width: auto; font-weight: 700;\" href=\"#\">LEARN MORE</a><!-- <![endif]--></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 13px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th><th class=\"small-12 medium-3 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-3 large-2\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 46px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody><!--[if gte mso 9]></v:textbox></v:rect><![endif]--></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#3d8886\" style=\"background-color: rgb(61, 136, 134); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_11\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px; color: rgb(0, 128, 128);\" data-mce-style=\"font-size: 20px; color: #008080;\">âWho are we?</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_12\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor </span><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">incididunt ut labore et dolore magna aliqua.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_30\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_1.png\" title=\"icon 1\" alt=\"icon 1\" style=\"max-width: 100%; height: 121px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 115px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_1.png\" data-mce-style=\"max-width: 100%; height: 121px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"121\" width=\"115\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_13\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 18px; color: rgb(0, 128, 128);\" data-mce-style=\"font-size: 18px; color: #008080;\">Lorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_14\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</span><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_33\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_2.png\" title=\"icon 2\" alt=\"icon 2\" style=\"max-width: 100%; height: 120px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 114px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_2.png\" data-mce-style=\"max-width: 100%; height: 120px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"120\" width=\"114\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_15\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 18px; color: rgb(0, 128, 128);\" data-mce-style=\"font-size: 18px; color: #008080;\">Lorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_16\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</span><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_34\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_3.png\" title=\"icon 3\" alt=\"icon 3\" style=\"max-width: 100%; height: 119px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 113px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Icon_3.png\" data-mce-style=\"max-width: 100%; height: 119px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"119\" width=\"113\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_17\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 18px; color: rgb(0, 128, 128);\" data-mce-style=\"font-size: 18px; color: #008080;\">Lorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_18\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</span><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element5337174\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto; background-color: rgb(255, 255, 255); background-position: initial initial; background-repeat: initial initial;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_35\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Office.jpg\" title=\"office\" alt=\"office\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Office.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"186.656\" width=\"280\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_36\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_work.jpg\" title=\"team work\" alt=\"team work\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_work.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"209.922\" width=\"280\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto; background-color: rgb(61, 136, 134); background-position: initial initial; background-repeat: initial initial;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_19\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 18px; color: rgb(255, 255, 255);\" data-mce-style=\"font-size: 18px; color: #ffffff;\">Lorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 33px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_20\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">adipiscing elit, </span><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">incididunt ut labore et dolore magna aliqua.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\"> Ut enim ad minim veniam, quis nostrud</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\"> exercitation ullamco laboris nisi ut aliquip </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">ex ea commodo consequat. &nbsp;</span><br></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 122px; height:46px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgb(61, 136, 134)\" strokeweight=\"3px\" fillcolor=\"rgb(255, 255, 255)\"><w:anchorlock/><center style=\"color :rgb(61, 136, 134); font-family:Arial; font-size:10px; font-weight:700;\">LEARN MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(255, 255, 255); color: rgb(61, 136, 134); padding: 15px 24px; max-width: 100%; overflow: unset; border: 3px solid rgb(61, 136, 134); text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 10px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px; width: auto; font-weight: 700;\" href=\"#\">LEARN MORE</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_21\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px; color: rgb(0, 128, 128);\" data-mce-style=\"font-size: 20px; color: #008080;\">âOUR TEAM</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_22\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor </span><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">incididunt ut labore et dolore magna aliqua.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr><tr class=\"acym__wysid__column__element acym__wysid__column__element__separator cursor-pointer ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><hr style=\"border-bottom-width: 1px; border-style: none none solid; border-bottom-color: rgb(61, 136, 134); width: 100%;\" class=\"acym__wysid__row__separator\"></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; border-top-left-radius: 0px; border-top-right-radius: 0px; border-bottom-right-radius: 0px; border-bottom-left-radius: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element522985\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_37\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" title=\"team company\" alt=\"team company\" style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" data-mce-style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 187px;\" height=\"313\" width=\"186.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_23\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-weight: normal; font-style: normal; text-align: center; font-size: 34px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span data-mce-style=\"color: #008080; font-size: 16px;\" style=\"color: rgb(0, 128, 128); font-size: 16px;\"><span style=\"caret-color: rgb(0, 128, 128);\" data-mce-style=\"caret-color: #008080;\">John Miller</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_24\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_38\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" title=\"team company\" alt=\"team company\" style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" data-mce-style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 188px;\" height=\"313\" width=\"186.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_25\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: center; font-size: 34px; font-weight: normal; font-style: normal;\"><span data-mce-style=\"color: #008080; font-size: 16px;\" style=\"color: rgb(0, 128, 128); font-size: 16px;\"><span data-mce-style=\"caret-color: #008080;\">John Miller</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_26\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_39\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" title=\"team company\" alt=\"team company\" style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.688px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/Team_company.jpg\" data-mce-style=\"max-width: 100%; height: 313px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 188px;\" height=\"313\" width=\"186.688\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_27\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: center; font-size: 34px; font-weight: normal; font-style: normal;\"><span data-mce-style=\"color: #008080; font-size: 16px;\" style=\"color: rgb(0, 128, 128); font-size: 16px;\"><span data-mce-style=\"caret-color: #008080;\">John Miller</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_28\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 12px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 12px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 129px; height:42px;v-text-anchor:middle;\" href=\"#\" arcsize=\"20%\" strokecolor=\"rgba(61, 136, 134, 0.9)\" strokeweight=\"0\" fillcolor=\"rgba(61, 136, 134, 0.9)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:700;\">LEARN MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgba(61, 136, 134, 0.9); color: rgb(255, 255, 255); padding: 15px 24px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 10px; border-top-right-radius: 10px; border-bottom-right-radius: 10px; border-bottom-left-radius: 10px; width: auto; font-weight: 700;\" href=\"#\">LEARN MORE</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#3d8886\" style=\"background-color: rgb(61, 136, 134); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 35px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;\"><p class=\"acym__wysid__column__element__follow acym__wysid__column__element__follow--focus\" style=\"text-align: center; cursor: pointer; padding: 0px; margin: 0px; font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\"><a class=\"acym__wysid__column__element__follow__linkedin\" href=\"https://www.example.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 40px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/linkedin.png\" width=\"34\" alt=\"linkedin\" height=\"34\"></a><a class=\"acym__wysid__column__element__follow__wordpress\" href=\"https://www.example.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 40px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/company/images/wordpress.png\" width=\"34\" alt=\"wordpress\" height=\"34\"></a></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_29\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"text-decoration: underline;\" data-mce-style=\"text-decoration: underline;\">âContact us</span>&nbsp;</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 35px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '', NULL, '391', '{\"media_folder\":\"company\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('57', 'Event', '2024-11-27 17:36:41', 'thumbnail_10.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\">\r\n	<table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0 120px 0;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_0\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><strong>âSAVE THE DATE&nbsp;</strong></span></h1></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding-top: 0px; padding-right: 0px; padding-left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_18\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template.jpg\" title=\"event template\" alt=\"event template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 580px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"386.656\" width=\"580\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_10\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" data-mce-style=\"color: #000000; font-family: Helvetica; text-align: center;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: center; font-size: 34px; font-weight: normal; font-style: normal;\"><span style=\"line-height: inherit; font-weight: 700 !important;\" data-mce-style=\"line-height: inherit; font-weight: 700 !important;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_11\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"text-align: center; font-weight: normal; font-style: normal; word-break: break-word; font-family: Helvetica; font-size: 12px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span data-mce-style=\"text-align: justify; background-color: inherit; caret-color: #000000;\" style=\"text-align: justify; background-color: inherit; caret-color: rgb(0, 0, 0);\"><span data-mce-style=\"color: #000000; font-family: Helvetica;\" style=\"color: #000000; font-family: Helvetica;\">4 p.m - 5 p.m </span></span></strong></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"text-align: center; font-weight: normal; font-style: normal; word-break: break-word; font-family: Helvetica; font-size: 12px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"text-align: justify; background-color: inherit; caret-color: rgb(0, 0, 0); font-size: 12px;\"><span data-mce-style=\"color: #000000; font-family: Helvetica;\" style=\"color: #000000; font-family: Helvetica;\">&nbsp;</span></span><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; caret-color: rgb(128, 128, 128); text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet.</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"text-align: center; font-weight: normal; font-style: normal; word-break: break-word; font-family: Helvetica; font-size: 12px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"text-align: center; font-weight: normal; font-style: normal; word-break: break-word; font-family: Helvetica; font-size: 12px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"text-align: center; font-weight: normal; font-style: normal; word-break: break-word; font-family: Helvetica; font-size: 12px; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; caret-color: rgb(128, 128, 128); text-align: justify; background-color: inherit;\"><span style=\"line-height: inherit; caret-color: #000000; color: #000000; font-family: Helvetica; font-size: 16px; text-align: center; font-weight: 700 !important;\" data-mce-style=\"line-height: inherit; caret-color: #000000; color: #000000; font-family: Helvetica; font-size: 16px; text-align: center; font-weight: 700 !important;\"><span data-mce-style=\"text-align: justify; background-color: inherit; caret-color: #000000;\" style=\"text-align: justify; background-color: inherit;\"><span data-mce-style=\"color: #000000; font-family: Helvetica;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica;\">6 p.m - 7 p.m</span></span></span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: justify; background-color: inherit;\">&nbsp;</span><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; caret-color: rgb(128, 128, 128); text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet.</span><br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; caret-color: rgb(128, 128, 128); font-size: 14px; text-align: justify; background-color: inherit;\"><span style=\"line-height: inherit; caret-color: #000000; color: #000000; font-family: Helvetica; font-size: 16px; text-align: center; font-weight: 700 !important;\" data-mce-style=\"line-height: inherit; caret-color: #000000; color: #000000; font-family: Helvetica; font-size: 16px; text-align: center; font-weight: 700 !important;\"><span data-mce-style=\"text-align: justify; background-color: inherit; caret-color: #000000;\" style=\"text-align: justify; background-color: inherit;\"><span data-mce-style=\"color: #000000; font-family: Helvetica;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica;\">7 p.m - 2 a.m</span></span></span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: justify; background-color: inherit;\">&nbsp;</span><span data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; caret-color: rgb(128, 128, 128); text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet.</span><br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p></div></td></tr></tbody></table></th>\r\n												</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding-left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element9573598\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-7\" valign=\"top\" style=\"height: auto; padding-right: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_21\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template1.jpg\" title=\"event template1\" alt=\"event template1\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 325px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template1.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"216.656\" width=\"325\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-5\" valign=\"top\" style=\"height: auto; padding-left: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_12\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"font-size: 32px;\" data-mce-style=\"font-size: 32px;\"><strong>âLorem ipsum</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_13\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding-left: 10px; padding-right: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element6826285\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-5\" valign=\"top\" style=\"height: auto; padding-right: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_14\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"font-size: 32px;\" data-mce-style=\"font-size: 32px;\">â<span style=\"font-weight: bold; background-color: inherit;\" data-mce-style=\"font-weight: bold; background-color: inherit;\">âLorem ipsum</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_15\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\"><span style=\"caret-color: #808080; color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"caret-color: #808080; color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-7\" valign=\"top\" style=\"height: auto; padding-left: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_22\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template2.jpg\" title=\"event template2\" alt=\"event template2\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 325px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template2.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"215.328\" width=\"325\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px; padding-left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element4767681\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-7\" valign=\"top\" style=\"height: auto; padding-right: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_23\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template3.jpg\" title=\"event template3\" alt=\"event template3\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 325px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/event/images/Event_template3.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"216.656\" width=\"325\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-5\" valign=\"top\" style=\"height: auto; padding-left: 10px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_16\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"font-size: 32px;\" data-mce-style=\"font-size: 32px;\"><strong>âLorem ipsum</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_17\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\"><span style=\"caret-color: #808080; color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"caret-color: #808080; color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 232px; height:64px;v-text-anchor:middle;\" href=\"#\" arcsize=\"0%\" strokecolor=\"rgb(0, 0, 0)\" strokeweight=\"0\" fillcolor=\"rgb(0, 0, 0)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:14px; font-weight:400;\">BOOK MY TICKETS</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style acym__wysid__column__element__button--focus\" style=\"background-color: rgb(0, 0, 0); color: white; padding: 25px 52px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 1; border-top-left-radius: 0px; border-top-right-radius: 0px; border-bottom-right-radius: 0px; border-bottom-left-radius: 0px;\" href=\"#\">BOOK MY TICKETS</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\" style=\"background-color: rgb(0, 0, 0); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 60px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"default\":{\"font-family\":\"Helvetica\"},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '', NULL, '391', '{\"media_folder\":\"event\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL);/**ABDB**/
/**ABDB**/INSERT INTO `#__acym_mail`  VALUES 
('58', 'Food', '2024-11-27 17:36:41', 'thumbnail_11.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0 120px 0;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(255, 255, 255); padding: 0px;\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_21\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/header_food_template.jpg\" title=\"header food template\" alt=\"header food template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 580px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/header_food_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"386.656\" width=\"580\"></div></div></td></tr></tbody></table></th>\r\n												</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#2c2e31\" style=\"background-color: rgb(44, 46, 49); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_0\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 22px; color: rgb(153, 204, 255);\" data-mce-style=\"font-size: 22px; color: #99ccff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_10\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 124px; height:52px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(132, 205, 248)\" strokeweight=\"0\" fillcolor=\"rgb(132, 205, 248)\"><w:anchorlock/><center style=\"color :rgb(44, 46, 49); font-family:Arial; font-size:12px; font-weight:700;\">SEE MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(132, 205, 248); color: rgb(44, 46, 49); padding: 20px 30px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px; font-weight: 700;\" href=\"#\">SEE MORE</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#2c2e31\" style=\"background-color: rgb(44, 46, 49); z-index: 100;\" cellpadding=\"0\" id=\"acym__wysid__row__element3528521\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_24\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_foodservices.png\" title=\"icon foodservices\" alt=\"icon foodservices\" style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 64px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_foodservices.png\" data-mce-style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"71\" width=\"64\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_11\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 22px; color: rgb(153, 204, 255);\" data-mce-style=\"font-size: 22px; color: #99ccff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_12\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor</span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">.&nbsp;</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_25\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_delivery.png\" title=\"icon delivery\" alt=\"icon delivery\" style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 69px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_delivery.png\" data-mce-style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"71\" width=\"69\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_13\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 22px; color: rgb(153, 204, 255);\" data-mce-style=\"font-size: 22px; color: #99ccff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_14\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor</span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">.&nbsp;</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_26\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_opening.png\" title=\"icon opening\" alt=\"icon opening\" style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 60px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/icon_opening.png\" data-mce-style=\"max-width: 100%; height: 71px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"71\" width=\"60\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_15\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 22px; color: rgb(153, 204, 255);\" data-mce-style=\"font-size: 22px; color: #99ccff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_16\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor</span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">.&nbsp;</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#2c2e31\" style=\"background-color: rgb(44, 46, 49); z-index: 100;\" cellpadding=\"0\" id=\"acym__wysid__row__element2878709\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_27\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template1.jpg\" title=\"food template1\" alt=\"food template1\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 280px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template1.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"397.047\" width=\"280\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_28\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template2.jpg\" title=\"food template2\" alt=\"food template2\" style=\"max-width: 100%; height: 393px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 262px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template2.jpg\" data-mce-style=\"max-width: 100%; height: 393px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"393\" width=\"262\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#2c2e31\" style=\"background-color: rgb(44, 46, 49); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_17\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 22px; color: rgb(153, 204, 255);\" data-mce-style=\"font-size: 22px; color: #99ccff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_18\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Ut enim ad minim veniam, quis nostrud exercitation ullamco </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">laboris nisi ut aliquip ex ea commodo consequat.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_29\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template3.jpg\" title=\"food template3\" alt=\"food template3\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 560px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/food/images/food_template3.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"373.328\" width=\"560\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_19\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#2c2e31\" style=\"background-color: rgb(44, 46, 49); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 124px; height:52px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(132, 205, 248)\" strokeweight=\"0\" fillcolor=\"rgb(132, 205, 248)\"><w:anchorlock/><center style=\"color :rgb(44, 46, 49); font-family:Arial; font-size:12px; font-weight:700;\">SEE MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style acym__wysid__column__element__button--focus\" style=\"background-color: rgb(132, 205, 248); color: rgb(44, 46, 49); padding: 20px 30px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px; font-weight: 700; font-style: inherit;\" href=\"#\">SEE MORE</a><!-- <![endif]--></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#84cdf8\" style=\"background-color: rgb(132, 205, 248); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_20\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"text-decoration: underline; font-size: 14px;\" data-mce-style=\"text-decoration: underline; font-size: 14px;\">âContact us</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '', NULL, '391', '{\"media_folder\":\"food\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('59', 'Shop', '2024-11-27 17:36:41', 'thumbnail_12.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0 120px 0;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(255, 255, 255);\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_36\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-family: georgia, palatino, serif; font-size: 36px; color: rgb(51, 102, 102);\" data-mce-style=\"font-family: georgia, palatino, serif; font-size: 36px; color: #336666;\">- New arrival -</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_37\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #999999; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Ut enim ad minim veniam, quis nostrud exercitation ullamco </span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th>\r\n												</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#336666\" style=\"background-color: rgb(51, 102, 102); z-index: 100; padding: 0px 5px 0px 0px; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element8632037\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0 large-5\" valign=\"top\" style=\"height: auto; padding-right: 2px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_54\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product-2.jpg\" title=\"product 2\" alt=\"product 2\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 234.766px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product-2.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"352.141\" width=\"234.766\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1 large-7\" valign=\"top\" style=\"height: auto; padding-left: 2px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_38\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 24px; color: rgb(255, 255, 255);\" data-mce-style=\"font-size: 24px; color: #ffffff;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">NEW PRODUCT</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_39\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">consectetur adipiscing elit, </span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">eiusmod tempor incididunt ut labore </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">et dolore magna aliqua. </span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Ut enim ad </span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">minim veniam, quis nostrud </span></span><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">exercitation</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\"> ullamco laboris nisi ut aliquip.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 46px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 107px; height:34px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(255, 255, 255)\" strokeweight=\"0\" fillcolor=\"rgb(255, 255, 255)\"><w:anchorlock/><center style=\"color :rgb(51, 102, 102); font-family:Arial; font-size:10px; font-weight:700;\">SEE MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(255, 255, 255); color: rgb(51, 102, 102); padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid rgb(255, 255, 255); text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 10px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px; font-weight: 700;\" href=\"#\">SEE MORE</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\" id=\"acym__wysid__row__element7826668\"><style data-vertical-padding=\"acym__wysid__row__element7826668\">\r\n                                            @media screen and (max-width: 480px){\r\n                                                #acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-0{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-top: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-2{padding-top: 0px !important}\r\n                                            }\r\n                                         </style><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto; padding-right: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_55\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 183.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"122.422\" width=\"183.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_40\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #1</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_41\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto; padding-left: 3px; padding-right: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_56\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 180.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"120.422\" width=\"180.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_42\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #2</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_43\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2\" valign=\"top\" style=\"height: auto; padding-left: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_57\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 183.688px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"122.453\" width=\"183.688\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_44\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #2</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_45\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 10px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\" id=\"acym__wysid__row__element6214595\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto; padding-right: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_58\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 183.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"122.422\" width=\"183.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_46\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #4</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_47\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto; padding-left: 3px; padding-right: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_59\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 180.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"120.422\" width=\"180.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_48\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #5</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_49\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2\" valign=\"top\" style=\"height: auto; padding-left: 3px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_60\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" title=\"product\" alt=\"product\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 183.688px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/Product.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"122.453\" width=\"183.688\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_50\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 16px;\" data-mce-style=\"font-size: 16px;\"><strong><span style=\"font-family: helvetica, arial, sans-serif;\" data-mce-style=\"font-family: helvetica, arial, sans-serif;\">âItem #6</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_51\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 121px; height:36px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(51, 102, 102)\" strokeweight=\"0\" fillcolor=\"rgb(51, 102, 102)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:12px; font-weight:400;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgb(51, 102, 102); color: white; padding: 12px 27px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#336666\" style=\"background-color: rgb(51, 102, 102); z-index: 100; border-color: rgb(51, 102, 102);\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_52\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\">â â</p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_53\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"text-decoration: underline; font-size: 14px;\" data-mce-style=\"text-decoration: underline; font-size: 14px;\"><span style=\"color: rgb(255, 255, 255); text-decoration: underline;\" data-mce-style=\"color: #ffffff; text-decoration: underline;\">âContact us&nbsp;</span></span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 32px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;\"><p class=\"acym__wysid__column__element__follow acym__wysid__column__element__follow--focus\" style=\"text-align: center; cursor: pointer; padding: 0px; margin: 0px; font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\"><a class=\"acym__wysid__column__element__follow__linkedin\" href=\"https://www.example.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 40px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/linkedin.png\" width=\"34\" alt=\"linkedin\" height=\"34\"></a><a class=\"acym__wysid__column__element__follow__pinterest\" href=\"https://www.example.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 40px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/pinterest.png\" width=\"34\" alt=\"pinterest\" height=\"34\"></a><a class=\"acym__wysid__column__element__follow__vimeo\" href=\"https://www.example.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 40px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/shop/images/vimeo.png\" width=\"34\" alt=\"vimeo\" height=\"34\"></a></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '\r\n                                            @media screen and (max-width: 480px){\r\n                                                #acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-0{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-top: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-2{padding-top: 0px !important}\r\n                                            }\r\n                                         \n@media screen and (max-width: 480px){\r\n                                                #acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-0{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-top: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-1{padding-bottom: 0px !important}#acym__wysid__row__element7826668 .acym__wysid__row__element__th__vertical__padding-2{padding-top: 0px !important}\r\n                                            }', NULL, '391', '{\"media_folder\":\"shop\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('60', 'Special deals', '2024-11-27 17:36:41', 'thumbnail_13.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td class=\"center acym__wysid__template__content\" style=\"background-color: rgb(239, 239, 239); padding: 0px;\" valign=\"top\" align=\"center\">\r\n						<center>\r\n							<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"background-color: rgb(255, 255, 255); min-height: 0px; display: table-cell;\" bgcolor=\"#ffffff\">\r\n											<table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_53\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted acym__wysid__media__inserted--selected\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Special-week-deals.png\" title=\"Special-week-deals\" alt=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 580px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Special-week-deals.png\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"216.75\" width=\"580\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" bgcolor=\"#ffffff\"><tbody style=\"background-color: inherit;\" bgcolor=\"\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" style=\"height: auto;\" valign=\"top\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_39\" contenteditable=\"false\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center; font-family: Helvetica; font-size: 34px;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px;\" data-mce-style=\"font-size: 20px;\"><strong>BEST DEALS UNDER 30â¬</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_40\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Arial; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<span style=\"color: #000000; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #000000; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, </span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Arial; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: #000000; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #000000; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" id=\"mce_45\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Red-shoe.jpg\" title=\"Red-shoe\" alt=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 580px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Red-shoe.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"386.656\" width=\"580\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"acym__wysid__row__element7334710\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" id=\"mce_46\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Black-shoe.jpg\" title=\"Black-shoe\" alt=\"\" style=\"max-width: 100%; height: 434px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 290px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Black-shoe.jpg\" data-mce-style=\"max-width: 100%; height: 434px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"434\" width=\"290\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" id=\"mce_47\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Yellow-shoe.jpg\" title=\"Yellow-shoe\" alt=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 290px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Yellow-shoe.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"434.828\" width=\"290\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" style=\"z-index: 100; background-color: rgb(255, 255, 255); padding: 0px;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody style=\"background-color: inherit;\" bgcolor=\"\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n    <table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 172px; height:66px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(255, 255, 255)\" strokeweight=\"1px\" fillcolor=\"rgb(17, 13, 10)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:14px; font-weight:700;\">SHOP NOW</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style acym__wysid__column__element__button--focus\" style=\"background-color: rgb(17, 13, 10); color: white; padding: 25px 46px; max-width: 100%; overflow: unset; border: 1px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-all; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px; font-weight: 700;\" href=\"#\">SHOP NOW</a><!-- <![endif]--></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\">\r\n            <div style=\"text-align: center;\">\r\n              <p class=\"acym__wysid__column__element__follow acym__wysid__column__element__follow--focus\" style=\"text-align: center; cursor: pointer; padding: 0px; margin: 0px; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\">\r\n                <a class=\"acym__wysid__column__element__follow__twitter\" href=\"https://twitter.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 30px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/twitter.png\" alt=\"\" width=\"24\" height=\"24\"></a><a class=\"acym__wysid__column__element__follow__facebook\" href=\"https://www.facebook.com/\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 241);\"><img style=\"display: inline-block; max-width: 100%; height: auto; box-sizing: border-box; width: 30px; padding: 3px;\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/facebook.png\" alt=\"\" width=\"24\" height=\"24\"></a></p>\r\n            </div>\r\n          </td>\r\n        </tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\">\r\n            <div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\" id=\"mce_41\" contenteditable=\"false\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"font-size: 10px;\" data-mce-style=\"font-size: 10px;\">ââââAll rights reserved, 2021, Company.</span></p></div></td>\r\n        </tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" id=\"mce_48\" contenteditable=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word;\" data-mce-style=\"font-family: Arial; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word;\">&nbsp;<br></p></div></td></tr></tbody></table></th>\r\n</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; padding: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_51\" style=\"position: relative;\" spellcheck=\"false\" contenteditable=\"false\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Bas-New-Year-03-1.png\" title=\"Bas-New-Year-03-1\" alt=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 580px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/special_deals/images/Bas-New-Year-03-1.png\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"31.1406\" width=\"580\"></div></div></td></tr></tbody></table></th></tr></tbody></table></td>\r\n									</tr></tbody></table></center>\r\n					</td>\r\n				</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"16px\",\"overridden\":{\"font-size\":true}},\"default\":{\"font-family\":\"Helvetica\"},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"}}', '\n.acym_unsubscribe {\r\ncolor: black !important;\r\nfont-size: 10px !important;\r\ntext-decoration: underline black !important;\r\n}\r\n\r\n.acymailing_content p{\r\nfont-size: 13px !important;\r\n}\r\n\r\n.acydescription p{\r\ntext-align: center !important;\r\n}', NULL, '391', '{\"media_folder\":\"special_deals\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL),
('61', 'Travel', '2024-11-27 17:36:41', 'thumbnail_14.png', '1', 'template', '\r\n<div id=\"acym__wysid__template\" class=\"cell\">\r\n	<table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 30px 0px 120px;\">\r\n					<center>\r\n						<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" bgcolor=\"#ffffff\" style=\"background-color: transparent; min-height: 0px; display: table-cell;\">\r\n										<table class=\"row acym__wysid__row__element\" bgcolor=\"transparent\" style=\"background-image: url(&quot;https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_header.jpg&quot;); background-size: cover; padding: 10px 0px; background-color: transparent; z-index: 100; background-position: center center; background-repeat: no-repeat no-repeat;\" cellpadding=\"0\" id=\"acym__wysid__row__element6424047\" width=\"580\"><!--[if gte mso 9]><v:rect xmlns:v=\"urn:schemas-microsoft-com:vml\" fill=\"true\" stroke=\"false\" style=\"width: 580px;height: 320px\"><v:fill type=\"frame\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_header.jpg\" /><v:textbox inset=\"0,0,0,0\"><![endif]--><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 75px; display: block; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 75px; display: block;\"></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_0\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-family: verdana, geneva, sans-serif; font-size: 36px;\" data-mce-style=\"font-family: verdana, geneva, sans-serif; font-size: 36px;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">EXPLORE</span></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 22px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 150px; height:40px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgba(28, 152, 116, 0.93)\" strokeweight=\"0\" fillcolor=\"rgba(28, 152, 116, 0.93)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Verdana; font-size:12px; font-weight:400;\">SEE MORE</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style\" style=\"background-color: rgba(28, 152, 116, 0.93); color: rgb(255, 255, 255); padding: 14px 43px; max-width: 100%; overflow: unset; border: 0px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Verdana; font-size: 12px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">SEE MORE</a><!-- <![endif]--></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody><!--[if gte mso 9]></v:textbox></v:rect><![endif]--></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_10\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(55, 120, 91);\" data-mce-style=\"color: #37785b;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_23\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"124.422\" width=\"186.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_11\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px; color: rgb(55, 120, 91);\" data-mce-style=\"font-size: 20px; color: #37785b;\">âLorem ipsum</span></h1></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_26\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.641px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"124.422\" width=\"186.641\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_12\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px; color: rgb(55, 120, 91);\" data-mce-style=\"font-size: 20px; color: #37785b;\">âLorem ipsum</span></h1></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_27\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 186.688px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"124.453\" width=\"186.688\"></div></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_13\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px; color: rgb(55, 120, 91);\" data-mce-style=\"font-size: 20px; color: #37785b;\">âLorem ipsum</span></h1></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px; padding: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element512607\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_28\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: 201px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 290px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: 201px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 301px;\" height=\"201\" width=\"290\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_14\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(55, 120, 91);\" data-mce-style=\"color: #37785b;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_15\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet,</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\"> consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#37785b\" style=\"background-color: rgb(55, 120, 91); z-index: 100; position: relative; top: 0px; left: 0px; padding: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element5705412\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_16\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_17\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify; background-color: inherit;\">Lorem ipsum dolor sit amet,</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" data-mce-style=\"font-size: 12px; color: #000000; font-family: Helvetica; text-align: center; word-break: break-word; font-weight: normal; font-style: normal;\" style=\"font-size: 12px; color: rgb(0, 0, 0); font-family: Helvetica; text-align: center; word-break: break-word; font-weight: normal; font-style: normal;\"><span data-mce-style=\"color: #ffffff; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\" style=\"color: rgb(255, 255, 255); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\">consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_29\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: 204px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 290px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: 204px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 305px;\" height=\"204\" width=\"290\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100; position: relative; top: 0px; left: 0px; padding: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element1455934\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_30\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" title=\"trip template\" alt=\"trip template\" style=\"max-width: 100%; height: 201px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 290px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template.jpg\" data-mce-style=\"max-width: 100%; height: 201px; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 301px;\" height=\"201\" width=\"290\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_18\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(55, 120, 91);\" data-mce-style=\"color: #37785b;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_19\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit amet,</span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(128, 128, 128); font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"color: #808080; font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\"> consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;</span><br></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(255, 255, 255); position: relative; top: 0px; left: 0px;\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_20\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(55, 120, 91);\" data-mce-style=\"color: #37785b;\">âLorem ipsum</span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th>\r\n												</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#37785b\" style=\"background-color: rgb(55, 120, 91); z-index: 100; padding: 0px; position: relative; top: 0px; left: 0px;\" cellpadding=\"0\" id=\"acym__wysid__row__element9550020\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-0\" valign=\"top\" style=\"height: auto; padding-right: 5px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_31\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template1.jpg\" title=\"trip template1\" alt=\"trip template1\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 188px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template1.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"282\" width=\"188\"></div></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-1\" valign=\"top\" style=\"height: auto; padding-left: 5px; padding-right: 5px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 30px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_21\"><h1 class=\"acym__wysid__tinymce--title--placeholder acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 20px;\" data-mce-style=\"font-size: 20px;\"><strong><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">âLorem ipsum</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 20px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_22\"><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">â<span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Lorem ipsum dolor sit</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">amet, consectetur</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">adipiscing elit.</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">Ut enim ad</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\">&nbsp;<br></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"font-family: &quot;Open Sans&quot;, Arial, sans-serif; font-size: 14px; text-align: justify;\" data-mce-style=\"font-family: \'Open Sans\', Arial, sans-serif; font-size: 14px; text-align: justify;\">minim veniam, quis</span></span></p><p class=\"acym__wysid__tinymce--text--placeholder\" style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); word-break: break-word; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 12px; font-weight: normal; font-style: normal; color: #000000; word-break: break-word; text-align: center;\"><br></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns acym__wysid__row__element__th acym__wysid__row__element__th__vertical__padding-2\" valign=\"top\" style=\"height: auto; padding-left: 5px;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" spellcheck=\"false\" style=\"position: relative;\" contenteditable=\"false\" id=\"mce_32\"><div style=\"text-align: center\" data-mce-style=\"text-align: center\"><img class=\"acym__wysid__media__inserted\" src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template1.jpg\" title=\"trip template1\" alt=\"trip template1\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0px 5px; display: inline-block; margin-left: auto; margin-right: auto; width: 188px;\" data-mce-src=\"https://osp.realestate-panama.com/media/com_acym/templates/travel/images/Trip_template1.jpg\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: inline-block; margin-left: auto; margin-right: auto;\" height=\"282\" width=\"188\"></div></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"z-index: 100; background-color: rgb(255, 255, 255);\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns\" style=\"height: auto;\">\r\n														<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table; height: auto;\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group; height: auto;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto; display: table-row;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline-width: 0px;\"><div style=\"text-align: center;box-sizing: inherit;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\"style=\"width: 186px; height:66px;v-text-anchor:middle;\" href=\"#\" arcsize=\"50%\" strokecolor=\"rgb(255, 255, 255)\" strokeweight=\"1px\" fillcolor=\"rgb(55, 120, 91)\"><w:anchorlock/><center style=\"color :rgb(255, 255, 255); font-family:Arial; font-size:14px; font-weight:400;\">Visit our website</center></v:roundrect><![endif]--><!--[if !mso]> --><a class=\"acym__wysid__column__element__button acym__wysid__content-no-settings-style acym__wysid__column__element__button--focus\" style=\"background-color: rgb(55, 120, 91); color: white; padding: 25px 41px; max-width: 100%; overflow: unset; border: 1px solid white; text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-word; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 1; border-top-left-radius: 25px; border-top-right-radius: 25px; border-bottom-right-radius: 25px; border-bottom-left-radius: 25px;\" href=\"#\">Visit our website</a><!-- <![endif]--></div></td></tr></tbody></table></th>\r\n												</tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"background-color: rgb(255, 255, 255); z-index: 100;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 25px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#37785b\" style=\"background-color: rgb(55, 120, 91); z-index: 100; border-color: rgb(55, 120, 91); position: relative; top: 0px; left: 0px;\" cellpadding=\"0\"><tbody bgcolor=\"\" style=\"background-color: inherit;\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\" valign=\"top\" style=\"height: auto;\"><table class=\"acym__wysid__column\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"min-height: 0px; display: table; height: auto;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"height: 50px; outline-width: 0px;\"><span class=\"acy-editor__space\" style=\"display:block; padding: 0;margin: 0; height: 100%\"></span></td></tr></tbody></table></th></tr></tbody></table></td>\r\n								</tr></tbody></table></center>\r\n				</td>\r\n			</tr></tbody></table></div>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, '{\"default\":{\"font-family\":\"Helvetica\"},\"p\":{\"font-family\":\"Helvetica\",\"font-size\":\"12px\",\"overridden\":{\"font-size\":true}},\"a\":{\"font-family\":\"Helvetica\"},\"span.acym_link\":{\"font-family\":\"Helvetica\"},\"li\":{\"font-family\":\"Helvetica\"},\"h1\":{\"font-family\":\"Helvetica\"},\"h2\":{\"font-family\":\"Helvetica\"},\"h3\":{\"font-family\":\"Helvetica\"},\"h4\":{\"font-family\":\"Helvetica\"},\"h5\":{\"font-family\":\"Helvetica\"},\"h6\":{\"font-family\":\"Helvetica\"},\"#acym__wysid__background-colorpicker\":{\"background-color\":\"#efefef\",\"overridden\":{\"background-color\":true}}}', '', NULL, '391', '{\"media_folder\":\"travel\"}', NULL, NULL, NULL, '', '', '1', '', NULL, NULL, NULL);/**ABDB**/
