<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Container;
use Alledia\OSDownloads\Factory;
use Alledia\OSDownloads\Free\Joomla\View;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Pagination\Pagination;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

require_once JPATH_SITE . '/components/com_osdownloads/models/item.php';

// phpcs:enable PSR1.Files.SideEffects
// phpcs:disable PSR1.Classes.ClassDeclaration.MissingNamespace

class OSDownloadsViewCategories extends View\Site\Base
{
    /**
     * @var Container
     */
    protected $container = null;

    /**
     * @var object[]
     */
    protected $categories = null;

    /**
     * @var int
     */
    protected $itemId = null;

    /**
     * @var Pagination
     */
    protected $pagination = null;

    /**
     * @var bool
     */
    protected $showDescriptions = false;

    /**
     * @inheritDoc
     */
    public function display($tpl = null)
    {
        $this->app              = Factory::getApplication();
        $this->params           = $this->app->getParams();
        $this->container        = Factory::getPimpleContainer();
        $this->model            = BaseDatabaseModel::getInstance('Categories', 'OsdownloadsModel');
        $this->showDescriptions = (bool)$this->params->get('show_descriptions', 1);
        $this->itemId           = $this->app->input->getInt('Itemid');

        $db = Factory::getDatabase();

        $id = $this->app->input->getInt('id', 1);

        if ($menu = $this->app->getMenu()->getActive()) {
            $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
        }

        $extension = Factory::getExtension();
        $extension->loadLibrary();

        $limit      = $this->app->getUserStateFromRequest(
            'global.list.limit',
            'limit',
            $this->app->get('list_limit'),
            'int'
        );
        $limitstart = $this->app->getUserStateFromRequest(
            'osdownloads.request.limitstart',
            'limitstart',
            0,
            'int'
        );

        $filterOrder = $this->params->get('ordering', 'cat.lft');

        // Fix wrong filter
        if ($filterOrder == 'doc.ordering') {
            $filterOrder = 'cat.lft';
        }

        $this->app->setUserState('com_osdownloads.category.filter_order', $filterOrder);
        $this->app->setUserState(
            'com_osdownloads.category.filter_order_Dir',
            $this->params->get('ordering_dir', 'asc')
        );

        $query = $this->model->getChildCategoriesQuery($id);

        $db->setQuery($query)->execute();

        $total            = $db->getNumRows();
        $this->pagination = new Pagination($total, $limitstart, $limit);

        // Child Categories
        $db->setQuery($query, $this->pagination->limitstart, $this->pagination->limit);
        $this->categories = $db->loadObjectList();

        $user   = Factory::getUser();
        $groups = $user->getAuthorisedViewLevels();

        if (
            count($this->categories) == 0
            || !in_array($this->categories[0]->access, $groups)
        ) {
            throw new Exception(Text::_('COM_OSDOWNLOADS_THIS_CATEGORY_ISNT_AVAILABLE'), 404);
        }

        // Set additional data to each category
        if ($this->categories) {
            $itemId           = $this->app->input->getInt('Itemid');
            $ignoreCategories = (array)$this->params->get('ignore_categories', []);

            foreach ($this->categories as $category) {
                if (in_array($category->id, $ignoreCategories)) {
                    $category->hide = true;

                    continue;
                }

                $category->hasChildren = $this->model->getTotalCategoryChildren($category->id) > 0;
                $category->totalFiles  = $this->model->getTotalCategoryFiles($category->id);
                $category->hide        = (!$category->totalFiles && !$category->hasChildren);
                $category->link        = $category->hasChildren
                    ? $this->container->helperRoute->getCategoriesRoute($category->id, $itemId)
                    : $this->container->helperRoute->getFileListRoute($category->id, $itemId);
            }
        }

        $this->container->helperView->buildCategoryBreadcrumbs($id);

        parent::display($tpl);
    }
}
