<?php
/*------------------------------------------------------------------------
# price.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsCalendarPrice{
	function listPrices($property,$room,$rows,$pageNav,$lists){
		global $mainframe,$configClass,$cClass;
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
		if($cClass['use_calendar'] == 1){
		?>
		<script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
		<script language="javascript">
		jQuery(function() {
			jQuery( "#start" ).datepicker({
				dateFormat: 'yy-mm-dd',
			 	showOn: "button",
			 	buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
			 	buttonImageOnly: true
			 });
		});
		jQuery(function() {
			jQuery( "#end" ).datepicker({
				dateFormat: 'yy-mm-dd',
				showOn: "button",
				buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
				buttonImageOnly: true
			});
		});
		</script>
		<?php } ?>
		<form method="POST" action="<?php JRoute::_("index.php?option=com_oscalendar&task=price_setup&pid=".$property->id."&rid=".$room->id);?>" name="adminForm" id="adminForm">
		<div class="row-fluid">
			<div class="span12">
				<?php
                if($cClass['allow_room'] == 1) {
                    OSPHelper::generateHeading(2, $title . " > " . $room->room_name . " > " . JText::_('OS_MANAGE_PRICE'));
                }else{
                    OSPHelper::generateHeading(2, $title . " > " . JText::_('OS_MANAGE_PRICE'));
                }
				?>
				<div class="clearfix"></div>
				<div class="btn-toolbar pull-right hidden-phone">
		            <div class="btn-group">
		            	<button type="button" class="btn hasTooltip btn-primary" title="<?php echo JText::_('OS_ADDNEW');?>" onclick="javascript:submitForm('price_addnew');">
		                    <i class="osicon-new"></i> <?php echo JText::_('OS_ADDNEW');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-info" title="<?php echo JText::_('OS_EDIT');?>" onclick="javascript:submitForm('price_edit');">
		                    <i class="osicon-edit"></i> <?php echo JText::_('OS_EDIT');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-danger" title="<?php echo JText::_('OS_REMOVE');?>" onclick="javascript:submitForm('price_remove');">
		                    <i class="osicon-trash"></i> <?php echo JText::_('OS_REMOVE');?>
		                </button>
		                <button type="button" class="btn hasTooltip" title="<?php echo JText::_('OS_MANAGE_ROOMS');?>" onclick="javascript:location.href='<?php echo JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$property->id.'&Itemid='.$mainframe->input->getInt('Itemid',0))?>'">
		                    <i class="osicon-calendar"></i> 
		                    <?php echo JText::_('OS_MANAGE_ROOMS');?>
		                </button>
		            </div>
		        </div>
				<table  width="100%" border="0">
					<tr>
						<td align="left">
						</td>
						<td align="right">
							<div style="float:right;padding:10px;padding-top:25px;">
								<input type="submit" class="btn btn-warning" value="<?php echo JText::_('OS_SUBMIT')?>" />
							</div>
							<div style="float:right;padding:10px;padding-top:25px;" id="checkin-list-customer-order">
							<?php echo JText::_('OS_TO')?>&nbsp;
							
							<?php
			            	echo OSCHelper::loadCalendarTag('end',$mainframe->input->getString('end'),'input-small','','','');
			            	?>
							</div>
							<div style="float:right;padding:10px;padding-top:25px;" id="checkout-list-customer-order">
							<?php echo JText::_('OS_FROM')?>&nbsp;
							<?php
			            	echo OSCHelper::loadCalendarTag('start',$mainframe->input->getString('start'),'input-small','','','');
			            	?>
							</div>
						</td>
					</tr>
				</table>
				
				<table  width="100%" class="adminlist table table-striped">
					<thead>
						<tr>
							<th width="5%" style="text-align:center;">#</th>
							<th width="5%" style="text-align:center;">
								<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
							</th>
							<th width="25%" style="text-align:center;">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_TITLE'), 'title', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
							</th>
							<th width="15%" style="text-align:center;">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_START'), 'price_from', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
							</th>
							<th width="15%" style="text-align:center;">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_END'), 'price_to', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
							</th>
							<th width="15%" style="text-align:center;">
								<?php echo JHTML::_('grid.sort',   JText::_('OS_PRICE'), 'price', @$lists['order_Dir'], @$lists['order'] ,'price_setup'); ?>
							</th>
							<th width="20%" style="text-align:center;">
								<?php echo JText::_('OS_CURRENCY');?>
							</th>								
						</tr>
					</thead>
					<tfoot>
						<tr>
							<td width="100%" colspan="7" style="text-align:center;">
								<?php
									echo $pageNav->getListFooter();
								?>
							</td>
						</tr>
					</tfoot>
					<tbody>
						<?php
						$db = JFactory::getDbo();
						$k = 0;
						for ($i=0, $n=count($rows); $i < $n; $i++) {
							$row 		= $rows[$i];
							$checked 	= JHtml::_('grid.id', $i, $row->id);
							$link 		= JRoute::_( 'index.php?option=com_oscalendar&task=price_edit&cid[]='. $row->id.'&pid='.$property->id.'&rid='.$room->id );
							$published 	= JHTML::_('jgrid.published', $row->published, $i , 'price_');
							?>
							<tr class="<?php echo "row$k"; ?>">
								<td align="center" style="text-align:center;"><?php echo $pageNav->getRowOffset( $i ); ?></td>
								<td align="center" style="text-align:center;"><?php echo $checked; ?></td>
								<td style="text-align:left;padding-left:20px;"><a href="<?php echo $link?>"><?php echo $row->title?></a></td>
								<td style="text-align:center;"><?php echo date($cClass['date_format'],strtotime($row->price_from))?></td>
								<td style="text-align:center;"><?php echo date($cClass['date_format'],strtotime($row->price_to))?></td>
								<td style="text-align:center;"><?php echo HelperOspropertyCommon::showPrice($row->price);?></td>
								<td style="text-align:center;">
									<?php
									echo OSCHelper::showCurrency($row->curr);
									?>
								</td>
							</tr>
						<?php
							$k = 1 - $k;	
						}
						?>
					</tbody>
				</table>
			</div>
		</div>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="price_setup" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
		<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
		</form>
		<script language="javascript">
		function submitForm(t){
			var total = 0;
			var temp;
			if(t == "price_addnew"){
				document.adminForm.task.value = t;
				document.adminForm.submit();
			}else{
				total = <?php echo count($rows)?>;
				if(total > 0){
					var check = 0;
					for(i=0;i<total;i++){
						temp = document.getElementById('cb' + i);
						if(temp != null){
							if(temp.checked == true){
								check = 1;
							}
						}
					}
					if(check == 0){
						alert("<?php echo JText::_("OS_PLEASE_ITEM")?>");
					}else{
						if(t == "price_remove"){
							var answer = confirm("<?php echo JText::_('OS_DO_YOU_WANT_TO_REMOVE_ITEMS')?>");
							if(answer == 1){
								document.adminForm.task.value = "price_remove";
								document.adminForm.submit();
							}
						}else{
							document.adminForm.task.value = t;
							document.adminForm.submit();
						}
					}
				}
			}
		}
		</script>
		<?php
	}
	
	/**
	 * Edit price
	 *
	 * @param unknown_type $row
	 * @param unknown_type $property
	 * @param unknown_type $room
	 */
	function editPrice($row,$property,$room){
		global $mainframe,$configClass,$cClass,$languages;
		JHTML::_('behavior.tooltip');
		$db = JFactory::getDBO();
		?>
		<form method="POST" action="<?php echo JURI::root()?>index.php?option=com_oscalendar" name="ftForm" id="ftForm" enctype="multipart/form-data">
		<div class="row-fluid">
			<div class="span12">
				<?php
				if($row->id > 0){
					$func = JText::_('OS_EDIT');
				}else{
					$func = JText::_('OS_ADDNEW');
				}
				$title = "";
				if($property->ref != ""){
					$title .= $property->ref.", ";
				}

				$title .= $property->pro_name;
				$title = $title ;
                if($cClass['allow_room'] == 1) {
                    $title .= " > " . $room->room_name;
                }
				$title .= " > ".JText::_('OS_MANAGE_PRICE');
				$title .= " > ".$func;
				?>
				<?php
					OSPHelper::generateHeading(2,$title);
				?>
				<div class="clearfix"></div>
				<div class="btn-toolbar pull-right hidden-phone">
		            <div class="btn-group">
		            	<button type="button" class="btn hasTooltip btn-success" title="<?php echo JText::_('OS_SAVE');?>" onclick="javascript:submitForm('price_save');">
		                    <i class="osicon-save"></i> <?php echo JText::_('OS_SAVE');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-info" title="<?php echo JText::_('OS_APPLY');?>" onclick="javascript:submitForm('price_apply');">
		                    <i class="osicon-apply"></i> <?php echo JText::_('OS_APPLY');?>
		                </button>
		                <button type="button" class="btn hasTooltip btn-danger" title="<?php echo JText::_('OS_CANCEL');?>" onclick="javascript:submitForm('price_cancel');">
		                    <i class="osicon-cancel"></i> <?php echo JText::_('OS_CANCEL');?>
		                </button>
		            </div>
		        </div>
				<table width="100%" class="admintable">
					<tr>
						<td class="key">
							<?php echo JText::_('OS_TITLE')?>:
						</td>
						<td>
							<input type="text" name="title" id="title" class="input-large" size="40" value="<?php echo $row->title;?>" />
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_START')?>:
						</td>
						<td>
							<?php
							echo JHTML::_('calendar',$row->price_from, 'price_from', 'price_from', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
							?>
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_END')?>:
						</td>
						<td>
							<?php
							echo JHTML::_('calendar',$row->price_to, 'price_to', 'price_to', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
							?>
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_PRICE')?>:
						</td>
						<td>
							<input type="text" name="price" id="price" class="input-mini" value="<?php echo $row->price;?>" />
						</td>
					</tr>
					<tr>
						<td class="key">
							<?php echo JText::_('OS_CURRENCY')?>:
						</td>
						<td>
							<?php
							echo OSappschedulePrice::generatePriceDropdownList($row->curr,$property->curr);
							?>
						</td>
					</tr>
				</table>
			</div>
		</div>
		<input type="hidden" name="MAX_FILE_SIZE" value="90000000" />
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="id" value="<?php echo $row->id?>" />
		<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
		<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
		<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
		</form>
		<script language="javascript">
		function submitForm(t){
			document.ftForm.task.value = t;
			document.ftForm.submit();
		}
		</script>
		<?php
	}
	
	
	/**
	 * Show property price
	 *
	 * @param unknown_type $property
	 * @param unknown_type $room
	 * @param unknown_type $room_prices
	 */
	function showPropertyPrice($property,$room,$room_prices){
		global $mainframe,$configClass,$cClass;
		$title = "";
		if($property->ref != ""){
			$title .= $property->ref.", ";
		}
		$title .= $property->pro_name;
		//JToolbarHelper::title($title ." > ".$room->room_name." > ".JText::_('OS_SETUP_PRICE'));
		//JToolbarHelper::save('price_save');
		//JToolbarHelper::apply('price_apply');
		//JToolbarHelper::cancel('price_cancel',JText::_('OS_GO_ROOMS'));
		//JToolbarHelper::cancel('price_propertycancel',JText::_('OS_GO_PROPERTIES'));
		if($cClass['use_calendar'] == 1){
		?>
		<script src="//code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
		
		<script language="javascript">
		jQuery(function() {
			jQuery( "#price_from" ).datepicker({
				dateFormat: 'yy-mm-dd',
			 	showOn: "button",
			 	buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
			 	buttonImageOnly: true
			 });
		});
		jQuery(function() {
			jQuery( "#price_to" ).datepicker({
				dateFormat: 'yy-mm-dd',
				showOn: "button",
				buttonImage: "<?php echo JURI::root()?>components/com_oscalendar/style/calendar.png",
				buttonImageOnly: true
			});
		});
		</script>
		<?php } ?>
		<form method="POST" action="<?php echo JURI::root()?>index.php?option=com_oscalendar" id="ftForm" name="ftForm" class="form-horizontal">
			<div class="row-fluid">
				<div class="span12">
					<?php
					
					$title = "";
					if($property->ref != ""){
						$title .= $property->ref.", ";
					}
					$title .= $property->pro_name;
					$title = $title ;
                    if($cClass['allow_room'] == 1) {
                        $title .= " > " . $room->room_name;
                    }
					$title .= " > ".JText::_('OS_CONFIGURE_PRICE');
					?>
					<?php
						OSPHelper::generateHeading(2,$title);
					?>
					<div class="clearfix"></div>
					<div class="btn-toolbar pull-right hidden-phone">
			            <div class="btn-group">
			            	<button type="button" class="btn hasTooltip btn-success" title="<?php echo JText::_('OS_SAVE');?>" onclick="javascript:submitForm('price_save');">
			                    <i class="osicon-save"></i> <?php echo JText::_('OS_SAVE');?>
			                </button>
			                <button type="button" class="btn hasTooltip btn-info" title="<?php echo JText::_('OS_APPLY');?>" onclick="javascript:submitForm('price_apply');">
			                    <i class="osicon-apply"></i> <?php echo JText::_('OS_APPLY');?>
			                </button>
			                <button type="button" class="btn hasTooltip btn-danger" title="<?php echo JText::_('OS_CANCEL');?>" onclick="javascript:submitForm('price_cancel');">
			                    <i class="osicon-cancel"></i> <?php echo JText::_('OS_CANCEL');?>
			                </button>
			                <button type="button" class="btn hasTooltip" title="<?php echo JText::_('OS_MANAGE_ROOMS');?>" onclick="javascript:location.href='<?php echo JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$property->id.'&Itemid='.$mainframe->input->getInt('Itemid',0))?>'">
			                    <i class="osicon-calendar"></i> 
			                    <?php echo JText::_('OS_MANAGE_ROOMS');?>
			                </button>
			            </div>
			        </div>
			        <div class="clearfix"></div>
					<div class="row-fluid">
						<div class="span12">
							<div class="span6">
								<div class="control-group">
									<label class="control-label" ><?php echo JText::_('OS_FROM')?></label>
									<div class="controls" id="priceedit-list-customer-order">
										<?php
						            	echo OSCHelper::loadCalendarTag('price_from','','input-small','','','');
						            	?>
									</div>
								</div>
								<div class="control-group">
									<label class="control-label" ><?php echo JText::_('OS_TO')?></label>
									<div class="controls" id="priceedit-list-customer-order">
										<?php
						            	echo OSCHelper::loadCalendarTag('price_to','','input-small','','','');
						            	?>
									</div>
								</div>
								<div class="control-group">
									<label class="control-label" ><?php echo JText::_('OS_PRICE')?></label>
									<div class="controls">
										<input type="text" class="input-mini" name="price" id="price"/>
									</div>
								</div>
								<div class="control-group">
									<label class="control-label" ><?php echo JText::_('OS_CURRENCY')?></label>
									<div class="controls">
										<?php
										echo OSappschedulePrice::generatePriceDropdownList(0,$property->curr);
										?>
									</div>
								</div>
								<div class="control-group">
									<label class="control-label" ><?php echo JText::_('OS_MINIMUM_STAY')?></label>
									<div class="controls">
										<input type="text" class="input-mini" name="min_booking" id="min_booking"/>
									</div>
								</div>
							</div>
							<div class="span3">
								<strong><?php echo JText::_('OS_PRICE_FOR')?></strong>
								<BR />
								<input type="checkbox" name="allday" id="allday" value="1" checked onclick="javascript:clearAllDays();"> &nbsp; <?php echo JText::_('OS_ALL_DAYS');?>
								<br />
								<?php echo JText::_('OS_ONE_MORE_DAYS');?>
								<br />
								<?php
								$dateArr = array('mon','tue','wed','thu','fri','sat','sun');
								for($i=0;$i<count($dateArr);$i++){
									?>
									<input type="checkbox" name="<?php echo $dateArr[$i];?>" id="<?php echo $dateArr[$i];?>" value="0" onclick="javascript:changeValueDateInWeek('<?php echo $dateArr[$i];?>');"> &nbsp; <?php echo JText::_('OS_'.strtoupper($dateArr[$i]));?>
									<BR />
									<?php
								}
								?>
							</div>
							<div class="span3">
								<strong><?php echo JText::_('OS_ALLOW_CHECKIN_ON')?></strong>
								<BR />
								<input type="checkbox" name="allow_book_all" id="allow_book_all" value="1" checked onclick="javascript:clearAllAllowDays();"> &nbsp; <?php echo JText::_('OS_ALL_DAYS');?>
								<br />
								<?php echo JText::_('OS_ONE_MORE_DAYS');?>
								<br />
								<?php
								$dateArr1 = array('mon','tue','wed','thu','fri','sat','sun');
								$dateArr = array('allow_mon','allow_tue','allow_wed','allow_thu','allow_fri','allow_sat','allow_sun');
								for($i=0;$i<count($dateArr);$i++){
									?>
									<input type="checkbox" name="<?php echo $dateArr[$i];?>" id="<?php echo $dateArr[$i];?>" value="0" onclick="javascript:changeValueAllowDateInWeek('<?php echo $dateArr[$i];?>');"> &nbsp; <?php echo JText::_('OS_'.strtoupper($dateArr1[$i]));?>
									<BR />
									<?php
								}
								?>
							</div>
						</div>
						<div class="span12">
							<div class="navbar">
								<div class="navbar-inner" style="padding:5px;">
									<?php
									$current_year = date("Y",time());
									?>
									<?php echo JText::_('OS_SELECTED_YEAR')?>:
									<select name="select_year" id="select_year" class="input-small" onChange="javascript:loadPriceCalendarDivFrontEnd(<?php echo $room->id?>,<?php echo $property->id?>);">
									<?php
										for($i=$current_year;$i<=$current_year + 6;$i++){
											?>
											<option value="<?php echo $i;?>"><?php echo $i;?></option>
											<?php
										}
									?>
									</select>
								</div>
							</div>
						</div>
						<div class="span12" id="price_calendar_div">
							<?php
							for($i=intval(date("m",time()));$i<=12;$i++){
								HelperOsCalendarCalendar::showCalendarWithPriceBackend($room->id,$property->id,date("Y",time()),$i);
								echo "<BR />";
							}
							?>
						</div>
					</div>
				</div>
			</div>
			<input type="hidden" name="option" value="com_oscalendar" />
			<input type="hidden" name="task" value="price_setup" />
			<input type="hidden" name="pid" id="pid" value="<?php echo $property->id; ?>" />
			<input type="hidden" name="rid" id="rid" value="<?php echo $room->id; ?>" />
			<input type="hidden" name="price_type" id="price_type" value="<?php echo $property->price_type; ?>" />
			<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root();?>" />
			<input type="hidden" name="boxchecked" value="0" />
		</form>
		<script language="javascript">
		function clearAllDays(){
			var temp;
			var allday = document.getElementById('allday');
			if(allday.value == 1){
				allday.value = 0;
			}else{
				allday.value = 1;
				arr = new Array('mon','tue','wed','thu','fri','sat','sun');
				for(i=0;i<arr.length;i++){
					temp = arr[i];
					temp = document.getElementById(temp);
					temp.value = 0;
					temp.checked = false;
				}
			}
		}
		
		function changeValueDateInWeek(id){
			var temp;
			var temp = document.getElementById(id);
			var allday = document.getElementById('allday');
			if(temp.value == 1){
				temp.value = 0;
			}else{
				allday.value = 0;
				allday.checked = false;
				temp.value = 1;
			}
		}
		
		function changeValueAllowDateInWeek(id){
			var temp;
			var temp = document.getElementById(id);
			var allday = document.getElementById('allow_book_all');
			if(temp.value == 1){
				temp.value = 0;
			}else{
				allday.value = 0;
				allday.checked = false;
				temp.value = 1;
			}
		}
		
		function clearAllAllowDays(){
			var temp;
			var allday = document.getElementById('allow_book_all');
			if(allday.value == 1){
				allday.value = 0;
			}else{
				allday.value = 1;
				arr = new Array('allow_mon','allow_tue','allow_wed','allow_thu','allow_fri','allow_sat','allow_sun');
				for(i=0;i<arr.length;i++){
					temp = arr[i];
					temp = document.getElementById(temp);
					temp.value = 0;
					temp.checked = false;
				}
			}
		}

		function submitForm(t){
			document.ftForm.task.value = t;
			document.ftForm.submit();
		}
		</script>
		<?php
	}
}
?>