<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

/**
 * Layout variables
 *
 * @var stdClass $item
 * @var array    $fields
 * @var array    $fieldValues
 * @var string   $rootUri
 * @var array    $results
 * @var array    $hiddenFieldIds
 */

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
if (Factory::getApplication()->isClient('site'))
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper     = HelpdeskProHelperBootstrap::getInstance();
}

$config = HelpdeskProHelper::getConfig();
?>
<table class="<?php echo $bootstrapHelper->getClassMapping('table table-striped table-bordered'); ?>">
	<tr>
		<th colspan="2" class="hdp-ticket-details-heading <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>"><?php echo Text::_('HPD_TICKET_DETAIL'); ?></th>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_TICKET_ID'); ?>
		</td>
		<td>
			<?php echo $item->id; ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_CATEGORY'); ?>
		</td>
		<td>
			<?php echo $item->category_title ; ?>
		</td>
	</tr>
	<?php
	if ($item->user_id > 0)
	{
	?>
		<tr>
			<td>
				<?php echo Text::_('HDP_USER'); ?>
			</td>
			<td>
				<?php echo $item->username; ?>[<?php echo $item->user_id; ?>]
			</td>
		</tr>
	<?php
	}
	?>
	<tr>
		<td>
			<?php echo Text::_('HDP_NAME'); ?>
		</td>
		<td>
			<?php echo $item->name; ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_EMAIl'); ?>
		</td>
		<td>
			<a href="mailto:<?php echo $item->email; ?>"><?php echo $item->email; ?></a>
		</td>
	</tr>
	<?php
	if ($item->user_ip && Factory::getApplication()->isClient('administrator'))
	{
	?>
		<tr>
			<td>
				<?php echo Text::_('HDP_IP'); ?>
			</td>
			<td>
				<?php echo $item->user_ip; ?>
			</td>
		</tr>
	<?php
	}

	if ($item->staff_id > 0)
	{
		$user = Factory::getUser($item->staff_id);
		if ($user->id)
		{
            $displayField = $config->get('staff_display_field', 'username') ?: 'username';
		?>
		<tr>
			<td>
                <?php echo Text::_('HDP_STAFF'); ?>
			</td>
			<td>
                <?php echo $user->{$displayField} ; ?>
			</td>
		</tr>
		<?php
		}
	}

	if ($hasStatuses ?? true)
	{
	?>
		<tr>
			<td>
				<?php echo Text::_('HDP_TICKET_STATUS'); ?>
			</td>
			<td>
				<?php echo $item->status ; ?>
			</td>
		</tr>
	<?php
	}

	if ($config->get('enable_rating', 1) && $item->rating)
	{
		switch ($item->rating)
		{
			case 1:
				$img = 'unsatisfactory.png';
				$title = Text::_('HDP_VERY_POOR');
				break ;
			case 2:
				$img = 'poor.png';
				$title = Text::_('HDP_FAIR');
				break ;
			case 3:
				$img = 'average.png';
				$title = Text::_('HDP_AVERAGE');
				break ;
			case 4:
				$img = 'good.png';
				$title = Text::_('HDP_GOOD');
				break ;
			case 5:
				$img = 'great.png';
				$title = Text::_('HDP_EXCELLENT');
				break ;
		}
		?>
            <tr>
                <td>
                    <?php echo Text::_('HDP_RATING'); ?>
                </td>
                <td>
                    <img src="<?php echo $rootUri . '/media/com_helpdeskpro/feedback/' . $img; ?>" title="<?php echo $title; ?>" />
                </td>
            </tr>
		<?php
	}

	if ($hasPriorities ?? true)
	{
	?>
		<tr>
			<td>
				<?php echo Text::_('HDP_TICKET_PRIORITY'); ?>
			</td>
			<td>
				<?php echo $item->priority ; ?>
			</td>
		</tr>
	<?php
	}
	?>
	<tr>
		<td>
			<?php echo Text::_('HDP_CREATED_DATE'); ?>
		</td>
		<td>
			<?php echo HTMLHelper::_('date', $item->created_date, $config->date_format); ?>
		</td>
	</tr>
	<tr>
		<td>
			<?php echo Text::_('HDP_MODIFIED_DATE'); ?>
		</td>
		<td>
			<?php echo HTMLHelper::_('date', $item->modified_date, $config->date_format); ?>
		</td>
	</tr>
	<?php
	if (count($fields))
	{
		$hiddenIds = $hiddenFieldIds ?? [];
	?>
		<tr><th colspan="2" class="hpd-ticket-extra-information <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>"><?php echo Text::_('HPD_EXTRA_INFORMATION'); ?></th></tr>
		<?php
		foreach($fields as $field)
		{
		    if (in_array($field->fieldtype, ['Heading', 'Message']))
            {
                continue;
		    }

			// Do not display hidden fields
			if (in_array($field->id, $hiddenFieldIds))
			{
				continue;
			}

			$fieldValue = $fieldValues[$field->id] ?? '';

			if ($fieldValue && $field->fieldtype === 'Date')
            {
                try
                {
	                $fieldValue = HTMLHelper::_('date', $fieldValue, $config->date_format, null);
                }
                catch (Exception $e)
                {
                    // Might happen because date is in wrong format
                }
            }

			if ($fieldValue && $field->fieldtype === 'Url' && filter_var($fieldValue, FILTER_VALIDATE_URL))
			{
				$fieldValue = '<a href="' . $fieldValue . '" target="_blank">' . $fieldValue . '</a>';
			}
		?>
			<tr>
				<td>
					<?php echo $field->title ; ?>
				</td>
				<td>
					<?php echo $fieldValue; ?>
				</td>
			</tr>
		<?php
		}
	}

	if (!empty($results))
	{
		foreach($results as $result)
		{
			echo $result ;
		}
	}
	?>
</table>
