<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 * Layout variables
 *
 * @var bool                      $canComment
 * @var bool                      $captchaInvalid
 * @var \OSL\Config\Config        $config
 * @var string                    $rootUri
 * @var \Joomla\CMS\Editor\Editor $editor
 * @var string                    $message
 * @var string                    $captcha
 */

defined('_JEXEC') or die;

if (!$canComment)
{
    return;
}

if ($captchaInvalid)
{
    $style = '';
}
else
{
    $style = ' style="display:none;"';
}

$app = Factory::getApplication();

/* @var $bootstrapHelper HelpdeskProHelperBootstrap */
if ($app->isClient('site'))
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}

$btnClass        = $bootstrapHelper->getClassMapping('btn');
$btnPrimaryClass = $bootstrapHelper->getClassMapping('btn btn-primary');

$assetVersion = HelpdeskProHelper::getInstalledVersion();
$role         = HelpdeskProHelper::getUserRole();

$wa = $app->getDocument()
	->addScriptOptions('btnClass', $btnClass)
	->addScriptOptions('btnPrimaryClass', $bootstrapHelper->getClassMapping('btn-primary'))
	->addScriptOptions('btnDangerClass', $bootstrapHelper->getClassMapping('btn-secondary'))
	->addScriptOptions('editCommentText', Text::_('HDP_EDIT_COMMENT'))
	->addScriptOptions('saveButtonLabel', Text::_('HDP_SAVE'))
	->addScriptOptions('cancelButtonLabel', Text::_('HDP_CANCEL'))
	->addScriptOptions('useHtmlEditor', (bool) $config->use_html_editor)
	->addScriptOptions('useKeyboardShortcuts', (bool) $config->get('use_keyboard_shortcuts', 1))
	->addScriptOptions('userRole', $role)
	->getWebAssetManager();

if (!$config->use_html_editor && $config->process_bb_code)
{
	$wa->registerAndUseScript(
		'com_helpdeskpro.helpdeskpro.bbcode',
		'media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js',
		['version' => $assetVersion]
	);
}

if (!$config->use_html_editor)
{
	$wa->registerAndUseScript('com_helpdeskpro.tingle', 'media/com_helpdeskpro/assets/js/tingle/tingle.js', ['version' => $assetVersion])
		->registerAndUseStyle('com_helpdeskpro.tingle', 'media/com_helpdeskpro/assets/js/tingle/tingle.css', ['version' => $assetVersion]);
}

$wa->registerAndUseScript('com_helpdeskpro.common-ticket-default', 'media/com_helpdeskpro/js/common-ticket-default.js', ['version' => $assetVersion]);

Text::script('HDP_ENTER_COMMENT_FOR_TICKET', true);

if ($config->enable_attachment)
{
	echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
}
?>
<div id="tr_message_id" <?php echo $style; ?>>
    <?php
    if (HelpdeskProHelper::canAddInternalComment())
    {
    ?>
    <div class="<?php echo $bootstrapHelper->getClassMapping('control-group'); ?>">
	    <div class="<?php echo $bootstrapHelper->getClassMapping('control-label'); ?>">
			<?php echo Text::_('HDP_INTERNAL_COMMENT'); ?>
	    </div>
	    <div class="<?php echo $bootstrapHelper->getClassMapping('controls'); ?>">
			<input type="checkbox" name="is_internal_comment" value="1" class="form-check" />
	    </div>
    </div>
	<?php
    }

    if ($config->use_html_editor)
    {
        echo $editor->display( 'message',  $message, '100%', '250', '75', '10', false);
    }
    else
    {
    ?>
        <textarea rows="8" class="hdp_fullwidth form-control" cols="75" class="hdp_fullwidth" name="message" id="message"><?php echo $message; ?></textarea>
    <?php
    }

    if ($config->enable_attachment)
    {
    ?>
        <div class="hdp-upload-attachments-container clearfix">
            <h3 class="hpd-upload-attachments-heading"><?php echo Text::_('HDP_ATTACHMENTS'); ?></h3>
	        <?php echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments_form.php'); ?>
        </div>
    <?php
    }

    if ($config->enable_captcha && !empty($captcha))
    {
	    if (in_array($captchaPlugin ?? '', ['recaptcha_invisible', 'recaptcha_v3']))
	    {
		    $style = ' style="display:none;"';
	    }
	    else
	    {
		    $style = '';
	    }
    ?>
        <div class="<?php echo $bootstrapHelper->getClassMapping('control-group'); ?>">
            <div class="<?php echo $bootstrapHelper->getClassMapping('control-label'); ?>"<?php echo $style; ?>>
	            <?php echo Text::_('HDP_CAPTCHA'); ?><span class="required">*</span>
            </div>
            <div class="<?php echo $bootstrapHelper->getClassMapping('controls'); ?>">
	            <?php echo $captcha; ?>
            </div>
        </div>
    <?php
    }
    ?>
    <div class="clearfix"></div>
    <input type="button" name="btnSubmitComment" id="btnSubmitComment" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_SUBMIT_COMMENT'); ?>" />
    <?php
        if ($app->isClient('administrator'))
        {
        ?>
            <input type="button" name="btnCommentAndList" id="btnCommentAndList" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_COMMENT_AND_LIST'); ?>" />
        <?php
        }
    ?>
    <input type="button" name="btnCommentAndClose" id="btnCommentAndClose" class="<?php echo $btnPrimaryClass; ?>" value="<?php echo Text::_('HDP_COMMENT_AND_CLOSE'); ?>" />
</div>