<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\View\Categories;

use HelpdeskProHelperBootstrap;
use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;
use OSSolution\HelpdeskPro\Site\Helper\Route as RouteHelper;

defined('_JEXEC') or die;

class Html extends ListView
{
	/**
	 * Menu item parameters
	 *
	 * @var Registry
	 */
	protected $params;

	/**
	 * Bootstrap Helper
	 *
	 * @var HelpdeskProHelperBootstrap
	 */
	protected $bootstrapHelper;

	/**
	 * Prepare view data
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		foreach ($this->items as $item)
		{
			RouteHelper::addArticles($item->articles);
		}

		// Handle page title
		$active = Factory::getApplication()->getMenu()->getActive();
		$params = HelpdeskProHelperHtml::getViewParams($active, ['categories']);
		HelpdeskProHelperHtml::prepareDocument($params);

		$this->params          = $params;
		$this->bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
	}
}