<?php
/*------------------------------------------------------------------------
# cpanel.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Updater\Updater;
use Joomla\Component\Installer\Administrator\Model\UpdateModel;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;

class OspropertyCpanel
{
	static function cpanel($option)
	{
		global $mainframe,$configClass,$_jversion;
		ini_set('auto_detect_line_endings',true);
		$db = Factory::getContainer()->get('db');
		$document = Factory::getApplication()->getDocument();
		$wa = $document->getWebAssetManager();
		$wa->registerAndUseStyle('osproperty.dashboard', Uri::root().'administrator/components/com_osproperty/assets/css/dashboard.css');
		$db->setQuery("Select count(id) from #__osrs_properties where approved = '1' and published = '1'");
		$lists['properties'] = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_categories where published = '1'");
		$lists['categories'] = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_types where published = '1'");
		$lists['type']		 = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_agents where published = '1'");
		$lists['agent']		 = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_amenities where published = '1'");
		$lists['amenities']  = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_pricegroups where published = '1'");
		$lists['pricegroups']= $db->loadResult();
		
		$db->setQuery("Select count(extension_id) from #__extensions where `element` like 'ospropertyplg' and enabled = '1'");
		$lists['plugin'] = $db->loadResult();
		
		$db->setQuery("Select count(id) from #__osrs_agents where published = '1'");
		$lists['agent_active'] = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_agents where published = '0'");
		$lists['agent_unactive'] = $db->loadResult();
		$db->setQuery("Select count(id) from #__osrs_agents where request_to_approval = '1'");
		$lists['agent_request'] = $db->loadResult();
		
		$coresql = "Select count(a.id) from #__osrs_properties as a inner join #__osrs_agents as b on b.id = a.agent_id inner join #__osrs_states as c on c.id = a.state inner join #__osrs_types as d on d.id = a.pro_type where b.published = '1'";

		$db->setQuery($coresql.' and a.approved = 1');
		$lists['property_approved'] = $db->loadResult();
		$db->setQuery($coresql.' and a.approved = 0');
		$lists['property_unapproved'] = $db->loadResult();
		$db->setQuery($coresql.' and a.request_to_approval = 1 and a.approved = 0');
		$lists['property_request'] = $db->loadResult();
		$db->setQuery($coresql.' and a.isFeatured = 1 and a.approved = 1');
		$lists['property_featured'] = $db->loadResult();
		$db->setQuery($coresql.' and a.isFeatured = 0 and a.request_featured <> 0');
		$lists['property_request_featured'] = $db->loadResult();
		
		$db->setQuery("Select id,pro_name,hits from #__osrs_properties where approved = '1' order by hits desc limit 5");
		$lists['mostviewed'] = $db->loadObjectList();
		$db->setQuery("Select a.pro_id,b.pro_name,b.hits, count(a.id) as sum from #__osrs_favorites as a inner join #__osrs_properties as b on b.id = a.pro_id group by a.pro_id order by count(a.id) desc limit 5");
		$lists['mostfavorites'] = $db->loadObjectList();
		$db->setQuery("Select id,pro_name,hits,(`total_points`/`number_votes`) as rate from #__osrs_properties where number_votes > 0 and approved = '1' order by rate desc limit 5");
		$lists['mostrate'] = $db->loadObjectList();
		$db->setQuery("Select a.pro_id,b.pro_name,b.hits, count(a.id) as sum from #__osrs_comments as a inner join #__osrs_properties as b on b.id = a.pro_id group by a.pro_id order by count(a.id) desc limit 5");
		$lists['mostcomments'] = $db->loadObjectList();
		
		$langArr = OSPHelper::returnSupportedCountries();
		
		$countryArr = [];
		for($i=0;$i<count($langArr);$i++){
			$countryArr[] = $langArr[$i]->country_id;
		}
		$countrySql = implode(",",$countryArr);
		
		$db->setQuery("Select * from #__osrs_countries where id in ($countrySql)");
		$countries = $db->loadObjectList();
		
		if (extension_loaded('gd') && function_exists('gd_info')) 
		{
		     $gd = 1;
		     $gdinfoArr = gd_info();
		     if(($gdinfoArr['JPEG Support'] == 1) or ($gdinfoArr['JPG Support'] == 1))
		     {
		     	$gd_jpg = 1;
		     }
			 $lists['gd'] = 1;
			 $lists['gd_jpg'] = $gd_jpg;
		}
		else
		{
			 $gd = 0;
			 $lists['gd'] = 0;
			 $lists['gd_jpg'] = 0;
		}

		$lists['statistic'] =  [
            'stats' => [
                'total_properties' => self::getTotalProperties(),
                'featured_properties' => self::getFeaturedProperties(),
                'total_agents' => self::getTotalAgents(),
                'total_companies' => self::getTotalCompanies(),
                'total_categories' => self::getTotalCategories(),
                'total_types' => self::getTotalTypes(),
                'total_value' => self::getTotalPropertyValue(),
                'average_price' => self::getAveragePropertyPrice(),
                'pending_approvals' => self::getPendingApprovals(),
				'total_requests' => self::getTotalRequests(),
				'total_favorites' => self::getTotalFav(),
				'properties_in_month' => self::getPropertiesInMonth(),
            ],
            'recent_properties' => self::getRecentProperties(),
            'top_viewed' => self::getTopViewedProperties(),
            'properties_by_category' => self::getPropertiesByCategory(),
            'monthly_stats' => self::getMonthlyPropertyStats(),
            'top_agents' => self::getTopAgents(),
            'system_activity' => self::getSystemActivity()
        ];

		$lists['categories_chart'] = self::getCategoriesChartData();

		$lists['property_types_chart'] = self::getPropertyTypesChartData();
		
		$lists['version']			= self::checkingVersion();

		$db->setQuery("Select count(id) from #__osrs_configuration where fieldname = 'show_update_available_message_in_dashboard'");
		$count = (int) $db->loadResult();
		if($count == 0)
		{
			$db->setQuery("Insert into #__osrs_configuration (id, fieldname, fieldvalue) values (NULL,'show_update_available_message_in_dashboard',1)");
			$db->execute();
			$configClass['show_update_available_message_in_dashboard'] = 1;
		}
		if ($lists['version']['status'] == 2 && $configClass['show_update_available_message_in_dashboard'] == 1)
		{
			Factory::getApplication()->enqueueMessage(
				Text::sprintf('OS_UPDATE_AVAILABLE', 'index.php?option=com_installer&view=update', $lists['version']['version'])
			);
		}
		
		HTML_OspropertyCpanel::cpanelHTML($option,$lists,$countries);
	}

	static function getPropertyTypesChartData()
    {
        $db = Factory::getContainer()->get('db');
        
        try {
            // Query property types với property count
            $query = $db->getQuery(true)
                ->select([
                    'pt.id',
                    'pt.type_name',
                    'pt.type_alias',
                    'pt.published',
                    'pt.ordering',
                    'COUNT(p.id) as property_count'
                ])
                ->from($db->quoteName('#__osrs_types', 'pt'))
                ->leftJoin($db->quoteName('#__osrs_properties', 'p') . ' ON pt.id = p.pro_type AND p.published = 1')
                ->where($db->quoteName('pt.published') . ' = 1')
                ->group([
                    'pt.id',
                    'pt.type_name', 
                    'pt.type_alias',
                    'pt.published',
                    'pt.ordering'
                ])
                ->order('property_count DESC, pt.ordering ASC');

            $db->setQuery($query);
            $results = $db->loadObjectList();
            
            $labels = [];
            $values = [];
            $colors = [
                '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF',
                '#FF9F40', '#FF6B6B', '#4ECDC4', '#45B7D1', '#96CEB4',
                '#FFEAA7', '#DDA0DD', '#98D8C8', '#F7DC6F', '#BB8FCE',
                '#85C1E9', '#F8C471', '#82E0AA', '#F1948A', '#D7BDE2'
            ];
            
            $colorIndex = 0;
            $chartColors = [];
            $hoverColors = [];
            
            foreach ($results as $row) {
                $labels[] = $row->type_name;
                $values[] = (int)$row->property_count;
                $chartColors[] = $colors[$colorIndex % count($colors)];
                // Tạo hover color sáng hơn
                $hoverColors[] = self::lightenColor($colors[$colorIndex % count($colors)], 20);
                $colorIndex++;
            }
            
            // Nếu không có properties, lấy tất cả property types với giá trị mặc định
            if (empty($labels)) {
                $query = $db->getQuery(true)
                    ->select(['type_name'])
                    ->from($db->quoteName('#__osrs_property_types'))
                    ->where($db->quoteName('published') . ' = 1')
                    ->order('ordering ASC');
                
                $db->setQuery($query);
                $results = $db->loadObjectList();
                
                foreach ($results as $row) {
                    $labels[] = $row->type_name;
                    $values[] = 1;
                    $chartColors[] = $colors[$colorIndex % count($colors)];
                    $hoverColors[] = self::lightenColor($colors[$colorIndex % count($colors)], 20);
                    $colorIndex++;
                }
            }
            
            return [
                'success' => true,
                'labels' => $labels,
                'values' => $values,
                'colors' => $chartColors,
                'hoverColors' => $hoverColors,
                'total' => array_sum($values)
            ];
            
        } catch (Exception $e) {
            return [
                'success' => false,
                'error' => $e->getMessage(),
                'labels' => [],
                'values' => [],
                'colors' => [],
                'hoverColors' => []
            ];
        }
    }
    
    /**
     * Làm sáng màu cho hover effect
     */
    static function lightenColor($color, $percent) {
        // Remove # if present
        $color = ltrim($color, '#');
        
        // Convert to RGB
        $r = hexdec(substr($color, 0, 2));
        $g = hexdec(substr($color, 2, 2));
        $b = hexdec(substr($color, 4, 2));
        
        // Lighten
        $r = min(255, $r + ($percent * 255 / 100));
        $g = min(255, $g + ($percent * 255 / 100));
        $b = min(255, $b + ($percent * 255 / 100));
        
        // Convert back to hex
        return '#' . str_pad(dechex($r), 2, '0', STR_PAD_LEFT) . 
                    str_pad(dechex($g), 2, '0', STR_PAD_LEFT) . 
                    str_pad(dechex($b), 2, '0', STR_PAD_LEFT);
    }

	static function getCategoriesChartData()
    {
        $db = Factory::getContainer()->get('db');
        
        try {
            // Query categories với property count
            $query = $db->getQuery(true)
                ->select([
                    'c.id',
                    'c.category_name',
                    'c.category_alias',
                    'c.published',
                    'c.ordering',
                    'COUNT(p.id) as property_count'
                ])
                ->from($db->quoteName('#__osrs_categories', 'c'))
                ->leftJoin($db->quoteName('#__osrs_properties', 'p') . ' ON c.id = p.category_id AND p.published = 1')
                ->where($db->quoteName('c.published') . ' = 1')
                ->group([
                    'c.id',
                    'c.category_name', 
                    'c.category_alias',
                    'c.published',
                    'c.ordering'
                ])
                ->order('c.ordering ASC, property_count DESC');

            $db->setQuery($query);
            $results = $db->loadObjectList();
            
            $categories = [];
            $values = [];
            $colors = [
                '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF',
                '#FF9F40', '#FF6B6B', '#4ECDC4', '#45B7D1', '#96CEB4',
                '#FFEAA7', '#DDA0DD', '#98D8C8', '#F7DC6F', '#BB8FCE'
            ];
            
            $colorIndex = 0;
            $chartColors = [];
            
            foreach ($results as $row) {
                $categories[] = $row->category_name;
                $values[] = (int)$row->property_count;
                $chartColors[] = $colors[$colorIndex % count($colors)];
                $colorIndex++;
            }
            
            // Nếu không có properties, lấy tất cả categories với giá trị mặc định
            if (empty($categories)) {
                $query = $db->getQuery(true)
                    ->select(['category_name'])
                    ->from($db->quoteName('#__osrs_categories'))
                    ->where($db->quoteName('published') . ' = 1')
                    ->order('ordering ASC');
                
                $db->setQuery($query);
                $results = $db->loadObjectList();
                
                foreach ($results as $row) {
                    $categories[] = $row->category_name;
                    $values[] = 1;
                    $chartColors[] = $colors[$colorIndex % count($colors)];
                    $colorIndex++;
                }
            }
            
            return [
                'success' => true,
                'categories' => $categories,
                'values' => $values,
                'colors' => $chartColors,
                'total' => array_sum($values)
            ];
            
        } catch (Exception $e) {
            return [
                'success' => false,
                'error' => $e->getMessage(),
                'categories' => [],
                'values' => [],
                'colors' => []
            ];
        }
    }
    
    /**
     * AJAX handler cho categories chart data
     */
    static function getCategoriesDataAjax()
    {
        $data = self::getCategoriesChartData();
        
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }

	public static function getPropertiesInMonth()
	{
		$db = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('COUNT(*)')
			->from($db->quoteName('#__osrs_properties'))
			->where($db->quoteName('published') . ' = 1')
			->where($db->quoteName('approved') . ' = 1')
			->where('MONTH(created) = MONTH(CURRENT_DATE())')
			->where('YEAR(created) = YEAR(CURRENT_DATE())');
		
		$db->setQuery($query);
		return $db->loadResult();
	}

	public static function getTotalFav()
	{
		$db = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('COUNT(*)')
			->from($db->quoteName('#__osrs_favorites'));
		
		$db->setQuery($query);
		return $db->loadResult();
	}

	public static function getTotalRequests()
	{
		$db = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('COUNT(*)')
			->from($db->quoteName('#__osrs_request_logs'));;
		
		$db->setQuery($query);
		return $db->loadResult();
	}
	
	// Get total properties count

	public static function getTotalProperties()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName( '#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }
    
    // Get featured properties count
    public static function getFeaturedProperties()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName( '#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 1')
            ->where($db->quoteName('isFeatured') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }

	public static function getTotalAgents()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName('#__osrs_agents'))
            ->where($db->quoteName('published') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }
    
    // Get total companies count
    public static function getTotalCompanies()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName('#__osrs_companies'))
            ->where($db->quoteName('published') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }
    
    // Get total categories count
    public static function getTotalCategories()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName('#__osrs_categories'))
            ->where($db->quoteName('published') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }

    // Get total categories count
    public static function getTotalTypes()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName('#__osrs_types'))
            ->where($db->quoteName('published') . ' = 1');
        
        $db->setQuery($query);
        return $db->loadResult();
    }
    
    // Get total property value
    public static function getTotalPropertyValue()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('SUM(price)')
            ->from($db->quoteName('#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 1')
            ->where($db->quoteName('price') . ' > 0');
        
        $db->setQuery($query);
        return $db->loadResult() ?: 0;
    }
    
    // Get average property price
    public static function getAveragePropertyPrice()
    {
		$db = Factory::getContainer()->get('db');
        $query = $db->getQuery(true)
            ->select('AVG(price)')
            ->from($db->quoteName('#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 1')
            ->where($db->quoteName('price') . ' > 0');
        
        $db->setQuery($query);
        return $db->loadResult() ?: 0;
    }

	// Get recent properties
    public static function getRecentProperties($limit = 5)
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('p.*, a.name as agent_name, c.category_name')
            ->from($db->quoteName('#__osrs_properties', 'p'))
            ->leftJoin($db->quoteName('#__osrs_agents', 'a') . ' ON p.agent_id = a.id')
            ->leftJoin($db->quoteName('#__osrs_categories', 'c') . ' ON p.category_id = c.id')
            ->where($db->quoteName('p.published') . ' = 1')
            ->where($db->quoteName('p.approved') . ' = 1')
            ->order($db->quoteName('p.created') . ' DESC')
            ->setLimit($limit);
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }
    
    // Get top viewed properties
    public static function getTopViewedProperties($limit = 5)
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('p.*, a.name as agent_name, c.category_name')
            ->from($db->quoteName('#__osrs_properties', 'p'))
            ->leftJoin($db->quoteName('#__osrs_agents', 'a') . ' ON p.agent_id = a.id')
            ->leftJoin($db->quoteName('#__osrs_categories', 'c') . ' ON p.category_id = c.id')
            ->where($db->quoteName('p.published') . ' = 1')
            ->where($db->quoteName('p.approved') . ' = 1')
            ->order($db->quoteName('p.hits') . ' DESC')
            ->setLimit($limit);
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }
    
    // Get properties by category
    public static function getPropertiesByCategory()
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('c.category_name, COUNT(p.id) as property_count')
            ->from($db->quoteName('#__osrs_categories', 'c'))
            ->leftJoin($db->quoteName('#__osrs_properties', 'p') . ' ON c.id = p.category_id AND p.published = 1 AND p.approved = 1')
            ->where($db->quoteName('c.published') . ' = 1')
            ->group($db->quoteName('c.id'))
            ->order('property_count DESC');
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }
    
    // Get monthly property statistics
    public static function getMonthlyPropertyStats()
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('MONTH(created) as month, YEAR(created) as year, COUNT(*) as count')
            ->from($db->quoteName('#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 1')
            ->where('created >= DATE_SUB(NOW(), INTERVAL 12 MONTH)')
            ->group('YEAR(created), MONTH(created)')
            ->order('year DESC, month DESC');
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }
    
    // Get top agents by properties
    public static function getTopAgents($limit = 5)
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('a.*, COUNT(p.id) as property_count, comp.company_name')
            ->from($db->quoteName('#__osrs_agents', 'a'))
            ->leftJoin($db->quoteName('#__osrs_properties', 'p') . ' ON a.id = p.agent_id AND p.published = 1 AND p.approved = 1')
            ->leftJoin($db->quoteName('#__osrs_companies', 'comp') . ' ON a.company_id = comp.id')
            ->where($db->quoteName('a.published') . ' = 1')
            ->group($db->quoteName('a.id'))
            ->order('property_count DESC')
            ->setLimit($limit);
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }
    
    // Get pending approvals
    public static function getPendingApprovals()
    {
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select('COUNT(*)')
            ->from($db->quoteName('#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->where($db->quoteName('approved') . ' = 0');
        
        $db->setQuery($query);
        return $db->loadResult();
    }
    
    // Get system activity (recent actions)
    public static function getSystemActivity($limit = 10)
    {
        // Get recent properties as activity
        $db = Factory::getContainer()->get('db'); 
		$query = $db->getQuery(true)
            ->select("'property' as type, pro_name as title, created as date, created_by as user_id, 'added' as action")
            ->from($db->quoteName('#__osrs_properties'))
            ->where($db->quoteName('published') . ' = 1')
            ->order($db->quoteName('created') . ' DESC')
            ->setLimit($limit);
        
        $db->setQuery($query);
        return $db->loadObjectList();
    }

    public static function getTimeAgo($dateString) {
        // Tạo Joomla Date object
        $date = Factory::getDate($dateString);
        $now = Factory::getDate();
        
        // Tính diff theo giây
        $diff = $now->toUnix() - $date->toUnix();
        
        // Nếu trong tương lai hoặc vừa tạo
        if ($diff <= 0) {
            return Text::_('OS_JUST_NOW');
        }
        
        // Tính toán intervals
        $intervals = array(
            array('label' => 'YEAR', 'seconds' => 31536000),   // 365 * 24 * 60 * 60
            array('label' => 'MONTH', 'seconds' => 2592000),   // 30 * 24 * 60 * 60  
            array('label' => 'WEEK', 'seconds' => 604800),     // 7 * 24 * 60 * 60
            array('label' => 'DAY', 'seconds' => 86400),       // 24 * 60 * 60
            array('label' => 'HOUR', 'seconds' => 3600),       // 60 * 60
            array('label' => 'MINUTE', 'seconds' => 60),
            array('label' => 'SECOND', 'seconds' => 1)
        );
        
        foreach ($intervals as $interval) {
            $count = floor($diff / $interval['seconds']);
            if ($count >= 1) {
                if ($count == 1) {
                    return Text::sprintf('OS_TIME_AGO_SINGULAR', 
                        Text::_('OS_' . $interval['label']));
                } else {
                    return Text::sprintf('OS_TIME_AGO_PLURAL', 
                        $count, Text::_('OS_' . $interval['label'] . 'S'));
                }
            }
        }
        
        return Text::_('OS_JUST_NOW');
    }

	public static function checkingVersion()
	{
		global $mainframe;
		// Get the caching duration.
		$component     = ComponentHelper::getComponent('com_installer');
		$params        = $component->params;
		$cache_timeout = $params->get('cachetimeout', 6, 'int');
		$cache_timeout = 3600 * $cache_timeout;
		// Get the minimum stability.
		$minimum_stability = $params->get('minimum_stability', Updater::STABILITY_STABLE, 'int');
		BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_installer/models');
		/** @var InstallerModelUpdate $model */
		
		$model = Factory::getApplication()->bootComponent('com_installer')->getMVCFactory()->createModel('Update', 'Administrator', ['ignore_request' => true]);
		
		$model->purge();
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true);
		$query->select('extension_id')
			->from('#__extensions')
			->where('`type` = "package"')
			->where('`element` = "pkg_osproperty"');
		$db->setQuery($query);
		$eid = (int) $db->loadResult();

		$result['status'] = 0;

		if ($eid)
		{
			$ret = Updater::getInstance()->findUpdates($eid, $cache_timeout, $minimum_stability);
			if ($ret)
			{
				$model->setState('list.start', 0);
				$model->setState('list.limit', 0);
				$model->setState('filter.extension_id', $eid);
				$updates          = $model->getItems();
				$result['status'] = 2;

				if (count($updates))
				{
					$result['message'] = Text::sprintf('OS_UPDATE_CHECKING_UPDATEFOUND', $updates[0]->version);
					$result['version'] = $updates[0]->version;
				}
				else
				{
					$result['message'] = Text::sprintf('OS_UPDATE_CHECKING_UPDATEFOUND', null);
				}
			}
			else
			{
				$result['status']  = 1;
				$result['message'] = Text::_('OS_UPDATE_CHECKING_UPTODATE');
			}
		}
		return $result;
	}
}
?>