<?php
/**
 * @package     MPF
 * @subpackage  View
 *
 * @copyright   Copyright (C) 2016 - 2026 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 * Layout variables
 *
 * @var string $name
 * @var string $title
 * @var string $description
 * @var string $width
 * @var int    $height
 * @var int    $cols
 * @var int    $rows
 */

$editor = Editor::getInstance(Factory::getApplication()->get('editor'));
?>

<div class="control-group">
	<div class="control-label">
		<?php
		if (strlen($description ?? '') > 0)
		{
			echo OSMembershipHelperHtml::getFieldLabel($name, Text::_($title), Text::_($description));
		}
		else
		{
			echo Text::_($title);
		}
		?>
	</div>
	<div class="controls">
		<?php echo $editor->display($name, $this->item->{$name}, $width, $height , $cols , $rows) ; ?>
	</div>
</div>