<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\MembershipPro\Admin\Event\Subscription;

class AfterGenerateInvoice extends \MPFEventBase
{
	protected $requiredArguments = ['row', 'invoiceNumber'];

	/**
	 * Get the subscription record associated to the invoice
	 *
	 * @return \OSMembershipTableSubscriber
	 */
	public function getSubscription()
	{
		return $this->getArgument('row');
	}

	/**
	 * Get the invoice number of the generated invoice
	 *
	 * @return string
	 */
	public function getInvoiceNumber()
	{
		return $this->getArgument('invoiceNumber');
	}
}