<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2018-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Alledia\OSDownloads\Pro\MailingList\AcyMailing;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die();

// phpcs:enable PSR1.Files.SideEffects

class V5 extends AbstractVersion
{
    /**
     * @inheritDoc
     */
    public function getLists(): array
    {
        /** @var \listClass $listClass */
        $listClass = acymailing_get('class.list');

        $lists = $listClass->getLists();

        array_walk(
            $lists,
            function (object $row) {
                $row->id = $row->listid;
            }
        );

        return $lists;
    }

    /**
     * @inheritDoc
     */
    public function getUser(string $email, int $confirmed, ?int $userId): object
    {
        /** @var \subscriberClass $acyUser */
        $acyUser = acymailing_get('class.subscriber');

        $user = $acyUser->get($email);
        if ($user == false) {
            $user = (object)[
                'email'     => $email,
                'confirmed' => $confirmed,
            ];

            $acyUserId = $acyUser->save($user);
            $user      = $acyUser->get($acyUserId);
        }

        if ($user && $userId && $user->userid != $userId) {
            $user->userid = $userId;
            $acyUser->save($user);
        }

        return $user;
    }

    /**
     * @inheritDoc
     */
    public function subscribe(object $user, array $lists): bool
    {
        $success = true;

        if (!empty($user->subid)) {
            $subscriptions = array_flip(array_filter($lists));
            foreach ($subscriptions as &$subscription) {
                $subscription = [
                    'status' => 1,
                ];
            }

            if ($subscriptions) {
                /** @var \subscriberClass $acyUser */
                $acyUser = acymailing_get('class.subscriber');

                $success = $acyUser->saveSubscription($user->subid, $subscriptions);
            }
        }

        return $success;
    }
}
