<?php
/*------------------------------------------------------------------------
	# install.oscalendar.php - OS Calendar
	# ------------------------------------------------------------------------
	# author    Dang Thuc Dam
	# copyright Copyright (C) 2010 joomdonation.com. All Rights Reserved.
	# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
	# Websites: http://www.joomdonation.com
	# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die('Restricted access');
error_reporting(E_ERROR | E_PARSE);

class com_oscalendarInstallerScript {
	public static $languageFiles = array('en-GB.com_oscalendar.ini');
	
	/**
	 * Method to run before installing the component	 
	 */
	function preflight($type, $parent)
	{
		//Backup the old language file
		foreach (self::$languageFiles as $languageFile) {
			if (JFile::exists(JPATH_ROOT.'/language/en-GB/'.$languageFile)) {
				JFile::copy(JPATH_ROOT.'/language/en-GB/'.$languageFile, JPATH_ROOT.'/language/en-GB/bak.'.date('d-m-Y',time()).$languageFile);
			}
		}				
	}	
	
	function install($parent)
	{
		com_install() ;
	}
	
	function update($parent)
	{
		com_install();
	}
}

function com_install() {
	jimport('joomla.filesystem.file') ;
    jimport('joomla.filesystem.folder') ;
    define('DS',DIRECTORY_SEPARATOR);
    $db = & JFactory::getDBO(); 
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_configuration'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_configuration` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `config_key` varchar(225) DEFAULT NULL,
					  `config_value` text,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }	
    
    $db->setQuery("Select count(id) from #__oscalendar_configuration");
    $count = $db->loadResult();
    if($count == 0){
	    $configSql = JPATH_ADMINISTRATOR.'/components/com_oscalendar/sql/config.oscalendar.sql' ;
		$sql = file_get_contents($configSql) ;
		$queries = $db->splitSql($sql);
		if (count($queries)) {
			foreach ($queries as $query) {
			$query = trim($query);
			if ($query != '' && $query[0] != '#') {
					$db->setQuery($query);
					$db->execute();						
				}	
			}
		}
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_discount'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_discount` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `start_date` date DEFAULT NULL,
					  `end_date` date DEFAULT NULL,
					  `discount` decimal(12,2) DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_fields'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_fields` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `field_type` tinyint(1) NOT NULL DEFAULT '0',
					  `price_for_order` tinyint(1) NOT NULL DEFAULT '0',
					  `field_label` varchar(255) NOT NULL,
					  `field_free` tinyint(1) NOT NULL DEFAULT '0',
					  `ordering` int(11) NOT NULL DEFAULT '0',
					  `published` tinyint(1) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SHOW COLUMNS FROM `#__oscalendar_fields`");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
		if(!in_array('price_for_order',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_fields` ADD `price_for_order` tinyint(1) NOT NULL DEFAULT '0' AFTER `field_type`;");
			$db->execute();
		}
    }
    
	$db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_available'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_available` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `pid` int(11) DEFAULT NULL,
					  `rid` int(11) NOT NULL DEFAULT '0',
					  `availtype` tinyint(1) unsigned DEFAULT NULL,
					  `checkdate` date DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }

    $db->setQuery("SHOW COLUMNS FROM `#__oscalendar_available`");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
		if(!in_array('rid',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_available` ADD `rid` int(11) NOT NULL DEFAULT '0' AFTER `pid`;");
			$db->execute();
		}
    }

	$db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_booking'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_booking` (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `pid` int(11) DEFAULT NULL,
				  `rid` int(11) NOT NULL DEFAULT '0',
				  `nroom` tinyint(3) NOT NULL DEFAULT '1',
				  `book_from` date DEFAULT NULL,
				  `book_to` date DEFAULT NULL,
				  `payment_method` varchar(100) DEFAULT NULL,
				  `hour_from` int(2) NOT NULL DEFAULT '0',
				  `hour_to` int(2) NOT NULL DEFAULT '0',
				  `room_fee` decimal(10,2) NOT NULL,
				  `amount` decimal(10,2) DEFAULT NULL,
				  `total_amount` decimal(12,2) NOT NULL,
				  `deposit` decimal(10,2) DEFAULT NULL,
				  `tax` decimal(10,2) DEFAULT NULL,
				  `total` decimal(10,2) NOT NULL,
				  `curr` varchar(10) NOT NULL,
				  `language_prefix` varchar(100) NOT NULL,
				  `user_id` int(11) NOT NULL DEFAULT '0',
				  `name` varchar(255) DEFAULT NULL,
				  `email` varchar(255) DEFAULT NULL,
				  `phone` varchar(50) DEFAULT NULL,
				  `country` varchar(255) NOT NULL,
				  `nAdults` tinyint(2) NOT NULL DEFAULT '0',
				  `nChilds` tinyint(2) NOT NULL DEFAULT '0',
				  `notes` text,
				  `card_number` varchar(50) NOT NULL,
				  `card_type` varchar(50) NOT NULL,
				  `expiry_month` int(2) NOT NULL,
				  `expiry_year` int(4) NOT NULL,
				  `card_holder` varchar(100) NOT NULL,
				  `cvv_code` varchar(10) NOT NULL,
				  `send_email` tinyint(1) NOT NULL DEFAULT '0',
				  `coupon_id` int(11) NOT NULL DEFAULT '0',
				  `order_discount` decimal(12,2) NOT NULL,
				  `bank_id` int(11) NOT NULL DEFAULT '0',
				  `order_status` char(1) DEFAULT NULL,
				  `order_date` datetime NOT NULL,
				  `transaction_id` varchar(255) NOT NULL,
				  PRIMARY KEY (`id`)
				) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SHOW COLUMNS FROM `#__oscalendar_booking`");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
		if(!in_array('rid',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `rid` int(11) NOT NULL DEFAULT '0' AFTER `pid`;");
			$db->execute();
		}
		if(!in_array('nroom',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `nroom` tinyint(3) NOT NULL DEFAULT '1' AFTER `rid`;");
			$db->execute();
		}
		if(!in_array('total_amount',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `total_amount` decimal(12,2) NOT NULL AFTER `amount`;");
			$db->execute();
		}
		if(!in_array('order_discount',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `order_discount` decimal(12,2) NOT NULL AFTER `coupon_id`;");
			$db->execute();
		}
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_field_options'");
    $count = $db->loadResult();
    if($count == 0){ 
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_field_options` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `field_id` int(11) NOT NULL DEFAULT '0',
					  `field_option` varchar(255) NOT NULL,
					  `option_free` tinyint(1) NOT NULL,
					  `additional_price` decimal(12,2) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_order_field_options'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_options` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `order_id` int(11) DEFAULT NULL,
					  `field_id` int(11) DEFAULT NULL,
					  `option_id` int(11) DEFAULT NULL,
					  `option_price` decimal(12,2) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_order_field_price'");
    $count = $db->loadResult();
    if($count == 0){ 
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_price` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `order_id` int(11) DEFAULT NULL,
					  `field_id` int(11) DEFAULT NULL,
					  `field_price` decimal(12,2) DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_order_field_values'");
    $count = $db->loadResult();
    if($count == 0){ 
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_order_field_values` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `order_id` int(11) DEFAULT NULL,
					  `field_id` int(11) DEFAULT NULL,
					  `field_value` text,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_plugins'");
    $count = $db->loadResult();
    if($count == 0){ 
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_plugins` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `name` varchar(255) DEFAULT NULL,
					  `title` varchar(100) DEFAULT NULL,
					  `author` varchar(250) DEFAULT NULL,
					  `creation_date` datetime DEFAULT NULL,
					  `copyright` varchar(255) DEFAULT NULL,
					  `license` varchar(255) DEFAULT NULL,
					  `author_email` varchar(50) DEFAULT NULL,
					  `author_url` varchar(50) DEFAULT NULL,
					  `version` varchar(50) DEFAULT NULL,
					  `description` varchar(255) DEFAULT NULL,
					  `params` text,
					  `ordering` int(11) DEFAULT NULL,
					  `published` tinyint(3) unsigned DEFAULT NULL,
					  `support_recurring_subscription` tinyint(4) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("Select count(id) from #__oscalendar_plugins where name like 'os_paypal'");
    $count = $db->loadResult();
    if($count == 0){
    	$db->setQuery("INSERT INTO `#__oscalendar_plugins` (`id`, `name`, `title`, `author`, `creation_date`, `copyright`, `license`, `author_email`, `author_url`, `version`, `description`, `params`, `ordering`, `published`, `support_recurring_subscription`) VALUES(NULL, 'os_paypal', 'Paypal', 'Dang Thuc Dam', '2012-11-01 00:00:00', 'Copyright 2007-2012 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'contact@joomdonation.com', 'www.joomdonation.com', '1.0', 'Paypal Payment Plugin For OS Calendar Extension', 'paypal_mode=\"0\"\npaypal_id=\"\"\npaypal_currency=\"USD\"', 1, 1, 1);");
    	$db->execute();
    }
    
    $db->setQuery("Select count(id) from #__oscalendar_plugins where name like 'os_offline'");
    $count = $db->loadResult();
    if($count == 0){
    	$db->setQuery("INSERT INTO `#__oscalendar_plugins` (`id`, `name`, `title`, `author`, `creation_date`, `copyright`, `license`, `author_email`, `author_url`, `version`, `description`, `params`, `ordering`, `published`, `support_recurring_subscription`) VALUES(NULL, 'os_offline', 'Offline Payment', 'Dang Thuc Dam', '2012-11-01 00:00:00', 'Copyright 2007-2012 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'contact@joomdonation.com', 'www.joomdonation.com', '1.0', 'Offline Payment Plugin For OS Calendar Extension', 'order_status=\"1\"', 2, 1, 0);");
    	$db->execute();
    }
    
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_profile'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_profile` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `user_id` int(11) NOT NULL DEFAULT '0',
					  `name` varchar(255) DEFAULT NULL,
					  `email` varchar(100) DEFAULT NULL,
					  `phone` varchar(50) DEFAULT NULL,
					  `country` varchar(100) DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
     $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_order_temp'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_order_temp` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `user_data` varchar(255) DEFAULT NULL,
					  `pid` int(11) DEFAULT NULL,
					  `rid` int(11) DEFAULT NULL,
					  `nroom` tinyint(3) unsigned DEFAULT NULL,
					  `adult` tinyint(3) unsigned DEFAULT NULL,
					  `child` tinyint(3) unsigned DEFAULT NULL,
					  `book_from` date DEFAULT NULL,
					  `book_to` date DEFAULT NULL,
					  `sub_total` decimal(12,2) DEFAULT NULL,
					  `curr` int(11) NOT NULL,
					  `created_on` int(11) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_order_temp_field_options'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_order_temp_field_options` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `order_id` int(11) DEFAULT NULL,
						  `field_id` int(11) DEFAULT NULL,
						  `option_id` int(11) DEFAULT NULL,
						  `additional_price` decimal(12,2) DEFAULT NULL,
						  PRIMARY KEY (`id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_rooms'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_rooms` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `pid` int(11) DEFAULT NULL,
					  `room_number` tinyint(3) unsigned DEFAULT '0',
					  `room_name` varchar(255) DEFAULT NULL,
					  `room_desc` varchar(255) DEFAULT NULL,
					  `room_image` varchar(100) DEFAULT NULL,
					  `max_adult` tinyint(3) unsigned DEFAULT '0',
					  `max_child` tinyint(3) unsigned DEFAULT '0',
					  `ordering` int(11) NOT NULL,
					  `published` tinyint(1) unsigned DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_room_prices'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_room_prices` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `rid` int(11) DEFAULT NULL,
					  `title` varchar(255) DEFAULT NULL,
					  `price_from` date DEFAULT NULL,
					  `price_to` date DEFAULT NULL,
					  `min_booking` tinyint(3) unsigned DEFAULT NULL,
					  `price` decimal(12,2) DEFAULT NULL,
					  `curr` int(11) DEFAULT NULL,
					  `allday` tinyint(1) unsigned DEFAULT '0',
					  `mon` tinyint(1) unsigned DEFAULT '0',
					  `tue` tinyint(1) unsigned DEFAULT '0',
					  `wed` tinyint(1) unsigned DEFAULT '0',
					  `thu` tinyint(1) unsigned DEFAULT '0',
					  `fri` tinyint(1) unsigned DEFAULT '0',
					  `sat` tinyint(1) unsigned DEFAULT '0',
					  `sun` tinyint(1) unsigned DEFAULT '0',
					  `created_on` datetime DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_urls'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_urls` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `md5_key` text,
					  `query` text,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }

	$db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_emails'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_emails` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `email_key` varchar(255) NOT NULL,
					  `email_title` varchar(255) NOT NULL,
					  `email_content` text NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SHOW COLUMNS FROM #__oscalendar_emails");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
	    if(in_array('email_subject',$fieldArr)){
			$db->setQuery(" ALTER TABLE `#__oscalendar_emails` DROP `email_subject` ;");
			$db->execute();
		}
		if(!in_array('email_title',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_emails` ADD `email_title` varchar(255) NOT NULL AFTER `email_key`;");
			$db->execute();
		}
		if(!in_array('published',$fieldArr)){
			$db->setQuery("ALTER TABLE `#__oscalendar_emails` ADD `published` TINYINT(11) NOT NULL DEFAULT '0' AFTER `email_content`;");
			$db->execute();
		}
    }
     
    $db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'payment_message'");
   	$count = $db->loadResult();
   	if($count > 0){
   		$db->setQuery("Delete from #__oscalendar_emails where email_key like 'payment_message'");
   		$db->execute();
   	}
    
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'confirmation_email'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'confirmation_email', 'Confirmation message', '<p>You''ve just made a booking request on property of our site. </p>\r\n<p>{booking_details}<br /><br />Thank you, we will contact you ASAP.</p>', 1);");
   		$db->execute();
   	}else{
   		$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'confirmation_email' and email_title = ''");
   		$count = $db->loadResult();
   		if($count > 0){
   			$db->setQuery("Update #__oscalendar_emails set email_title = 'Confirmation message',published = '1' where email_key like 'confirmation_email'");
   			$db->execute();
   		}
   	}
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'confirmation_email' and email_content like '%{CancelURL}%'");
   	$count = $db->loadResult();
   	if($count > 0){
   		$db->setQuery("Delete from #__oscalendar_emails where email_key like 'confirmation_email'");
   		$db->execute();
   		
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'confirmation_email', 'Confirmation message', '<p>You''ve just made a booking request on property of our site. </p>\r\n<p>{booking_details}<br /><br />Thank you, we will contact you ASAP.</p>', 1);");
   		$db->execute();
   	}
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'admin_notification'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'admin_notification', 'A customer has just booked your property', '<p>New booking request from your site</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}else{
   		$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'admin_notification' and email_title = ''");
   		$count = $db->loadResult();
   		if($count > 0){
   			$db->setQuery("Update #__oscalendar_emails set email_title = 'A customer has just booked your property',published = '1' where email_key like 'admin_notification'");
   			$db->execute();
   		}
   	}
   	
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'agent_notification'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'agent_notification', 'A customer has just booked your property', '<p>New booking request from your site</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}else{
   		$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'agent_notification' and email_title = ''");
   		$count = $db->loadResult();
   		if($count > 0){
   			$db->setQuery("Update #__oscalendar_emails set email_title = 'A customer has just booked your property',published = '1' where email_key like 'agent_notification'");
   			$db->execute();
   		}
   	}
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'agent_notification' and email_content like '%{Name}%'");
   	$count = $db->loadResult();
   	if($count > 0){
   		$db->setQuery("Delete from #__oscalendar_emails where email_key like 'agent_notification'");
   		$db->execute();
   		
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'agent_notification', 'A customer has just booked your property', '<p>New booking request from your site</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}
   	
   	
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'order_status_change'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'order_status_change', 'Your booking status has been changed', '<p>Your booking status of order {order_id} has been changed to {new_status}</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}else{
   		$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'order_status_change' and email_title = ''");
   		$count = $db->loadResult();
   		if($count > 0){
   			$db->setQuery("Update #__oscalendar_emails set email_title = 'Your booking status has been changed',published = '1' where email_key like 'order_status_change'");
   			$db->execute();
   		}
   	}
   	
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'order_status_change' and email_content like '%{BookingID}%'");
   	$count = $db->loadResult();
   	if($count > 0){
   		$db->setQuery("Delete from #__oscalendar_emails where email_key like 'order_status_change'");
   		$db->execute();
   		
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'order_status_change', 'Your booking status has been changed', '<p>Your booking status of order {order_id} has been changed to {new_status}</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}
   	
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'cancel_notification_admin'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'cancel_notification_admin', 'Customer has cancelled the order', '<p>Hi Administrator,</p>\r\n<p>Customer has been cancalled the order [{order_id}]</p>\r\n<p>{booking_details}</p>', 1);");
   		$db->execute();
   	}
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'cancel_notification_agent'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'cancel_notification_agent', 'Customer has cancelled the order', '<p>Hi,</p>\r\n<p>Customer has cancelled the booking request on your property. </p>\r\n<p>{booking_details}</p>\r\n<p>Thanks</p>', 1);");
   		$db->execute();
   	}
   	
   	$db->setQuery("Select count(id) from #__oscalendar_emails where email_key like 'cancel_notification_customer'");
   	$count = $db->loadResult();
   	if($count == 0){
   		$db->setQuery("INSERT INTO `#__oscalendar_emails` (`id`, `email_key`, `email_title`, `email_content`,  `published`) VALUES(NULL, 'cancel_notification_customer', 'You have just cancelled the order [{order_id}]', '<p>Hi</p>\r\n<p>You have just cancelled the booking on property </p>\r\n<p>{booking_details}</p>\r\n<p>Thanks</p>', 1);");
   		$db->execute();
   	}
   	
   	$db->setQuery("SHOW COLUMNS FROM #__oscalendar_booking");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
    	if(!in_array('hour_from',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `hour_from` TINYINT(2) NOT NULL DEFAULT '0' AFTER `book_from` ;");
    		$db->execute();
    	}
    	if(!in_array('hour_to',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `hour_to` TINYINT(2) NOT NULL DEFAULT '0' AFTER `book_to` ;");
    		$db->execute();
    	}
    	if(!in_array('room_fee',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `room_fee` decimal(12,2) NOT NULL DEFAULT '0' AFTER `payment_method` ;");
    		$db->execute();
    	}
    	if(!in_array('total',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `total` decimal(12,2) NOT NULL DEFAULT '0' AFTER `tax` ;");
    		$db->execute();
    	}
    	if(!in_array('country',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `country` varchar(100) AFTER `phone` ;");
    		$db->execute();
    	}
    	if(!in_array('curr',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `curr` varchar(10) AFTER `total` ;");
    		$db->execute();
    	}
    	if(!in_array('language_prefix',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `language_prefix` varchar(100) AFTER `curr` ;");
    		$db->execute();
    	}
    	if(!in_array('user_id',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `user_id` INT(11) NOT NULL DEFAULT '0' AFTER `language_prefix` ;");
    		$db->execute();
    	}
    	if(!in_array('card_number',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `card_number` varchar(50) AFTER `notes` ;");
    		$db->execute();
    	}
    	if(!in_array('card_type',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `card_type` varchar(50) AFTER `card_number` ;");
    		$db->execute();
    	}
    	if(!in_array('expiry_month',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `expiry_month` int(2) NOT NULL DEFAULT '0' AFTER `card_type` ;");
    		$db->execute();
    	}
    	if(!in_array('expiry_year',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `expiry_year` int(4) NOT NULL DEFAULT '0' AFTER `expiry_month` ;");
    		$db->execute();
    	}
    	if(!in_array('card_holder',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `card_holder` varchar(50) AFTER `expiry_year` ;");
    		$db->execute();
    	}
    	if(!in_array('cvv_code',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `cvv_code` varchar(10) AFTER `card_holder` ;");
    		$db->execute();
    	}
    	if(!in_array('send_email',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `send_email` TINYINT(11) NOT NULL DEFAULT '0' AFTER `cvv_code` ;");
    		$db->execute();
    	}
    	if(!in_array('coupon_id',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `coupon_id` INT(11) NOT NULL DEFAULT '0' AFTER `send_email` ;");
    		$db->execute();
    	}
    	if(!in_array('bank_id',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_booking` ADD `bank_id` INT(11) NOT NULL DEFAULT '0' AFTER `coupon_id` ;");
    		$db->execute();
    	}
    }
    
	$db->setQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '$dbname' AND table_name = '".$prefix."oscalendar_room_prices'");
    $count = $db->loadResult();
    if($count == 0){ //the #__osrs_user_list tables doesn't exists
    	$db->setQuery("CREATE TABLE IF NOT EXISTS `#__oscalendar_room_prices` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `pid` int(11) NOT NULL DEFAULT '0',
					  `rid` int(11) DEFAULT NULL,
					  `title` varchar(255) DEFAULT NULL,
					  `price_from` date DEFAULT NULL,
					  `price_to` date DEFAULT NULL,
					  `min_booking` tinyint(3) unsigned DEFAULT NULL,
					  `price` decimal(12,2) DEFAULT NULL,
					  `curr` int(11) DEFAULT NULL,
					  `allday` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `mon` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `tue` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `wed` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `thu` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `fri` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `sat` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `sun` tinyint(1) unsigned zerofill DEFAULT NULL,
					  `allow_book_all` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_mon` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_tue` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_wed` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_thu` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_fri` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_sat` tinyint(1) NOT NULL DEFAULT '0',
					  `allow_sun` tinyint(1) NOT NULL DEFAULT '0',
					  `created_on` datetime DEFAULT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
    	$db->execute();
    }
    
    $db->setQuery("SHOW COLUMNS FROM #__oscalendar_room_prices");
	$fields = $db->loadObjectList();
    if(count($fields) > 0){
    	$fieldArr = array();
    	for($i=0;$i<count($fields);$i++){
    		$field = $fields[$i];
    		$fieldname = $field->Field;
    		$fieldArr[$i] = $fieldname;
    	}
    	if(!in_array('allow_book_all',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_book_all` tinyint(1) NOT NULL DEFAULT '0' AFTER `sun`");
    		$db->execute();
    	}
    	if(!in_array('allow_mon',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_mon` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_book_all`");
    		$db->execute();
    	}
    	if(!in_array('allow_tue',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_tue` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_mon`");
    		$db->execute();
    	}
    	if(!in_array('allow_wed',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_wed` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_tue`");
    		$db->execute();
    	}
    	if(!in_array('allow_thu',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_thu` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_wed`");
    		$db->execute();
    	}
    	if(!in_array('allow_fri',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_fri` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_thu`");
    		$db->execute();
    	}
    	if(!in_array('allow_sat',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_sat` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_fri`");
    		$db->execute();
    	}
    	if(!in_array('allow_sun',$fieldArr)){
    		$db->setQuery("ALTER TABLE `#__oscalendar_room_prices` ADD `allow_sun` tinyint(1) NOT NULL DEFAULT '0' AFTER `allow_sat`");
    		$db->execute();
    	}
    }
	
	$db->setQuery("SELECT COUNT(id) FROM #__oscalendar_configuration WHERE config_key like 'use_calendar'");
	$count = $db->loadResult();
	if(intval($count) == 0){
		$db->setQuery("INSERT INTO #__oscalendar_configuration (id,config_key,config_value) VALUES (NULL,'use_calendar','0')");
		$db->execute();
	}

	$db->setQuery("SELECT COUNT(id) FROM #__oscalendar_configuration WHERE config_key like 'allow_room'");
	$count = $db->loadResult();
	if(intval($count) == 0){
		$db->setQuery("INSERT INTO #__oscalendar_configuration (id,config_key,config_value) VALUES (NULL,'allow_room','1')");
		$db->execute();
	}
    
    //empty #__osrs_urls table
	$db->setQuery("Delete from #__oscalendar_urls");
	$db->execute();
	
	jimport('joomla.filesystem.file');
	jimport('joomla.filesystem.folder');
	
	$htmlfile = JPATH_ROOT.DS."components".DS."com_oscalendar".DS."index.html";
	if(!JFolder::exists(JPATH_ROOT.DS."images".DS."oscalendar")){
		JFolder::create(JPATH_ROOT.DS."images".DS."oscalendar");
		JFile::copy($htmlfile,JPATH_ROOT.DS."images".DS."oscalendar".DS."index.html");
	}
	if(!JFolder::exists(JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms")){
		JFolder::create(JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms");
		JFile::copy($htmlfile,JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS."index.html");
	}
	if(!JFolder::exists(JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS."thumb")){
		JFolder::create(JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS."thumb");
		JFile::copy($htmlfile,JPATH_ROOT.DS."images".DS."oscalendar".DS."rooms".DS."thumb".DS."index.html");
	}
}
?>