<?php
/*------------------------------------------------------------------------
# property.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// no direct access
defined('_JEXEC') or die;

class OSappscheduleProperty{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$pid	   = $mainframe->input->getInt('pid');
		$id		   = $mainframe->input->getInt('id',0);
		$cid	   = $mainframe->input->get('cid',array(),'array');
		$rid	   = $mainframe->input->getInt('rid',0);
		switch ($task){
			case "property_editconfig":
				OSappscheduleProperty::editConfig($pid,0);
			break;
			case "property_saveinfo":
				OSappscheduleProperty::saveConfig();
			break;
			case "property_pricemanage":
				OSappscheduleProperty::managePrice($pid);
			break;
			case "property_addprice":
				OSappscheduleProperty::editPrice($pid,0);
			break;
			case "property_editprice":
				OSappscheduleProperty::editPrice($pid,$cid[0]);
			break;
			case "property_saveprice":
				OSappscheduleProperty::savePrice(1);
			break;
			case "property_applyprice":
				OSappscheduleProperty::savePrice(0);
			break;
			case "property_gotopricelist":
				OSappscheduleProperty::gotoPrice();
			break;
			case "property_removeprices":
				OSappscheduleProperty::removePrices($cid);
			break;
			case "property_calendarmanage":
				OSappscheduleProperty::calendarManage($pid,$rid);
			break;
			case "property_available":
				OSappscheduleProperty::changeAvailable($pid,$rid,1);
			break;
			case "property_unavailable":
				OSappscheduleProperty::changeAvailable($pid,$rid,0);
			break;			
			case "property_cancel":
				$mainframe->redirect("index.php");
			break;
			case "property_availability":
				OSappscheduleProperty::availability($pid,$rid);
			break;
		}
	}
	
	/**
	 * Change status
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $status
	 */
	static function changeAvailable($pid,$rid,$status){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$cid1 = $mainframe->input->get('cid1',array(),'array');
		$cid2 = $mainframe->input->get('cid2',array(),'array');
		if(count($cid1) > 0){
			if($status == 0){
				for($i=0;$i<count($cid1);$i++){
					$date = $cid1[$i];
					$db->setQuery("Select count(id) from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '1'");
					$count = $db->loadResult();
					if($count == 0){
						$db->setQuery("INSERT INTO #__oscalendar_available (id,pid,rid,availtype,checkdate) VALUES (NULL,'$pid','$rid','1','$date')");
						echo $db->getQuery();
						$db->execute();
					}
				}
			}else{
				for($i=0;$i<count($cid1);$i++){
					$date = $cid1[$i];
					$db->setQuery("Delete from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '1'");
					$db->execute();
				}
			}
		}
		if(count($cid2) > 0){
			if($status == 0){
				for($i=0;$i<count($cid2);$i++){
					$date = $cid2[$i];
					$db->setQuery("Select count(id) from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '2'");
					$count = $db->loadResult();
					if($count == 0){
						$db->setQuery("INSERT INTO #__oscalendar_available (id,pid,rid,availtype,checkdate) VALUES (NULL,'$pid','$rid','2','$date')");
						echo $db->getQuery();
						$db->execute();
					}
				}
			}else{
				for($i=0;$i<count($cid2);$i++){
					$date = $cid2[$i];
					$db->setQuery("Delete from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '2'");
					$db->execute();
				}
			}
		}
		$month = $mainframe->input->getString('month',intval(date("m",time())));
		$year = $mainframe->input->getString('year',date("Y",time()));
		$mainframe->redirect("index.php?option=com_oscalendar&task=property_calendarmanage&pid=$pid&rid=$rid&month=$month&year=$year");
	}
	
	/**
	 * Manage calendar
	 *
	 * @param unknown_type $pid
	 */
	static function calendarManage($pid,$rid){
		global $mainframe;
		$document = JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_oscalendar/js/ajax.js");
		require_once(JPATH_ROOT.DS."components".DS."com_oscalendar".DS."helpers".DS."calendar.php");
		$db = JFactory::getDbo();
		$db->setQuery("Select id,pro_alias,pro_name,category_id from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		HTML_OSappscheduleProperty::calendarManage($property,$room);
	}
	
	/**
	 * Remove prices
	 *
	 * @param unknown_type $cid
	 */
	static function removePrices($cid){
		global $mainframe;
		$db = JFactory::getDbo();
		$cids = implode(",",$cid);
		$db->setQuery("Delete from #__oscalendar_property_prices where id in ($cids)");
		$db->execute();
		$pid = $mainframe->input->getInt('pid',0);
		$msg = JText::_('OS_PRICES_HAVE_BEEN_REMOVED');
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect("index.php?option=com_oscalendar&task=property_pricemanage&pid=$pid");
	}
	
	static function gotoPrice(){
		global $mainframe;
		$pid = $mainframe->input->getInt('pid',0);
		$mainframe->redirect("index.php?option=com_oscalendar&task=property_pricemanage&pid=$pid");
	}
	
	/**
	 * Save price
	 *
	 * @param unknown_type $save
	 */
	static function savePrice($save){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$id = $mainframe->input->getInt('id',0);
		$start_time = $mainframe->input->getString('start_time','');
		$end_time   = $mainframe->input->getString('end_time','');
		$price		= $mainframe->input->getString('price','');
		$pid		= $mainframe->input->getInt('pid',0);
		if($id > 0){
			$db->setQuery("Update #__oscalendar_property_prices set start_time = '$start_time',end_time = '$end_time',price = '$price' where id = '$id'");
			$db->execute();
		}else{
			$db->setQuery("Insert into #__oscalendar_property_prices (id,pid,start_time,end_time,price) values (NULL,'$pid','$start_time','$end_time','$price')");
			$db->execute();
		}
		if($id == 0){
			$id = $db->insertid();
		}
		$msg = JText::_('OS_PRICE_HAS_BEEN_SAVED');
		$mainframe->enqueueMessage($msg);
		if($save == 1){
			$mainframe->redirect("index.php?option=com_oscalendar&task=property_pricemanage&pid=$pid");
		}else{
			$mainframe->redirect("index.php?option=com_oscalendar&task=property_editprice&cid[]=$id&pid=$pid");
		}
	}
	
	/**
	 * Edit price
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $id
	 */
	static function editPrice($pid,$id){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		if($id > 0){
			$db->setQuery("Select * from #__oscalendar_property_prices where id = '$id'");
			$price = $db->loadObject();
		}
		HTML_OSappscheduleProperty::editPriceHTML($property,$price);
	}
	
	/**
	 * Manage price
	 *
	 * @param unknown_type $pid
	 */
	static function managePrice($pid){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$limit =  $mainframe->input->getInt('limit',20);
		$limitstart  = $mainframe->input->getInt('limitstart',0);
		$db->setQuery("Select count(id) from #__oscalendar_property_prices where pid = '$pid'");
		$count = $db->loadResult();
		jimport('joomla.html.pagination');
		$pageNav = new JPagination($count,$limitstart,$limit);
		$query = "Select * from #__oscalendar_property_prices where pid = '$pid' order by start_time desc";
		$db->setQuery($query,$pageNav->limitstart,$pageNav->limit);
		$rows = $db->loadObjectList();
		HTML_OSappscheduleProperty::managePriceList($rows,$pageNav,$property);
	}
	
	
	/**
	 * Availability calendar
	 *
	 * @param unknown_type $pid
	 */
	static function availability($pid,$rid){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$current_month = date("m",OSCHelper::getRealTime());
		$current_year  = date("Y",OSCHelper::getRealTime());
		
		$month = $mainframe->input->getInt('month',$current_month);
		$year  = $mainframe->input->getInt('year',$current_year);
		
		$db->setQuery("Select id,pro_alias,pro_name,category_id from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		HTML_OSappscheduleProperty::availabilityCalendar($property,$room,$month,$year);
	}
}
?>