<?php
/*------------------------------------------------------------------------
# orders.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

/**
 * Enter description here...
 *
 */
class OSappscheduleOrders{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));		
		switch ($task){
			default:
			case "orders_list":
				OSappscheduleOrders::orders_list($option);
			break;
			case "orders_save":
				OSappscheduleOrders::orders_save($option,1);
			break;
			case "orders_apply":
				OSappscheduleOrders::orders_save($option,0);
			break;	
			case "orders_remove":
				OSappscheduleOrders::orders_remove($option,$cid);
			break;
			case "orders_addnew":
				OSappscheduleOrders::orders_edit(0);
			break;
			case "orders_cancel":
				$mainframe->redirect("index.php");
			break;
			case "orders_gotoorders":
				$mainframe->redirect("index.php?option=com_oscalendar&task=orders_list");
			break;
			case "orders_detail":
				OSappscheduleOrders::orders_edit($cid[0]);
			break;
			case "orders_checkbooking":
				OSappscheduleOrders::checkBooking();
			break;
			case "orders_exportcsv":
				OSappscheduleOrders::exportCSV($cid);
			break;
			case "orders_loadRoomDropdownAjax":
				OSappscheduleOrders::loadRoomDropdownAjax();
			break;
			case "orders_priceplanlist":
				OSappscheduleOrders::listPricePlan();
			break;
		}
	}
	
	/**
	 * Edit order
	 *
	 * @param unknown_type $id
	 */
	static function orders_edit($id){
		global $mainframe;
		require_once(JPATH_COMPONENT_ADMINISTRATOR."/tables/order.php");
		$db = JFactory::getDBO();
		if($id > 0){
			$row = & JTable::getInstance('Calendarbooking','OsAppTable');
			$row->load((int)$id);
		}
		$orderStatusArr = array();
		$orderStatusArr[] = JHTML::_('select.option','P',JText::_('OS_PENDING'));
		$orderStatusArr[] = JHTML::_('select.option','S',JText::_('OS_COMPLETED'));
		$orderStatusArr[] = JHTML::_('select.option','C',JText::_('OS_CANCELED'));
		$lists['order_status'] = JHTML::_('select.genericlist',$orderStatusArr,'order_status','class="input-medium form-control form-select"','value','text',$row->order_status);
		
		$db->setQuery("Select * from #__oscalendar_fields where published = '1'");
		$fields = $db->loadObjectList();
		
		$db->setQuery("Select name as value, title as text from #__oscalendar_plugins where published = '1'");
		$pluginArr = $db->loadObjectList();
		$lists['plugin'] = JHTML::_('select.genericlist',$pluginArr,'payment_method','class="input-medium form-control form-select"','value','text',$row->payment_method);
		
		if($row->id > 0){
			$optionArr   = array();
			$optionArr[] = JHTML::_('select.option','',JText::_('OS_SELECT_ROOM'));
			$db->setQuery("Select id as value, room_name as text from #__oscalendar_rooms where pid = '$row->pid'");
			$options     = $db->loadObjectList();
			$optionArr   = array_merge($optionArr,$options);
			$lists['room'] = JHTML::_('select.genericlist',$optionArr,'rid','class="input-large form-control form-select"','value','text',$row->rid);
		}
		HTML_OSappscheduleOrders::orderDetails($row,$lists,$fields);
	}
	
	/**
	 * agent list
	 *
	 * @param unknown_type $option
	 */
	static function orders_list($option){
		$mainframe = JFactory::getApplication();
		$db = JFactory::getDbo();
        $show_form                      = 0;
		//property types
		$pro_type                       = $mainframe->input->getInt('pro_type',0);
		$typeArr[]                      = JHTML::_('select.option','',JText::_('OS_ALL_PROPERTY_TYPES'));
		$db->setQuery("Select id as value,type_name as text from #__osrs_types where published = '1' order by type_name");
		$protypes                       = $db->loadObjectList();
		$typeArr                        = array_merge($typeArr,$protypes);
		$lists['type']                  = JHTML::_('select.genericlist',$typeArr,'pro_type','class="input-large chosen form-control form-select" onChange="javascript:document.adminForm.submit();"','value','text',$pro_type);
		
		include(JPATH_ADMINISTRATOR.'/components/com_osproperty/classes/property.php');
		$category_id                    = $mainframe->input->getInt('category_id',0);
		$lists['category']              = OspropertyProperties::listFilterCategories($category_id,'onChange="javascript:document.adminForm.submit();"');
		
		$condition = '';
		
		// order by
		$filter_order                   = $mainframe->input->getString('filter_order','b.order_date');
		$filter_order_Dir               = $mainframe->input->getString('filter_order_Dir','desc');
		$lists['order']                 = $filter_order;
		$lists['order_Dir']             = $filter_order_Dir;
		
		//search 
		$limitstart						= $mainframe->input->getInt('limitstart');
		if(!isset($limitstart)){
			$limitstart					= $mainframe->getUserStateFromRequest('os_list.filter.limitstart','limit_start',0);
		}
		$mainframe->setUserState('os_list.filter.limitstart',$limitstart);
		$limit							= $mainframe->input->getInt('limit',0);
		if($limit ==  0){
			$limit     	  	 			= $mainframe->getUserStateFromRequest('pro_list.filter.limit','limit',20);
		}
		//get post keyword
		$keyword 						= $mainframe->input->getString('keyword');
		// filter state
		$filter_status 				    = $mainframe->getUserStateFromRequest($option.'.orders.filter_status','filter_status','','string');
		$condition 				        .= ($filter_status != '')? " AND b.order_status = '$filter_status'":"";
        if($filter_status != ""){
            $show_form                  = 1;
        }
		$options                        = array();
		$options[]					    = JHtml::_('select.option','',JText::_('OS_FILTER_STATUS'));
		$options[]					    = JHtml::_('select.option','P',JText::_('OS_PENDING'));
		$options[]					    = JHtml::_('select.option','S',JText::_('OS_COMPLETE'));
		$options[]					    = JHtml::_('select.option','C',JText::_('OS_CANCEL'));
		$lists['filter_status']		    = JHtml::_('select.genericlist',$options,'filter_status','class="input-medium chosen" onchange="this.form.submit();"','value','text',$filter_status);
		
		// filter date
		$filter_date_from			    = $mainframe->getUserStateFromRequest($option.'.orders.filter_date_from','filter_date_from',null,'string');
		$lists['filter_date_from']	    = $filter_date_from;
		if ($filter_date_from           != '' ){
			$condition 				    .= " AND b.book_from >= '$filter_date_from'";

		}
		$filter_date_to				    = $mainframe->getUserStateFromRequest($option.'.orders.filter_date_to','filter_date_to',null,'string');
		$lists['filter_date_to']	    = $filter_date_to;
		if ($filter_date_to != '' ){
			$condition 				    .= " AND b.book_to <= '$filter_date_to'";
            $show_form                  = 1;
		}
		
		$query = " SELECT count(b.id) FROM #__oscalendar_booking as b inner join #__osrs_properties as a on a.id = b.pid "
				." WHERE 1 = 1 ";
		if($keyword                     != ""){
			$query                      .= " and (a.pro_name like '%$keyword%' or a.pro_alias like '%$keyword%' or a.ref like '%$keyword%')";
            $show_form                  = 1;
		}
		if($category_id > 0){
			$query                         .= " and a.category_id = '$category_id'";
            $show_form                  = 1;
		}
		if($pro_type > 0){
			$query .= " and pro_type = '$pro_type'";
            $show_form                  = 1;
		}
        $query                          .= $condition;

		$db->setQuery($query); 
		$total                          = $db->loadResult();
		jimport('joomla.html.pagination');
		$pageNav = new JPagination($total,$limitstart,$limit);
		
		//list record 
		$query = " SELECT a.*,b.id AS id, b.book_from,b.book_to, b.payment_method, b.amount,b.total_amount,b.curr, b.deposit,b.tax, b.name, b.email,b.phone, b.notes, b.order_status, b.order_date,b.pid,b.nAdults,b.nChilds,c.room_name "
				." FROM #__osrs_properties as a "
				." INNER JOIN #__oscalendar_booking as b ON a.id = b.pid INNER JOIN #__oscalendar_rooms as c on c.id = b.rid WHERE 1=1 ";
		if($keyword != ""){
			$query .= " and (a.pro_name like '%$keyword%' or a.pro_alias like '%$keyword%' or a.ref like '%$keyword%')";
		}
		if($category_id > 0){
			$query .= " and a.category_id = '$category_id'";
		}
		if($pro_type > 0){
			$query .= " and pro_type = '$pro_type'";
		}
		$query .= $condition;
		$query .=" ORDER BY $filter_order $filter_order_Dir ";
		$db->setQuery($query);	
		//echo $db->getQuery();
		$rows = $db->loadObjectList();
        $lists['show_form']             = $show_form;
		HTML_OSappscheduleOrders::orders_list($option,$rows,$pageNav,$lists);
	}
	
	
	/**
	 * remove agent
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 */
	static function orders_remove($option,$cid){
		$mainframe = JFactory::getApplication();
		$db = JFactory::getDBO();
		if(count($cid)>0)	{
			$cids = implode(",",$cid);
			$db->setQuery("DELETE FROM #__oscalendar_booking WHERE id IN ($cids)");
			$db->execute();
			
			$db->setQuery("Delete from #__oscalendar_order_field_options where order_id in ($cids)");
			$db->execute();
			
			$db->setQuery("Delete from #__oscalendar_order_field_values where order_id in ($cids)");
			$db->execute();
			
			$db->setQuery("Delete from #__oscalendar_order_field_price where order_id in ($cids)");
			$db->execute();
		}
		$msg = JText::_("OS_CALENDAR_ITEM_HAS_BEEN_DELETED");
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect("index.php?option=com_oscalendar&task=orders_list");
	}
	/**
	 * save booking list
	 */
	static function orders_save($option,$save){
		$mainframe = JFactory::getApplication();
		require_once(JPATH_COMPONENT_ADMINISTRATOR."/tables/order.php");
		$db = JFactory::getDbo();
		$id = $mainframe->input->getInt('id',0);
		$db->setQuery("Select order_status from #__oscalendar_booking where id = '$id'");
		$old_order_status = $db->loadResult();
		$order_status = $mainframe->input->getString('order_status','');
		$mainframe = JFactory::getApplication();
		$row = &JTable::getInstance('Calendarbooking','OsAppTable');
		$post = $mainframe->input->post->getArray(); //JRequest::get('post',JREQUEST_ALLOWHTML);
		$row->bind($post);
		if($id == 0){
			$row->order_date = date("Y-m-d H:i:s",time());
		}
		$row->store();
		if($id == 0){
			$id = $db->insertID();
		}
		
		$db->setQuery("Select * from #__oscalendar_fields where published = '1'");
		$fields = $db->loadObjectList();
		if(count($fields) > 0){
			for($i=0;$i<count($fields);$i++){
				$field = $fields[$i];
				$field_id = $field->id;
				switch ($field->field_type){
					case "0":
						$field_name = "field_".$field_id;
						$fieldvalue = $mainframe->input->getString($field_name,'');
						if($fieldvalue != ""){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_TextField($id,$field,$fieldvalue);
						}
					break;
					case "1":
						$fieldvalue = $mainframe->input->getString('field_'.$field->id);
						if($fieldvalue != ""){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_TextareaField($id,$field,$fieldvalue);
						}
					break;
					case "2":
						$fieldvalue = $mainframe->input->getInt('field_'.$field->id,0);
						if($fieldvalue > 0){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_SelectField($id,$field,$fieldvalue);
						}
					break;
					case "3":
						$fieldvalue = $mainframe->input->getInt('field_'.$field->id);
						if(count($fieldvalue) > 0){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_CheckboxField($id,$field,$fieldvalue);
						}
					break;
				}
			}
		}
		if($order_status != $old_order_status){
			include_once(JPATH_ROOT.'/components/com_oscalendar/classes/default.php');
			include_once(JPATH_ROOT.'/components/com_oscalendar/classes/default.html.php');
			HelperOScalendarCommon::sendEmail('order_status_change',$id);
		}
		$msg = JText::_('OS_ITEM_HAS_BEEN_SAVED');
		$mainframe->enqueueMessage($msg);
		if($save == 1){
			$mainframe->redirect("index.php?option=com_oscalendar&task=orders_list");
		}else{
			$mainframe->redirect("index.php?option=com_oscalendar&task=orders_detail&cid[]=$row->id");
		}
	}
	
	/**
	 * Export CSV
	 *
	 * @param unknown_type $cid
	 */
	static function exportCSV($cid){
		global $mainframe,$configClass,$cClass;
		if(count($cid) == 0){
			$mainframe->enqueueMessage(JText::_('OS_YOU_NEED_TO_SELECT_AT_LEASET_ONE_ORDER_TO_EXPORT'));
			$mainframe->redirect("index.php?option=com_oscalendar&task=orders_list");
		}
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__oscalendar_fields where published = '1' order by ordering");
		$fields = $db->loadObjectList();
		
		$csv_seperator = $cClass['csv_seperator'];
		$header  = JText::_('OS_ORDER_ID').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_NAME').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_EMAIL_ADDRESS').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_PHONE').$csv_seperator;
		$header .= JText::_('OS_COUNTRY').$csv_seperator;
		$header .= JText::_('OS_ORDER_DATE').$csv_seperator;
		$header .= JText::_('OS_PROPERTY').$csv_seperator;
		$header .= JText::_('OS_ROOM').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_CHECK_IN').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_CHECK_OUT').$csv_seperator;
		$header .= JText::_('OS_CALENDAR_NOTES').$csv_seperator;
		if(count($fields) > 0){
			foreach ($fields as $field){
				$header .= $field->field_label.$csv_seperator;
			}
		}
		$header .= JText::_('OS_NCHILDS').$csv_seperator;
		$header .= JText::_('OS_NADULTS').$csv_seperator;
		$header .= JText::_('OS_AMOUNT').$csv_seperator;
		$header .= JText::_('OS_TAX').$csv_seperator;
		$header .= JText::_('OS_TOTAL').$csv_seperator;
		$header .= JText::_('OS_PAYMENT').$csv_seperator;
		$header .= JText::_('OS_ORDER_STATUS').$csv_seperator;
		$header .= JText::_('OS_TRANSACTIONID');
		$header .= "\n";
		
		for($i=0;$i<count($cid);$i++){
			$order_id = $cid[$i];
			$db->setQuery("Select * from #__oscalendar_booking where id = '$order_id'");
			$order = $db->loadObject();
			
			$db->setQuery("Select * from #__osrs_properties where id = '$order->pid'");
			$property = $db->loadObject();
			if($property->ref != ""){
				$property->pro_name = $property->ref.", ".$property->pro_name;
			}
			
			$db->setQuery("Select room_name from #__oscalendar_rooms where id = '$order->rid'");
			$room_name = $db->loadResult();
			
			$header .= $order_id.$csv_seperator;
			$header .= $order->name.$csv_seperator;
			$header .= $order->email.$csv_seperator;
			$header .= $order->phone.$csv_seperator;
			$header .= $order->country.$csv_seperator;
			$header .= $order->order_date.$csv_seperator;
			$header .= $property->pro_name.$csv_seperator;
			$header .= $room_name.$csv_seperator;
			$header .= OSCHelper::showDateFormat($order->book_from,0).$csv_seperator;
			$header .= OSCHelper::showDateFormat($order->book_to,0).$csv_seperator;
			$header .= $order->notes.$csv_seperator;
			if(count($fields) > 0){
				foreach ($fields as $field){
					$header .= HelperOScalendarExtrafields::getFormFieldInOrder($field,$order_id).$csv_seperator;
				}
			}
			$header .= $order->nChilds.$csv_seperator;
			$header .= $order->nAdults.$csv_seperator;
			if($order->amount > 0){
				$header .= OSCHelper::showMoneyWithoutCurrency($order->amount,0).' '.$order->curr.$csv_seperator;
			}else{
				$header .= '0'.$csv_seperator;
			}
			if($order->tax > 0){
				$header .= OSCHelper::showMoneyWithoutCurrency($order->tax,0).' '.$order->curr.$csv_seperator;
			}else{
				$header .= '0'.$csv_seperator;
			}
			if($order->total > 0){
				$header .= OSCHelper::showMoneyWithoutCurrency($order->total_amount,0).' '.$order->curr.$csv_seperator;
			}else{
				$header .= '0'.$csv_seperator;
			}
			$db->setQuery("Select title from #__oscalendar_plugins where name like '$order->payment_method'");
			$payment_title = $db->loadResult();
			$header .= $payment_title.$csv_seperator;
			if($order->order_status == "P"){
				$status = JText::_('OS_PENDING');
			}elseif($order->order_status == "S"){
				$status = JText::_('OS_COMPLETE');
			}elseif($order->order_status == "C"){
				$status = JText::_('OS_CANCEL');
			}
			$header .= $status.$csv_seperator;
			$header .= $order->transaction_id;
			$header .= "\n";
		}
		$filename = time().".csv";
		$csv_absoluted_link = JPATH_ROOT."/tmp".DS.$filename;
		$csvf = fopen($csv_absoluted_link,'w');
		@fwrite($csvf,$header);
		@fclose($csvf);
		self::downloadfile($csv_absoluted_link,$filename);
	}
	
	/**
	 * Download file
	 *
	 * @param unknown_type $file_path
	 * @param unknown_type $filename
	 */
	public static function downloadfile($file_path,$filename){
    	while (@ob_end_clean());
    	$len = @ filesize($file_path);
		$cont_dis ='attachment';

		// required for IE, otherwise Content-disposition is ignored
		if(ini_get('zlib.output_compression'))  {
			ini_set('zlib.output_compression', 'Off');
		}
	
	    header("Pragma: public");
	    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	    header("Expires: 0");
	
	    header("Content-Transfer-Encoding: binary");
		header('Content-Disposition:' . $cont_dis .';'
			. ' filename="'.$filename.'";'
			. ' size=' . $len .';'
			); //RFC2183
	    header("Content-Length: "  . $len);
	    if( ! ini_get('safe_mode') ) { // set_time_limit doesn't work in safe mode
		    @set_time_limit(0);
	    }
	    self::readfile_chunked($file_path);
		exit();
    }
    
    
    public static function readfile_chunked($filename,$retbytes=true){
		$chunksize = 1*(1024*1024); // how many bytes per chunk
		$buffer = '';
		$cnt =0;
		$handle = fopen($filename, 'rb');
		if ($handle === false) {
   			return false;
		}
		while (!feof($handle)) {
	   		$buffer = fread($handle, $chunksize);
	   		echo $buffer;
			@ob_flush();
			flush();
	   		if ($retbytes) {
	       		$cnt += strlen($buffer);
	   		}
		}
   		$status = fclose($handle);
	    if ($retbytes && $status) {
   			return $cnt; // return num. bytes delivered like readfile() does.
		}
		return $status;
	}
	
	static function getPropertyInput($pro_id = 0){
		// Initialize variables.
		require_once(JPATH_ADMINISTRATOR."/components/com_osproperty/tables/property.php");
		$html = array();
		//$groups = $this->getGroups();
		//$excluded = $this->getExcluded();
		$link = 'index.php?option=com_osproperty&amp;task=properties_list&amp;&amp;tmpl=component&amp;field=pro_id&amp;from=oscalendar';
        $onchange = "";
		// Initialize some field attributes.
		$attr = ' class="input-large"';

		// Load the modal behavior script.
		if(OSPHelper::isJoomla4())
		{
			OSPHelperJquery::colorbox('modal');
			OSPHelperJquery::colorbox('modal_pro_id');

			// Build the script.
			$script = array();
			$script[] = '	function jSelectUser_pro_id(id, title) {';
			$script[] = '		var old_id = document.getElementById("pid").value;';
			$script[] = '		if (old_id != id) {';
			$script[] = '			document.getElementById("pid").value = id;';
			$script[] = '			document.getElementById("pro_name").value = title;';
			$script[] = '			' . $onchange;
			$script[] = '		}';
			$script[] = '		parent.jQuery.colorbox.close(); return false;';
			$script[] = '	}';

		}
		else
		{
			JHtml::_('behavior.modal');
			JHtml::_('behavior.modal', 'a.modal_pro_id');

			// Build the script.
			$script = array();
			$script[] = '	function jSelectUser_pro_id(id, title) {';
			$script[] = '		var old_id = document.getElementById("pid").value;';
			$script[] = '		if (old_id != id) {';
			$script[] = '			document.getElementById("pid").value = id;';
			$script[] = '			document.getElementById("pro_name").value = title;';
			$script[] = '			' . $onchange;
			$script[] = '		}';
			$script[] = '		SqueezeBox.close();';
			$script[] = '	}';

		}

		
		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		// Load the current username if available.
		$table = JTable::getInstance('Property','OspropertyTable');
		
		if ($pro_id)
		{
			$table->load($pro_id);
		}
		else
		{
			$table->pro_name = JText::_('OS_SELECT_PROPERTY');
		}

		// Create a dummy text field with the user name.
		$html[] = '<span class="input-append btn-group">';
		$html[] = '<input type="text" class="input-large form-control" id="pro_name" value="'.htmlspecialchars($table->pro_name, ENT_COMPAT, 'UTF-8') .'" disabled="disabled" size="35" /><a class="modal_pro_id btn btn-primary" title="'.JText::_('OS_SELECT_PROPERTY').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 800, y: 450},onClose:function(){loadRoomDropdown()}}"><i class="icon-file"></i> '.JText::_('OS_SELECT_PROPERTY').'</a>';
		$html[] = '</span>';

		// Create the real field, hidden, that stored the user id.
		$html[] = '<input type="hidden" id="pid" name="pid" value="'.$pro_id.'" />';

		return implode("\n", $html);
	}
	
	
	static function getUserInput($user_id)
	{
		if (version_compare(JVERSION, '3.5', 'le')){
			// Initialize variables.
			$html = array();
			$link = 'index.php?option=com_users&amp;view=users&amp;layout=modal&amp;tmpl=component&amp;field=user_id';
			
			// Initialize some field attributes.
			$attr = ' class="inputbox"';

			// Load the modal behavior script.
			JHtml::_('behavior.modal');
			JHtml::_('behavior.modal', 'a.modal_user_id');

			// Build the script.
			$script = array();
			$script[] = '	function jSelectUser_user_id(id, title) {';
			$script[] = '		var old_id = document.getElementById("user_id").value;';
			$script[] = '		if (old_id != id) {';
			$script[] = '			document.getElementById("user_id").value = id;';
			$script[] = '			document.getElementById("user_id_name").value = title;';
			$script[] = '			var agent_name = document.getElementById("name");';
			$script[] = '			if(agent_name.value == ""){';
			$script[] = '				agent_name.value = title ;';
			$script[] = '			}';
			$script[] = '			' . $onchange;
			$script[] = '		}';
			$script[] = '		SqueezeBox.close();';
			$script[] = '	}';

			// Add the script to the document head.
			JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

			// Load the current username if available.
			$table = JTable::getInstance('user');
			
			if ($user_id)
			{
				$table->load($user_id);
			}
			else
			{
				$table->username = JText::_('OS_SELECT_AGENT');
			}

			// Create a dummy text field with the user name.
			$html[] = '<span class="input-append">';
			$html[] = '<input type="text" class="input-medium" id="user_id_name" value="'.htmlspecialchars($table->name, ENT_COMPAT, 'UTF-8') .'" disabled="disabled" size="35" /><a class="modal btn" title="'.JText::_('JLIB_FORM_CHANGE_USER').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-file"></i> '.JText::_('JLIB_FORM_CHANGE_USER').'</a>';
			$html[] = '</span>';

			// Create the real field, hidden, that stored the user id.
			$html[] = '<input type="hidden" id="user_id" name="user_id" value="'.$user_id.'" />';

			return implode("\n", $html);
		}else{
				$field = JFormHelper::loadFieldType('User');
				$element = new SimpleXMLElement('<field />');
				$element->addAttribute('name', 'user_id');
				$element->addAttribute('class', 'readonly');

				$field->setup($element, $user_id);

				return $field->input;
		}
	}

	/**
	function getUserInput($user_id)
	{
		// Initialize variables.
		$html = array();
		//$groups = $this->getGroups();
		//$excluded = $this->getExcluded();
		$link = 'index.php?option=com_users&amp;view=users&amp;layout=modal&amp;tmpl=component&amp;field=user_id';

		// Initialize some field attributes.
		$attr = ' class="inputbox"';
		//$attr .= $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '';

		// Initialize JavaScript field attributes.
		//$onchange = (string) $this->element['onchange'];

		// Load the modal behavior script.
		JHtml::_('behavior.modal');
		JHtml::_('behavior.modal', 'a.modal_user_id');

		// Build the script.
		$script = array();
		$script[] = '	function jSelectUser_user_id(id, title) {';
		$script[] = '		var old_id = document.getElementById("user_id").value;';
		$script[] = '		if (old_id != id) {';
		$script[] = '			document.getElementById("user_id").value = id;';
		$script[] = '			document.getElementById("user_id_name").value = title;';
		$script[] = '			' . $onchange;
		$script[] = '		}';
		$script[] = '		SqueezeBox.close();';
		$script[] = '	}';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		// Load the current username if available.
		$table = JTable::getInstance('user');
		
		if ($user_id)
		{
			$table->load($user_id);
		}
		else
		{
			$table->username = JText::_('Select Customer');
		}

		// Create a dummy text field with the user name.
		$html[] = '<span class="input-append">';
		$html[] = '<input type="text" class="input-medium" id="user_id_name" value="'.htmlspecialchars($table->name, ENT_COMPAT, 'UTF-8') .'" disabled="disabled" size="35" /><a class="modal btn" title="'.JText::_('JLIB_FORM_CHANGE_USER').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-file"></i> '.JText::_('Select Customer').'</a>';
		$html[] = '</span>';

		// Create the real field, hidden, that stored the user id.
		$html[] = '<input type="hidden" id="user_id" name="user_id" value="'.$user_id.'" />';

		return implode("\n", $html);
	}
	**/
	
	/**
	 * Load dropdown Room 
	 *
	 */
	static function loadRoomDropdownAjax(){
		global $mainframe,$cClass;
		$db = JFactory::getDbo();
		$pid = $mainframe->input->getInt('pid',0);
		$db->setQuery("Select a.price_type from #__osrs_types as a inner join #__osrs_properties as b on b.pro_type = a.id where b.id = '$pid'");
		$price_type = $db->loadResult();
		if($price_type == 0){
			$js = 'onChange="javascript:listPricePlan();"';
		}else{
			$js = '';
		}
        if($cClass['allow_room'] == 1) {
            $optionArr = array();
            $optionArr[] = JHTML::_('select.option', '', JText::_('OS_SELECT_ROOM'));
            $db->setQuery("Select id as value, room_name as text from #__oscalendar_rooms where pid = '$pid'");
            $options = $db->loadObjectList();
            $optionArr = array_merge($optionArr, $options);
            echo JHTML::_('select.genericlist', $optionArr, 'rid', 'class="input-large" ' . $js, 'value', 'text');
            ?>
            <div id="priceplanlist">

            </div>
        <?php
        }else{
            $db->setQuery("Select id from #__oscalendar_rooms where pid = '$pid'");
            $rid = $db->loadResult();
            ?>
            <input type="hidden" name="rid" id="rid" value="<?php echo $rid;?>" />
            <?php
            $db->setQuery("Select * from #__osrs_properties where id = '$pid'");
            $property = $db->loadObject();
            echo $property->pro_name;
            if($price_type == 0) {
                echo " <Br />";
                $mainframe->input->set('rid',$rid);
                self::listPricePlan();
            }
        }

		exit();
	}
	
	/**
	 * List price plan for Type Holiday
	 *
	 */
	public static function listPricePlan(){
		global $mainframe,$cClass;
		$db = JFactory::getDbo();
		$rid = $mainframe->input->getInt('rid',0);
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$room_number = $room->room_number;
		$today = date("Y-m-d",time());
		$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and price_from >= '$today'");
		$price_plans = $db->loadObjectList();
		if(count($price_plans) > 0){
			for($j=0;$j<count($price_plans);$j++){
				$price = $price_plans[$j];
				$broom = OSCHelper::maxRoomBookedTypeHoliday($room->id,$price->price_from,$price->price_to);
				$froom = $room_number - $broom;
				if($froom > 0){
					?>
					<a href="javascript:addBooking('<?php echo $price->price_from;?>','<?php echo $price->price_to;?>')" title="<?php echo Jtext::_('OS_CLICK_TO_ADD');?>">
					<?php
					echo $price->title." ".JText::_('OS_FROM').": ".$price->price_from." - ".JText::_('OS_TO').": ".$price->price_to." - ".OSPHelper::generatePrice($price->curr,$price->price).". ";
                    if($cClass['allow_room'] == 1){
                        echo JText::_('OS_AVAILABLE').": ".$froom;
                    }
					?>
					</a>
					<BR />			
					<?php
				}
			}
				
			$room->available_list = JHTML::_('select.genericlist',$optionArr,'room_'.$room->id,'class="input-medium" onChange="javascript:updateSummary('.$room->id.')"','value','text');
		}else{
			echo JText::_('OS_NO_AVAILABLE_PRICE_PLAN');
		}
	}
}
?>