<?php
/*------------------------------------------------------------------------
# config.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

/**
 * Enter description here...
 *
 */
class OsAppscheduleConfiguration{
	/**
	 * Default function
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $app;
		$app = JFactory::getApplication();
		switch ($task){
			default:
				self::ConfigLayout($option);
			break;
			case 'config_apply':
				self::config_save($option,0);
			break;
			case "config_save":
				self::config_save($option,1);
			break;
			case "config_gotoindex":
				$app->redirect("index.php");
			break;
		}
	}
	
	/**
	 * agent list
	 *
	 * @param unknown_type $option
	 */
	public static function ConfigLayout($option){
		global $app;
	
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query	->clear()
				->select('*')
				->from('#__oscalendar_configuration')
				;
		$db->setQuery($query);
		$configs = new stdClass();
		$elements = $db->loadObjectList();
		if (count($elements)){
			foreach ( $elements as $element) {
				$field_name = $element->config_key;
				$field_value= $element->config_value;
				$configs->$field_name = $field_value;
			}
		}
		
		//get date time format
			$options = array();
			$format_date_times = explode('|','d.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s');
			foreach ($format_date_times as $format_date_time) {
				$options[] = JHTML::_('select.option', $format_date_time, $format_date_time.' ('.JHtml::_('date','now',$format_date_time).') '  );	
			}
			if (!isset($configs->date_time_format)) $configs->date_time_format='Y-m-d H:i:s';
			$lists['date_time_format'] = JHTML::_('select.genericlist', $options, 'configuration[date_time_format]', ' class="inputbox input-large form-control form-select" ', 'value', 'text', $configs->date_time_format );
			
		//get date format 
			$options = array();
			$format_dates = explode('|','d.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j');
			foreach ($format_dates as $format_date) {
				$options[] = JHTML::_('select.option', $format_date, $format_date.' ('.JHtml::_('date','now',$format_date).') '  );
			}
			if (!isset($configs->date_format)) $configs->date_format='Y-m-d';
			$lists['date_format'] = JHTML::_('select.genericlist', $options, 'configuration[date_format]', ' class="inputbox input-large form-control form-select" ', 'value', 'text', $configs->date_format );
		
		//get time format
			$options = array();
			$format_times = explode('|','H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A');
			foreach ($format_times as $format_time) {
				$options[] = JHTML::_('select.option', $format_time, $format_time.' ('.JHtml::_('date','now',$format_time).') '  );
			}
			if (!isset($configs->time_format)) $configs->time_format='H:i';
			$lists['time_format'] = JHTML::_('select.genericlist', $options, 'configuration[time_format]', ' class="inputbox input-large form-control form-select" ', 'value', 'text', $configs->time_format );
		
		// CSV fields Seperator
		$options = array();
		$options[] = JHtml::_('select.option',',',JText::_('Comma'));
		$options[] = JHtml::_('select.option',';',JText::_('Semicolon'));
		if (!isset($configs->csv_seperator)) $configs->csv_seperator=',';
		$lists['csv_seperator'] = JHtml::_('select.genericlist',$options,'configuration[csv_seperator]','class="input-medium form-control form-select"','value','text',$configs->csv_seperator);
		
		// Deposit payment
			if (!isset($configs->deposit_payment)) $configs->deposit_payment='';
			$lists['deposit_payment'] = '<input type="text" class="input-mini form-control" name="configuration[deposit_payment]" id="deposit_payment" value="'.$configs->deposit_payment.'">&nbsp;%';
			
		// Tax Payment
			if (!isset($configs->tax_payment)) $configs->tax_payment='';
			$lists['tax_payment'] = '<input type="text" class="input-mini form-control" name="configuration[tax_payment]" id="tax_payment" value="'.$configs->tax_payment.'">&nbsp;%';
			
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['enable_reservation'] = JHtml::_('select.genericlist',$options,'configuration[enable_reservation]','class="input-mini form-control form-select"','value','text',$configs->enable_reservation);
		
		// only register can book
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['only_register_can_book'] = JHtml::_('select.genericlist',$options,'configuration[only_register_can_book]','class="input-mini form-control form-select"','value','text',$configs->only_register_can_book);
		
		// only register can book
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['send_notify'] = JHtml::_('select.genericlist',$options,'configuration[send_notify]','class="input-mini form-control form-select"','value','text',$configs->send_notify);
		
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['enable_tax'] = JHtml::_('select.genericlist',$options,'configuration[enable_tax]','class="input-mini form-control form-select"','value','text',$configs->enable_tax);
		
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['use_ssl'] = JHtml::_('select.genericlist',$options,'configuration[use_ssl]','class="input-mini form-control form-select"','value','text',$configs->use_ssl);
		
		$options = array() ;
		$options[] = JHTML::_('select.option', 0, JText::_('OS_BEFORE_AMOUNT'));
		$options[] = JHTML::_('select.option', 1, JText::_('OS_AFTER_AMOUNT'));
		$options[] = JHTML::_('select.option', 2, JText::_('OS_DO_NOT_SHOW'));
		$lists['currency_symbol_position'] = JHTML::_('select.genericlist', $options, 'configuration[currency_symbol_position]', 'class="input-medium form-control form-select" ', 'value', 'text', $configs->currency_symbol_position);
		
		$options = array() ;
		$options[] = JHTML::_('select.option', 1, JText::_('OS_NO'));
		$options[] = JHTML::_('select.option', 2, JText::_('OS_YES'));
		$options[] = JHTML::_('select.option', 3, JText::_('OS_YES_RECAPTCHA'));
		$lists['use_captcha'] = JHTML::_('select.genericlist', $options, 'configuration[use_captcha]', ' class="input-medium form-control form-select" ', 'value', 'text', $configs->use_captcha);
		
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['enable_term_and_condition'] = JHtml::_('select.genericlist',$options,'configuration[enable_term_and_condition]','class="input-mini form-control form-select"','value','text',$configs->enable_term_and_condition);
		
		$paymentArr = array();
		$paymentArr[]  =  JHTML::_('select.option','Visa',JText::_('OS_VISA_CARD'));
		$paymentArr[]  =  JHTML::_('select.option','MasterCard',JText::_('OS_MASTER_CARD'));
		$paymentArr[]  =  JHTML::_('select.option','Discover',JText::_('OS_DISCOVER'));
		$paymentArr[]  =  JHTML::_('select.option','Amex',JText::_('OS_AMEX'));
		
		$enable_cardtypes = $configs->enable_cardtypes;
		$enable_cardtypes = explode(",",$enable_cardtypes);
		$lists['cardtypes'] = JHTML::_('select.genericlist',$paymentArr,'enable_cardtypes[]','class="inputbox form-control form-select" multiple','value','text',$enable_cardtypes);
		
		$sql = 'SELECT id, title FROM #__content WHERE `state` = 1 ORDER BY title ';
		$db->setQuery($sql) ;
		$rows = $db->loadObjectList();
		$options = array() ;
		$options[] = JHTML::_('select.option', '' ,'', 'id', 'title') ;
		$options = array_merge($options, $rows) ;		
		$lists['article_id'] = JHTML::_('select.genericlist', $options, 'configuration[article_id]', ' class="input-large form-control form-select" ', 'id', 'title', $configs->article_id) ;
		
		$options = array();
		$options[] = JHtml::_('select.option','1','1 000 000.00');
		$options[] = JHtml::_('select.option','2','1 000 000,00');
		$options[] = JHtml::_('select.option','3','1.000.000,00');
		$options[] = JHtml::_('select.option','4','1,000,000.00');
		$lists['price_format'] = JHtml::_('select.genericlist',$options,'configuration[price_format]','class="input-medium form-control form-select"','value','text',$configs->price_format);
		
		$options = array();
		$options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
		$options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
		$lists['allow_cancel'] = JHtml::_('select.genericlist',$options,'configuration[allow_cancel]','class="input-mini form-control form-select"','value','text',$configs->allow_cancel);
		
		$options = array(); 
		$options[] = JHtml::_('select.option','0',JText::_('Joomla Calendar'));
		$options[] = JHtml::_('select.option','1',JText::_('jQuery Calendar'));
		$lists['use_calendar'] = JHtml::_('select.genericlist',$options,'configuration[use_calendar]','class="input-medium form-control form-select"','value','text',$configs->use_calendar);

        $options = array();
        $options[] = JHtml::_('select.option','1',JText::_('OS_YES'));
        $options[] = JHtml::_('select.option','0',JText::_('OS_NO'));
        $lists['allow_room'] = JHtml::_('select.genericlist',$options,'configuration[allow_room]','class="input-mini form-control form-select"','value','text',$configs->allow_room);
		
		HTML_OsAppscheduleConfiguration::ConfigLayout($option,$configs,$lists);
	}
	
	
	/**
	 * save booking list
	 */
	public static function config_save($option,$save){
		global $app;
		$app = JFactory::getApplication();
		$input = $app->input;
		$db = JFactory::getDbo();
		$db->truncateTable('#__oscalendar_configuration');
		
		$element = $input->get('configuration',array(),'array');
		$values = array();
		foreach ($element as $key=>$value) {
			if (is_array($value)) $value = implode(',',$value);
			$values[] = $db->quote($key).",".$db->Quote($value);
		}
		
		$query = $db->getQuery(true);
		$query->clear()
				->insert('#__oscalendar_configuration')
				->columns('`config_key`, `config_value`')
				->values($values);
				;
		$query = $db->setQuery($query);
		$db->execute();
		
		$enable_cardtypes = $input->getString('enable_cardtypes','');
		if(count($enable_cardtypes) > 0){
			$enable_cardtypes  = implode(",",$enable_cardtypes);
			$db->setQuery("Insert into #__oscalendar_configuration (id,config_key,config_value) values (NULL,'enable_cardtypes', '$enable_cardtypes')");
			$db->execute();
		}
		
		$db->setQuery("Select config_value from #__oscalendar_configuration where config_key like 'enable_tax'");
		$enable_tax = $db->loadResult();
		if($enable_tax == 0){
			$db->setQuery("UPDATE #__oscalendar_configuration SET config_value = '0' WHERE config_key LIKE 'tax_payment'");
			$db->execute();
		}

		$db->setQuery("Delete from #__oscalendar_urls");
		$db->execute();
		
		$app->enqueueMessage(JText::_('OSC_CONFIGURATION_HAS_BEEN_SAVED'),'message');	
		if($save == 1){
			$app->redirect("index.php?option=".$option);
		}else{
			self::ConfigLayout($option);
		}
	}
}
?>