<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Tickets;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Utilities\ArrayHelper;
use OSL\View\ListView;
use OSSolution\HelpdeskPro\Admin\Model\Tickets;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskProHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

defined('_JEXEC') or die;

/***
 * @property Tickets $model
 */
class Html extends ListView
{
	use Common;

	/**
	 * Prepare view data
	 *
	 * @return bool
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		$user = Factory::getApplication()->getIdentity();

		// Category filter
		$filters = [];

		if (!$user->authorise('core.admin', 'com_helpdeskpro'))
		{
			$managedCategoryIds = HelpdeskProHelper::getTicketCategoryIds($user->username);
			$managedCategoryIds = ArrayHelper::toInteger($managedCategoryIds);

			$filters[] = 'id IN (' . implode(',', $managedCategoryIds) . ')';
		}

		$rows = HelpdeskProHelperDatabase::getAllCategories('title', $filters);

		$this->lists['filter_category_id'] = HelpdeskProHelperHtml::buildCategoryDropdown(
			$this->state->filter_category_id,
			'filter_category_id',
			'class="input-xlarge form-select" onchange="submit();"',
			$rows
		);

		$this->prepareDisplayData($this->state);

		return true;
	}

	/**
	 * Override addToolbar method to add custom toolbar for tickets management
	 */
	protected function addToolbar()
	{
		ToolbarHelper::title(Text::_('HDP_TICKET_MANAGEMENT'), 'link tickets');
		ToolbarHelper::addNew('ticket.add');

		if (isset($this->items[0]))
		{
			ToolbarHelper::editList('edit', 'JTOOLBAR_EDIT');
		}

		ToolbarHelper::deleteList(Text::_('HDP_DELETE_CONFIRM'), 'ticket.delete');
		ToolbarHelper::custom('ticket.export', 'download', 'download', 'Export Tickets', false);

		if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_helpdeskpro'))
		{
			ToolbarHelper::preferences('com_helpdeskpro');
		}
	}
}