<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

$app = Factory::getApplication();

$editor = Editor::getInstance($app->get('editor'));

$wa = $app->getDocument()
	->addScriptOptions('ticketsUrl', 'index.php?option=com_helpdeskpro&view=tickets')
	->getWebAssetManager()
	->useScript('keepalive');

$assetVersion = HelpdeskProHelper::getInstalledVersion();

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$wa->registerAndUseScript('com_helpdeskpro.helpdeskpro.bbcode', 'media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js', ['version' => $assetVersion]);
}

OSSolution\HelpdeskPro\Site\Helper\Jquery::validateForm();

$wa->registerAndUseScript('com_helpdeskpro.admin-ticket-form', 'media/com_helpdeskpro/js/admin-ticket-form.js', ['version' => $assetVersion]);
?>
<div class="hdp-container hpd-joomla4-container">
	<form class="form form-horizontal" name="adminForm" id="adminForm" action="index.php" method="post"
	      enctype="multipart/form-data">
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_NAME'); ?><span class="required">*</span></div>
			<div class="controls">
				<input type="text" id="name" name="name" placeholder="<?php echo Text::_('HDP_CUSTOMER_NAME'); ?>" class="input-xxlarge form-control validate[required]"/>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_EMAIL'); ?><span class="required">*</span></div>
			<div class="controls">
				<input type="text" id="email" name="email" placeholder="<?php echo Text::_('HDP_CUSTOMER_EMAIL'); ?>" class="input-xxlarge form-control validate[required,custom[email]]"/>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_CATEGORY'); ?><span
					class="required">*</span></div>
			<div class="controls">
				<?php echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['category_id']); ?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_SUBJECT'); ?><span
					class="required">*</span></div>
			<div class="controls">
				<input type="text" id="subject" name="subject" class="input-xxlarge form-control validate[required]" value="" size="50"/>
			</div>
		</div>
		<?php
		if (isset($this->lists['priority_id']))
		{
		?>
			<div class="control-group">
				<div class="control-label"><?php echo Text::_('HDP_PRIORITY'); ?><span
							class="required">*</span></div>
				<div class="controls">
					<?php echo $this->lists['priority_id']; ?>
				</div>
			</div>
		<?php
		}

		$fields = $this->form->getFields();

		// Make bootstrap helper works for Joomla 4 backend
		$this->bootstrapHelper->addClassMapping('control-group', 'control-group')
			->addClassMapping('control-label', 'control-label')
			->addClassMapping('controls', 'controls');

		/* @var HDPFormField $field*/
		foreach ($fields as $field)
		{
			echo $field->getControlGroup(true, $this->bootstrapHelper);
		}
		?>
		<div class="control-group">
			<div class="control-label"><?php echo Text::_('HDP_MESSAGE'); ?><span class="required">*</span></div>
			<div class="controls">
				<?php
				if ($this->config->use_html_editor)
				{
					echo $editor->display('message', '', '100%', '350', '75', '10', false);
				}
				else
				{
				?>
					<textarea rows="10" cols="70" name="message" class="hdp_fullwidth form-control validate[required]"></textarea>
				<?php
				}
				?>
			</div>
		</div>
		<?php
		if ($this->config->enable_attachment)
		{
		?>
			<div class="control-group">
				<div class="control-label"><?php echo Text::_('HDP_ATTACHMENTS'); ?></div>
				<div class="controls">
					<?php echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments_form.php'); ?>
				</div>
			</div>
		<?php
			echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_upload_attachments.php');
		}
		?>
		<div class="form-actions">
            <input type="submit" name="btnSubmit" id="btnSubmitButton" class="btn btn-primary" value="<?php echo Text::_('HDP_SUBMIT_TICKET'); ?>" />
			<input type="button" name="btnSubmit" id="btnCancelButton" class="btn btn-primary" value="<?php echo Text::_('HDP_CANCEL'); ?>" onclick="HDP.ticketList();"/>
		</div>
		<input type="hidden" name="option" value="com_helpdeskpro"/>
		<input type="hidden" name="task" value="ticket.save"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>