<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Activities;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\Model\State;
use OSL\View\HtmlView;
use OSSolution\HelpdeskPro\Admin\Model\Activities;

// no direct access
defined('_JEXEC') or die;

/***
 * @property Activities $model
 */
class Html extends HtmlView
{
	/**
	 * Activities data
	 *
	 * @var array
	 */
	protected $data;

	/**
	 * Model state
	 *
	 * @var State
	 */
	protected $state;

	/**
	 * Sidebar output
	 *
	 * @var string
	 */
	protected $sidebar;

	/**
	 * Users list
	 *
	 * @var array
	 */
	protected $userMap;

	/**
	 * List of select lists
	 *
	 * @var array
	 */
	protected $lists = [];

	/**
	 * Prepare view data
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		$state = $this->model->getState();
		$users = $this->model->getUsers();

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('Select User'), 'id', 'username');
		$options   = array_merge($options, $users);

		$this->lists['filter_user_id'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'filter_user_id',
			'onchange="submit();" class="form-select input-large"',
			'id',
			'username',
			$state->filter_user_id
		);

		$this->data = $this->model->getData();

		$userMap = [];

		foreach ($users as $user)
		{
			$userMap[$user->id] = $user->username;
		}

		$this->state   = $state;
		$this->userMap = $userMap;
	}
}