<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

new BreadcrumbsBar([
	new Breadcrumb(title:"Database", action:"ma.tables"),
	new Breadcrumb(title:$this->data("table"), action:"ma.browse&table=".$this->data("table")),
]);

$buttons = [];
switch (ChronoApp::$instance->action){
	case "ma.browse":
		$buttons = [];
		if(!empty(ChronoSession::get($this->data("table")."_search", []))){
			$buttons[] = new MenuButton(name: "clear", link: true, title: "Clear Search", icon: "magnifying-glass-minus", color: "orange", url: "action=ma.browse&clear_search&table=".$this->data("table"));
		}
		$buttons[] = new MenuButton(link: true, url: "action=ma.data.edit&table=".$this->data("table"), title: "Insert", color:"blue", icon:"plus");
		break;
	case "ma.data.edit":
		$buttons = [
			new MenuButton(name: "save", title: "Save", icon: "floppy-disk", color: "blue"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.browse&table=".$this->data("table")),
		];
		break;
	case "ma.data.delete":
		$buttons = [
			new MenuButton(name: "delete", title: "Delete Row", icon: "trash", color: "red inverted"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.browse&table=".$this->data("table")),
		];
		break;
	case "ma.structure":
		$buttons = [
			new MenuButton(link: true, url: "action=ma.field.edit&table=".$this->data("table"), title: "Add Column", color:"blue", icon:"plus"),
			new MenuButton(link: true, url: "action=ma.index.edit&table=".$this->data("table"), title: "Add Index", color:"blue", icon:"plus"),
		];
		break;
	case "ma.field.edit":
		$buttons = [
			new MenuButton(name: "save", title: "Save", icon: "floppy-disk", color: "blue"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.structure&table=".$this->data("table")),
		];
		break;
	case "ma.field.delete":
		$buttons = [
			new MenuButton(name: "delete", title: "Drop field", icon: "trash", color: "red inverted"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.structure&table=".$this->data("table")),
		];
		break;
	case "ma.index.edit":
		$buttons = [
			new MenuButton(name: "save", title: "Save", icon: "floppy-disk", color: "blue"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.structure&table=".$this->data("table")),
		];
		break;
	case "ma.index.delete":
		$buttons = [
			new MenuButton(name: "delete", title: "Drop field", icon: "trash", color: "red inverted"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.structure&table=".$this->data("table")),
		];
		break;
	case "ma.truncate":
		$buttons = [
			new MenuButton(name: "delete", title: "Truncate", icon: "trash", color: "red inverted"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.operations&table=".$this->data("table")),
		];
		break;
	case "ma.drop":
		$buttons = [
			new MenuButton(name: "delete", title: "Drop Table", icon: "trash", color: "red inverted"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.operations&table=".$this->data("table")),
		];
		break;
	case "ma.search":
		$buttons = [
			new MenuButton(name: "search", title: "Search", icon: "magnifying-glass", color: "blue"),
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.structure&table=".$this->data("table")),
		];
		break;
	case "ma.export":
		$buttons = [
			new MenuButton(name: "close", link: true, title: "Close", icon: "xmark", color: "red", url: "action=ma.operations&table=".$this->data("table")),
		];
		break;
}

new MenuBar(title: $this->data("table"), buttons: $buttons, tabs:[
	new MenuTab(title:"Browse", action:"ma.browse&table=".$this->data("table"), active: (ChronoApp::$instance->action == "ma.browse")),
	new MenuTab(title:"Structure", action:"ma.structure&table=".$this->data("table"), active: (ChronoApp::$instance->action == "ma.structure")),
	new MenuTab(title:"Search", action:"ma.search&table=".$this->data("table"), active: (ChronoApp::$instance->action == "ma.search")),
	new MenuTab(title:"Operations", action:"ma.operations&table=".$this->data("table"), active: (ChronoApp::$instance->action == "ma.operations")),
]);