<?php

/**
 * @package Fiinion
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

use Joomla\CMS\Language\Text;

//no direct accees
defined('_JEXEC') or die('resticted aceess');

SpAddonsConfig::addonConfig(
	array(
		'type' => 'repeatable',
		'addon_name' => 'sp_finatic_services',
		'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES'),
		'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_DESC'),
		'settings' => array(
			'content' => [
				'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
				'fields' => [
					'finatic_service_carousel' => array(
						'type' => 'checkbox',
						'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CAROUSEL'),
						'std' => 0,
					),
					'finatic_service_grid_layout' => array(
						'type' => 'checkbox',
						'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_GRID_LAYOUT'),
						'std' => 0,
					),
					'columns' => array(
						'type' => 'number',
						'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_COLUMNS'),
						'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_COLUMNS_DESC'),
						'placeholder' => '3',
					),

					// Repeatable Item
					'finatic_service' => array(
						'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_ITEMS'),
						'type' => 'repeatable',
						'attr' => array(
							//service image
							'finatic_service_image' => array(
								'type' => 'media',
								'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICE_IMAGE_CONTENT'),
							),

							//service title
							'finatic_service_title' => array(
								'type' => 'text',
								'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICE_TITLE'),
								'placeholder' => 'Personal Finance',
							),

							'finatic_service_items' => array(
								'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICE_ITEMS'),
								'type' => 'repeatable',
								'attr' => [
									'content' => [
										'title' => 'Finatic Service Item',
										'fields' => [
											//Title Content
											'item_title' => array(
												'type' => 'textarea',
												'title' => Text::_('COM_SPPAGEBUILDER_JS_SLIDER_TITLE_CONTENT'),
												'std' => 'Retirement Planning'
											),

											//Image Content
											'choose_option' => array(
												'type' => 'select',
												'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CHOOSE_OPTIONS'),
												'values' => array(
													'icon' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CHOOSE_OPTIONS_ICON'),
													'custom_icon' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CHOOSE_OPTIONS_CUSTOM_ICON'),
													'image' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CHOOSE_OPTIONS_IMAGE')
												),
												'std' => 'custom_icon'
											),
											'item_image' => array(
												'type' => 'media',
												'title' => Text::_('COM_SPPAGEBUILDER_JS_SLIDER_IMAGE_CONTENT'),
												'std' => '',
												'depends' => array(
													array('choose_option', '=', 'image')
												),
											),
											'item_icon' => array(
												'type' => 'icon',
												'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON_NAME'),
												'std' => 'fa-cogs',
												'depends' => array(
													array('choose_option', '=', 'icon')
												),
											),
											'item_custom_icon' => array(
												'type' => 'text',
												'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICES_CHOOSE_OPTIONS_CUSTOM_ICON_FIELD'),
												'std' => 'fn-career',
												'depends' => array(
													array('choose_option', '=', 'custom_icon')
												),
											),
											'item_link' => array(
												'type' => 'text',
												'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICE_ITEM_URL'),
												'placeholder' => 'http://',
												'placeholder' => '#'
											),
										]

									],

								],
							),

							//service button
							'finatic_service_btn_content' => array(
								'type' => 'text',
								'title' => Text::_('COM_SPPAGEBUILDER_ADDON_FINATIC_SERVICE_TITLE_BUTTON'),
								'placeholder' => 'All Personal Services',
							),

							'finatic_service_button_url' => array(
								'type' => 'text',
								'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
								'desc' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
								'placeholder' => 'http://',
								'placeholder' => '#'
							),
						)
					),

					'class' => array(
						'type' => 'text',
						'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
						'desc' => Text::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
						'std' => ''
					),
				]
			],
		)
	)
);
