<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class HelixUltimateFeatureLogo
{
    
    private $params;
    public $position;
    
    public function __construct($params)
    {
        $this->params = $params;
        $this->position = 'logo';
    }
    
    public function renderFeature()
    {
        
        $template_name = Factory::getApplication()->getTemplate();
        $menu_type = $this->params->get('menu_type');
        $doc = Factory::getDocument();

        $presetVars = (array) json_decode($this->params->get('preset'));
        $preset = (isset($presetVars['preset']) && $presetVars['preset']) ? $presetVars['preset'] : 'default';
        
        if ($this->params->get('logo_type') == 'image') {
            if ($this->params->get('logo_image'))
			{
                $path = \JPATH_ROOT . '/' . $this->params->get('logo_image');
			}
			else
			{
                $path = \JPATH_ROOT . '/templates/' . $template_name . '/images/presets/' . $preset . '/logo.svg';
            }
        }
        
        $html = '';
        
        
        $custom_logo_class = '';
        $sitename = Factory::getApplication()->get('sitename');
        
		if ($this->params->get('mobile_logo'))
		{
            $custom_logo_class = ' d-none d-lg-inline-block';
        }
        
		if ($this->params->get('logo_type') == 'image')
		{
			if ($this->params->get('logo_image'))
			{
                $html .= '<div class="logo">';
                $html .= '<a href="' . Uri::base(true) . '/">';
                
                $html .= '<img class="logo-image' . $custom_logo_class . '" src="' . $this->params->get('logo_image') . '" alt="' . $sitename . '">';
                
				if ($this->params->get('mobile_logo'))
				{
                    $html .= '<img class="logo-image-phone d-inline-block d-lg-none" src="' . $this->params->get('mobile_logo') . '" alt="' . $sitename . '">';
                }
                
                $html .= '</a>';
                if ($this->params->get('logo_image_slogan'))
                {
                    $html .= '<span class="logo-slogan">' . $this->params->get('logo_image_slogan') . '</span>';
                }
                $html .= '</div>';
			}
			else
			{
                $html .= '<div class="logo">';
                $html .= '<a href="' . Uri::base(true) . '/">';
                
                $html .= '<img class="logo-image' . $custom_logo_class . '" src="' . Uri::base(true) . '/templates/' . $template_name . '/images/presets/' . $preset . '/logo.svg" alt="' . $sitename . '">';
                
				if ($this->params->get('mobile_logo'))
				{
                    $html .= '<img class="logo-image-phone d-inline-block d-lg-none" src="' . $this->params->get('mobile_logo') . '" alt="' . $sitename . '">';
				}
				
                $html .= '</a>';
                if ($this->params->get('logo_image_slogan'))
                {
                    $html .= '<span class="logo-slogan">' . $this->params->get('logo_image_slogan') . '</span>';
                }
                $html .= '</div>';
            }

            if($logo_height = $this->params->get('logo_height'))
            {
                $logoStyle = '.logo-image {height:' . $logo_height. 'px;}';
                $logoStyle .= '.logo-image-phone {height:' . $logo_height. 'px;}';
                $doc->addStyledeclaration($logoStyle);
            }
            
		}
		else
		{
			if ($this->params->get('logo_text'))
			{
                $html .= '<span class="logo"><a href="' . Uri::base(true) . '/">' . $this->params->get('logo_text') . '</a></span>';
			}
			else
			{
                $html .= '<span class="logo"><a href="' . Uri::base(true) . '/">' . $sitename . '</a></span>';
			}
			
			if ($this->params->get('logo_slogan'))
			{
                $html .= '<span class="logo-slogan">' . $this->params->get('logo_slogan') . '</span>';
            }
        }
        
        return $html;
    }
    
}
