<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace Joomla\Plugin\Task\HDPAutoCloseTicket\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Component\Scheduler\Administrator\Event\ExecuteTaskEvent;
use Joomla\Component\Scheduler\Administrator\Task\Status as TaskStatus;
use Joomla\Component\Scheduler\Administrator\Traits\TaskPluginTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\SubscriberInterface;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

final class HDPAutoCloseTicket extends CMSPlugin implements SubscriberInterface
{
	use TaskPluginTrait;
	use DatabaseAwareTrait;

	/**
	 * @var string[]
	 *
	 * @since 4.1.0
	 */
	protected const TASKS_MAP = [
		'hdpauttocloseticket.closeTickets' => [
			'langConstPrefix' => 'PLG_TASK_AUTO_CLOSE_TICKET_TASK_CLOSE_TICKETS',
			'form'            => 'auto_close_ticket',
			'method'          => 'closeTickets',
		],
	];

	/**
	 * Constructor.
	 *
	 * @param   DispatcherInterface  $dispatcher     The dispatcher
	 * @param   array                $config         An optional associative array of configuration settings
	 * @param   string               $rootDirectory  The root directory to look for images
	 *
	 */
	public function __construct(DispatcherInterface $dispatcher, array $config)
	{
		parent::__construct($dispatcher, $config);

		$this->loadLanguage();
	}

	/**
	 * @inheritDoc
	 *
	 * @return string[]
	 *
	 * @since 4.1.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onTaskOptionsList'    => 'advertiseRoutines',
			'onExecuteTask'        => 'standardRoutineHandler',
			'onContentPrepareForm' => 'enhanceTaskItemForm',
		];
	}

	/**
	 * Delete old invoices PDF to save storage spaces
	 *
	 * @param   ExecuteTaskEvent  $event  The onExecuteTask event
	 *
	 * @return integer  The exit code
	 */
	protected function closeTickets(ExecuteTaskEvent $event): int
	{
		// Bootstrap the component
		require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/bootstrap.php';

		$delay              = (int) $event->getArgument('params')->delay ?? 10;
		$config             = HelpdeskProHelper::getConfig();
		$closedTicketStatus = $config->closed_ticket_status;

		$db          = $this->getDatabase();
		$currentDate = $db->quote(Factory::getDate()->toSql());
		$query       = $db->getQuery(true)
			->update('#__helpdeskpro_tickets')
			->set('status_id = ' . (int) $closedTicketStatus)
			->where("DATEDIFF($currentDate , modified_date) >= " . (int) $delay)
			->where('status_id != ' . (int) $closedTicketStatus);
		$db->setQuery($query)
			->execute();

		return TaskStatus::OK;
	}
}