<?php
/**
 * @package   ShackErrorNotify
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2020-2023 Joomlashack.com. All rights reserved
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of ShackErrorNotify.
 *
 * ShackErrorNotify is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ShackErrorNotify is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ShackErrorNotify.  If not, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die();

if (!empty($trace)) :
    $types = array(
        'S' => '::',
        'D' => '->'
    );
    $na = Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_NA');
    ?>
    <br>
    <br>
    <table>
        <thead>
        <tr style="background-color: #ccc;">
            <th><?php echo Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_TRACE_TYPE'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_TRACE_FUNCTION'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_TRACE_CLASS'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_TRACE_LINE'); ?></th>
            <th><?php echo Text::_('PLG_SYSTEM_SHACKERRORNOTIFY_TRACE_FILE'); ?></th>
        </tr>
        </thead>

        <tbody>
        <?php
        foreach ($trace as $idx => $called) :
            $type = empty($called['type']) ? $na : array_search($called['type'], $types);
            $class = empty($called['class']) ? $na : $called['class'];
            $line = empty($called['line']) ? $na : $called['line'];
            $file = empty($called['file']) ? $na : str_replace(JPATH_SITE, '', $called['file']);
            ?>
            <tr style="background-color: <?php echo ($idx % 2) ? '#eee' : '#fff'; ?>">
                <td style="padding: 5px;"><?php echo $type; ?></td>
                <td style="padding: 5px;"><?php echo $called['function']; ?></td>
                <td style="padding: 5px;"><?php echo $class; ?></td>
                <td style="padding: 5px; text-align: right"><?php echo $line; ?></td>
                <td style="padding: 5px;"><?php echo $file; ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php
endif;

